/*!
  \file
  This is the header file for a CUDAmaniple.
*/

#ifndef SCIGPU_LEGION_CUDAMANIPLE_HPP
#define SCIGPU_LEGION_CUDAMANIPLE_HPP

#include "legion.hpp"

namespace SciGPU {

  namespace Legion {

    //! A Maniple which can use a GPU with CUDA
    /*!
      Objects of this class manage a single CUDA
      context.
      The constructor takes one argument - the ID
      (as reported by the CUDA runtime) of the
      GPU the object should manage.
      The Maniple::ApproveType method is over-ridden
      to accept objects of type AnyTask and CUDAtask.
      The Maniple::ApproveTask method is also
      over-ridden, to check the thread ID desired by
      and CUDAtask objects found.
    */
    class CUDAmaniple : public Maniple {
    public:
      //! Constructor with CUDA GPU id
      CUDAmaniple( const int gpu=0 ) : Maniple(),
				       gpuID(gpu) {};

      //! Destructor
      ~CUDAmaniple( void ) {};

      //! The ID of the GPU we're using
      int gpuID;

    protected:

      //! Initialisation method to acquire a GPU
      virtual void Initialise( void );

      //! Finalisation method to release the GPU
      virtual void Finalise( void );

      //! Method to select AnyTask and CUDAtask objects
      virtual bool ApproveType( const Task& theTask );

      //! Method to check the context for CUDAtask objects
      virtual bool ApproveTask( const Task& theTask );

    private:

    };

  }
}

#endif
