/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWStatusBar;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandPanel;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.util.DTClientLink;
import com.mathworks.util.QueueEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MWFrameProxy
extends Container
implements MWFocusChain {
    private MWFrame fFrame = null;
    private DTClientLink fDTClient = null;
    private MWWindowOwner fOwner = null;
    private int fFrameX = 0;
    private int fFrameY = 0;
    private int fFrameWidth = 0;
    private int fFrameHeight = 0;
    private int fMinimumWidth = 0;
    private int fMinimumHeight = 0;
    private int fMaximumWidth = Integer.MAX_VALUE;
    private int fMaximumHeight = Integer.MAX_VALUE;
    private String fTitle = null;
    private MWMenuBar fMenuBar = null;
    private MWToolbar fToolbar = null;
    private MWStatusBar fStatusBar = null;
    private Image fIconImage = null;
    private boolean fActive;
    static final int BEEP_CMD = 100;
    static final int LOCATION_CMD = 101;
    static final int SIZE_CMD = 102;
    static final int TITLE_CMD = 103;
    static final int CLOSE_CMD = 104;
    static final int MB1_CMD = 105;
    static final int MB2_CMD = 106;

    public MWFrameProxy(MWWindowOwner mWWindowOwner, String string) {
        this.setLayout(new BorderLayout());
        this.fOwner = mWWindowOwner;
        this.fTitle = string;
    }

    public void realizeStandaloneFrame() {
        this.fFrame = new MWFrame(this.fTitle);
        this.fFrame.setLocation(this.fFrameX, this.fFrameY);
        this.fFrame.setContentSize(this.fFrameWidth, this.fFrameHeight);
        this.fFrame.addWindowListener(new MWFrameProxyWindowAdapter());
        this.fFrame.addComponentListener(new MWFrameProxyComponentAdapter());
        this.fFrame.add((Component)this, "Center");
        if (this.fMenuBar != null) {
            this.fFrame.setMWMenuBar(this.fMenuBar);
        }
        if (this.fToolbar != null) {
            this.fFrame.add((Component)this.fToolbar, "North");
        }
        if (null != this.fIconImage) {
            this.fFrame.setIconImage(this.fIconImage);
        }
        this.fFrame.setVisible(true);
    }

    public void setDTClient(DTClientLink dTClientLink) {
        this.fDTClient = dTClientLink;
    }

    public DTClientLink getDTClient() {
        return this.fDTClient;
    }

    public void setStatusText(String string) {
        if (this.fDTClient != null) {
            this.fDTClient.setStatusText(string);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.fDTClient == null && this.fFrame == null) {
            this.realizeStandaloneFrame();
        }
        if (this.fFrame != null) {
            this.fFrame.setVisible(bl);
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.fFrame != null) {
            return this.fFrame.isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void show() {
        if (null != this.fFrame) {
            this.fFrame.setVisible(true);
        } else {
            super.show();
        }
    }

    @Override
    public void hide() {
        if (null != this.fFrame) {
            this.fFrame.setVisible(false);
        } else {
            super.hide();
        }
    }

    public void dispose() {
        if (this.fFrame != null) {
            this.fFrame.dispose();
            this.fFrame = null;
        } else if (this.fDTClient != null) {
            if (MWUtils.isAWTEventQueueThread()) {
                this.fDTClient.destroyAndRemove();
                this.fDTClient = null;
            } else {
                QueueEvent.postAndWait((QueueEvent)new QueueEvent(){

                    public void dispatch() {
                        MWFrameProxy.this.fDTClient.destroyAndRemove();
                        MWFrameProxy.this.fDTClient = null;
                    }
                });
            }
        }
    }

    public void toFront() {
        if (this.fFrame != null) {
            this.fFrame.toFront();
        } else if (this.fDTClient != null) {
            this.fDTClient.restore(true);
        }
    }

    public void toFrontNoActivate() {
        if (this.fDTClient != null) {
            this.fDTClient.show();
        }
    }

    public void setFrameLocation(int n, int n2) {
        this.fFrameX = n;
        this.fFrameY = n2;
        if (this.fFrame != null) {
            this.fFrame.setLocation(this.fFrameX, this.fFrameY);
        }
    }

    public Point getFrameLocation() {
        if (this.fFrame != null) {
            return this.fFrame.getLocation();
        }
        return new Point(this.fFrameX, this.fFrameY);
    }

    public void setFrameSize(int n, int n2) {
        this.fFrameWidth = Math.min(Math.max(n, this.fMinimumWidth), this.fMaximumWidth);
        this.fFrameHeight = Math.min(Math.max(n2, this.fMinimumHeight), this.fMaximumHeight);
        if (this.fFrame != null) {
            this.fFrame.setContentSize(this.fFrameWidth, this.fFrameHeight);
        }
    }

    public Dimension getFrameSize() {
        if (this.fFrame != null) {
            return this.fFrame.getSize();
        }
        return new Dimension(this.fFrameWidth, this.fFrameHeight);
    }

    public void setFrameLimits(int n, int n2, int n3, int n4) {
        this.fMinimumWidth = Math.max(n, 0);
        this.fMinimumHeight = Math.max(n2, 0);
        this.fMaximumWidth = Math.max(n3, this.fMinimumWidth);
        this.fMaximumHeight = Math.max(n4, this.fMinimumHeight);
        this.checkFrameSize();
    }

    private void checkFrameSize() {
        boolean bl = false;
        if (this.fFrame != null) {
            Dimension dimension = this.getSize();
            this.fFrameWidth = dimension.width;
            this.fFrameHeight = dimension.height;
            if (this.fToolbar != null) {
                this.fFrameHeight += this.fToolbar.getSize().height;
            }
        }
        if (this.fFrameWidth < this.fMinimumWidth) {
            this.fFrameWidth = this.fMinimumWidth;
            bl = true;
        } else if (this.fFrameWidth > this.fMaximumWidth) {
            this.fFrameWidth = this.fMaximumWidth;
            bl = true;
        }
        if (this.fFrameHeight < this.fMinimumHeight) {
            this.fFrameHeight = this.fMinimumHeight;
            bl = true;
        } else if (this.fFrameHeight > this.fMaximumHeight) {
            this.fFrameHeight = this.fMaximumHeight;
            bl = true;
        }
        if (bl && this.fFrame != null) {
            this.fFrame.setContentSize(this.fFrameWidth, this.fFrameHeight);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.fMinimumWidth, this.fMinimumHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.fMaximumWidth, this.fMaximumHeight);
    }

    public void setTitle(String string) {
        this.fTitle = string;
        if (null != this.fFrame) {
            this.fFrame.setTitle(this.fTitle);
        } else if (null != this.fDTClient) {
            this.fDTClient.setTitle(this.fTitle);
        }
    }

    public void setStatusBar(MWStatusBar mWStatusBar) {
        if (this.fStatusBar != mWStatusBar) {
            this.fStatusBar = mWStatusBar;
        }
        if (this.fFrame == null && this.fDTClient != null && this.fActive) {
            this.fDTClient.setStatusBar((Object)mWStatusBar);
        }
    }

    public MWStatusBar getStatusBar() {
        return this.fStatusBar;
    }

    public String getTitle() {
        if (this.fFrame != null) {
            return this.fFrame.getTitle();
        }
        return this.fTitle;
    }

    public void setMenuBar(MWMenuBar mWMenuBar) {
        this.fMenuBar = mWMenuBar;
        if (this.fFrame != null) {
            this.fFrame.setMWMenuBar(this.fMenuBar);
        }
    }

    public MWMenuBar getMenuBar() {
        return this.fMenuBar;
    }

    public void setToolbar(MWToolbar mWToolbar) {
        if (this.fToolbar != null && this.fFrame != null) {
            this.fFrame.remove(this.fToolbar);
        }
        this.fToolbar = mWToolbar;
        if (this.fFrame != null) {
            this.fFrame.add((Component)this.fToolbar, "North");
        }
    }

    public MWToolbar getToolbar() {
        return this.fToolbar;
    }

    public void setActive(boolean bl) {
        this.fActive = bl;
    }

    @Override
    public void focusEvent(FocusEvent focusEvent) {
        if (this.fDTClient != null && !focusEvent.isTemporary()) {
            if (focusEvent.getID() == 1004) {
                this.fDTClient.setActive(true);
            }
        } else {
            MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
            if (mWFocusChain != null) {
                mWFocusChain.focusEvent(focusEvent);
            }
        }
    }

    @Override
    public void focusMousePressed(MouseEvent mouseEvent) {
        if (this.fDTClient != null) {
            this.fDTClient.activate();
        } else {
            MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
            if (mWFocusChain != null) {
                mWFocusChain.focusMousePressed(mouseEvent);
            }
        }
    }

    @Override
    public void focusSwitch(KeyEvent keyEvent) {
        boolean bl = false;
        boolean bl2 = false;
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if ((n & 0xE) != 0) {
            bl = n == 2;
            boolean bl3 = bl2 = bl || n == 1;
        }
        if (this.fDTClient != null && n2 != 33 && n2 != 34) {
            if (bl2) {
                this.fDTClient.activateNextClient(true);
            } else {
                this.fDTClient.activateNextClient(false);
            }
        } else {
            MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
            if (mWFocusChain != null) {
                mWFocusChain.focusSwitch(keyEvent);
            }
        }
    }

    public void setIconImage(Image image) {
        this.fIconImage = image;
    }

    public Image getIconImage() {
        return this.fIconImage;
    }

    private void closeFrame() {
        if (this.fOwner != null && this.fOwner.closeWindow() == 0) {
            this.fOwner = null;
        }
    }

    private void activateFrame(boolean bl) {
        this.fActive = bl;
        if (this.fOwner != null) {
            this.fOwner.setActive(bl);
        }
    }

    public boolean isFrameActive() {
        if (this.fFrame != null) {
            return this.fFrame.isFrameActive();
        }
        return this.fActive;
    }

    public static void test() {
        try {
            new TestPane();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        MWFrameProxy.test();
    }

    private static class TestPane
    extends MWCommandPanel
    implements MWWindowOwner {
        private static final Color ACTIVE_COLOR = Color.red;
        private static final Color INACTIVE_COLOR = Color.pink;
        private MWFrameProxy fProxy;
        private MWMenuBar fMenuBar1;
        private MWMenuBar fMenuBar2;

        public TestPane() {
            this.setCommandCenter(new MWCommandCenter(this));
            this.setBackground(INACTIVE_COLOR);
            this.fMenuBar1 = new MWMenuBar(this.getCommandCenter());
            MWMenu mWMenu = this.fMenuBar1.addMenu("Test");
            mWMenu.addMenuItem("Beep", 100);
            mWMenu.addMenuItem("Location", 101);
            mWMenu.addMenuItem("Size", 102);
            mWMenu.addMenuItem("Title", 103);
            mWMenu.addMenuItem("Swap", 106);
            mWMenu.addMenuItem("Close", 104, 87);
            this.fMenuBar2 = new MWMenuBar(this.getCommandCenter());
            mWMenu = this.fMenuBar2.addMenu("Alternate");
            mWMenu.addMenuItem("Swap", 105);
            MWToolbar mWToolbar = new MWToolbar(this.getCommandCenter());
            mWToolbar.addImageButton("/com/mathworks/mwt/resources/matlabicon.gif", 100);
            this.fProxy = new MWFrameProxy(this, "Test");
            this.fProxy.setFrameLocation(40, 60);
            this.fProxy.setFrameSize(200, 200);
            this.fProxy.setFrameLimits(50, 50, 400, Integer.MAX_VALUE);
            this.fProxy.setMenuBar(this.fMenuBar1);
            this.fProxy.setToolbar(mWToolbar);
            this.fProxy.add(this);
            this.fProxy.show();
        }

        @Override
        public int closeWindow() {
            this.fProxy.dispose();
            return 0;
        }

        @Override
        public void setActive(boolean bl) {
            if (bl) {
                this.setBackground(ACTIVE_COLOR);
            } else {
                this.setBackground(INACTIVE_COLOR);
            }
            this.repaint(5L);
        }

        @Override
        public String getShortName() {
            return "Lee";
        }

        @Override
        public String getLongName() {
            return "Mr. Lee Fyock";
        }

        @Override
        public void doCommand(int n) {
            switch (n) {
                case 104: {
                    this.closeWindow();
                    break;
                }
                case 101: {
                    this.fProxy.setFrameLocation(40, 60);
                    break;
                }
                case 102: {
                    this.fProxy.setFrameSize(200, 200);
                    break;
                }
                case 103: {
                    this.fProxy.setTitle("Changed");
                    break;
                }
                case 100: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case 105: {
                    this.fProxy.setMenuBar(this.fMenuBar1);
                    break;
                }
                case 106: {
                    this.fProxy.setMenuBar(this.fMenuBar2);
                }
            }
        }
    }

    private class MWFrameProxyComponentAdapter
    extends ComponentAdapter {
        private MWFrameProxyComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MWFrameProxy.this.checkFrameSize();
        }
    }

    private class MWFrameProxyWindowAdapter
    extends WindowAdapter {
        private MWFrameProxyWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            MWFrameProxy.this.closeFrame();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            MWFrameProxy.this.activateFrame(false);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MWFrameProxy.this.activateFrame(true);
        }
    }
}

