/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWBorderLayout;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.util.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;

public class MWToolTip
extends MWPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
Floater {
    private static WeakReference<MWToolTip> sLastListener = new WeakReference<Object>(null);
    private Rectangle fPaintBounds;
    private static long sTipUpTime;
    private static Timer sTimer;
    private static MWToolTip sCurrentTip;
    private static final int TIMER_PERIOD = 100;
    private static final int TIP_WAIT_TIME = 1000;
    private static final int TIP_UP_TIME = 5000;
    private static final int TIP_WAS_TIME = 500;
    private static final Color backgroundColor;
    private Window fWindow;
    private boolean fShowing;
    private Component fThing;
    private String fText;
    private Rectangle fRect;
    private boolean fDontShow;
    private long fOnTime;
    private boolean fWantsToShow;
    private Point fShowLocation;
    private long fWantTime;
    private boolean fListeningToTimer;

    private void showToolTip() {
        Object object;
        Window window;
        if (sCurrentTip != null) {
            sCurrentTip.hideToolTip();
        }
        if ((window = MWUtils.getTopLevelWindow(this.fThing)) != this.fWindow) {
            if (this.fWindow != null) {
                this.fWindow.remove(this);
            }
            this.fWindow = window;
            if (this.fWindow == null) {
                return;
            }
            object = this.fWindow.getLayout();
            if (object instanceof MWBorderLayout) {
                this.fWindow.add(this, "Floating", 0);
            } else {
                this.fWindow.add((Component)this, 0);
            }
        }
        if (this.fWindow instanceof MWFrame && !((MWFrame)this.fWindow).isFrameActive()) {
            return;
        }
        if (this.fText == null || this.fText.length() == 0) {
            return;
        }
        try {
            object = this.fThing.getLocationOnScreen();
            Point point = new Point();
            point.x = this.fShowLocation.x + ((Point)object).x;
            point.y = this.fShowLocation.y + ((Point)object).y + 15;
            Rectangle rectangle = this.fWindow.getBounds();
            Point point2 = this.fWindow.getLocationOnScreen();
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            FontMetrics fontMetrics = this.getFontMetrics(this.fWindow.getFont());
            this.setBounds(point.x - 4 - rectangle.x, point.y + 5 - rectangle.y, this.maxStringWidth(fontMetrics) + 8, fontMetrics.getHeight() * this.getLineCount() - fontMetrics.getLeading() + 8);
            Rectangle rectangle2 = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Insets insets = this.fWindow.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle2.translate(rectangle.x + rectangle.width - rectangle2.x - rectangle2.width, 0);
            }
            if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle2.translate(0, rectangle.y + rectangle.height - rectangle2.y - rectangle2.height);
            }
            if (rectangle2.x < rectangle.x) {
                rectangle2.translate(rectangle.x - rectangle2.x, 0);
            }
            if (rectangle2.y < rectangle.y) {
                rectangle2.translate(0, rectangle.y - rectangle2.y);
            }
            this.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.setVisible(true);
            this.fShowing = true;
            this.fWantsToShow = false;
            this.fOnTime = System.currentTimeMillis();
            sCurrentTip = this;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void hideToolTip() {
        LayoutManager layoutManager;
        this.fShowing = false;
        this.setVisible(false);
        sTipUpTime = System.currentTimeMillis();
        sCurrentTip = null;
        if (this.fWindow != null && !((layoutManager = this.fWindow.getLayout()) instanceof MWBorderLayout) && this.fPaintBounds != null) {
            this.fWindow.repaint(this.fPaintBounds.x, this.fPaintBounds.y, this.fPaintBounds.width, this.fPaintBounds.height);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fDontShow) {
            return;
        }
        if (this.fShowing && System.currentTimeMillis() - this.fOnTime > 5000L) {
            this.hideToolTip();
        } else if (!this.fShowing && this.fWantsToShow && (System.currentTimeMillis() - this.fWantTime > 1000L || System.currentTimeMillis() - sTipUpTime < 500L)) {
            this.showToolTip();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.fDontShow) {
            return;
        }
        if (this.fRect.isEmpty() || this.fRect.contains(mouseEvent.getPoint())) {
            if (!this.fShowing && !this.fWantsToShow) {
                this.fWantsToShow = true;
                this.fWantTime = System.currentTimeMillis();
            }
        } else if (this.fShowing) {
            this.hideToolTip();
        }
        this.fShowLocation = mouseEvent.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fShowing) {
            this.hideToolTip();
        }
        this.fWantsToShow = false;
        MWToolTip.removeListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fShowing) {
            this.hideToolTip();
        }
        this.fDontShow = true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.fDontShow = false;
        if (!this.fListeningToTimer) {
            MWToolTip.setListener(this);
            this.fListeningToTimer = true;
        }
        this.fShowLocation = mouseEvent.getPoint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void show(Component component, int n, int n2) {
    }

    @Override
    public boolean getAutoCollapse() {
        return true;
    }

    @Override
    public void collapse() {
        this.hideToolTip();
    }

    @Override
    public void setFloaterOwner(FloaterOwner floaterOwner) {
    }

    @Override
    public FloaterOwner getFloaterOwner() {
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle;
        Graphics graphics2 = this.fWindow.getGraphics();
        FontMetrics fontMetrics = this.getFontMetrics(this.fWindow.getFont());
        this.fPaintBounds = rectangle = this.getBounds();
        graphics2.setColor(backgroundColor);
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        int n = rectangle.x + 4;
        int n2 = rectangle.y + fontMetrics.getAscent() + 4;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.fText.length();
        int n6 = fontMetrics.getHeight();
        int n7 = this.getLineCount();
        while (n4 < n5) {
            for (n4 = n3; n4 < n5 && this.fText.charAt(n4) != '\n' && this.fText.charAt(n4) != '\r'; ++n4) {
            }
            graphics2.drawString(this.fText.substring(n3, n4), n, n2);
            n3 = ++n4;
            n2 += n6;
        }
        graphics2.dispose();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.fListeningToTimer = false;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        this.fText = string;
    }

    public MWToolTip(Component component, String string, Rectangle rectangle) {
        this.setOpaque(true);
        this.setVisible(false);
        this.setSize(50, 20);
        this.fThing = component;
        this.fText = string;
        this.fRect = rectangle;
        this.fThing.addMouseMotionListener(this);
        this.fThing.addMouseListener(this);
        if (sTimer == null) {
            sTimer = new Timer(100, "MWToolTip");
            sTimer.setIsRepeating(true);
            sTimer.start();
        }
    }

    public MWToolTip(Component component, String string, int n, int n2, int n3, int n4) {
        this(component, string, new Rectangle(n, n2, n3, n4));
    }

    public MWToolTip(Component component, String string) {
        this(component, string, 0, 0, component.getSize().width, component.getSize().height);
    }

    public void disposeToolTip() {
        if (this.fThing != null) {
            if (this.fShowing) {
                this.hideToolTip();
            }
            this.fThing.removeMouseMotionListener(this);
            this.fThing.removeMouseListener(this);
            sTimer.removeActionListener((ActionListener)this);
            this.fThing = null;
        }
    }

    public static void main(String[] stringArray) {
        MWFrame mWFrame = new MWFrame("ToolTip Tester");
        mWFrame.setSize(540, 350);
        MWToolTip mWToolTip = new MWToolTip(mWFrame, "Here's a tooltip!", 20, 20, 100, 100);
        mWFrame.addWindowListener(new MWWindowActivater(mWToolTip));
        mWFrame.addComponentListener(new MWWindowResizer(500, 150, true));
        mWFrame.show();
    }

    private int getLineCount() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = this.fText.length();
        if (n3 == 0) {
            return 0;
        }
        while (n3 > 0 && (this.fText.charAt(n3 - 1) == '\n' || this.fText.charAt(n3 - 1) == '\r')) {
            --n3;
        }
        if (n3 == 0) {
            n3 = this.fText.length();
        }
        while (n < n3) {
            if (this.fText.charAt(n) == '\n' || this.fText.charAt(n) == '\r') {
                if (bl) {
                    ++n2;
                }
                bl = true;
            } else if (bl) {
                ++n2;
                bl = false;
            }
            ++n;
        }
        return n2;
    }

    private int maxStringWidth(FontMetrics fontMetrics) {
        int n = 0;
        int n2 = 0;
        int n3 = this.fText.length();
        int n4 = 0;
        while (n < n3) {
            for (n = n2; n < n3 && this.fText.charAt(n) != '\n' && this.fText.charAt(n) != '\r'; ++n) {
            }
            int n5 = fontMetrics.stringWidth(this.fText.substring(n2, n));
            if (n4 < n5) {
                n4 = n5;
            }
            n2 = ++n;
        }
        return n4;
    }

    private static synchronized void setListener(MWToolTip mWToolTip) {
        MWToolTip mWToolTip2 = (MWToolTip)sLastListener.get();
        if (mWToolTip2 != null) {
            mWToolTip2.fListeningToTimer = false;
            sTimer.removeActionListener((ActionListener)mWToolTip2);
        }
        sLastListener = new WeakReference<MWToolTip>(mWToolTip);
        sTimer.addActionListener((ActionListener)mWToolTip);
    }

    private static synchronized void removeListener(MWToolTip mWToolTip) {
        MWToolTip mWToolTip2 = (MWToolTip)sLastListener.get();
        if (mWToolTip.equals(mWToolTip2)) {
            mWToolTip2.fListeningToTimer = false;
            sTimer.removeActionListener((ActionListener)mWToolTip2);
            sLastListener = new WeakReference<Object>(null);
        }
    }

    static {
        sCurrentTip = null;
        backgroundColor = new Color(255, 255, 192);
    }
}

