/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.util.CharBuffer;
import java.awt.Component;
import java.awt.Container;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class MWTranslate {
    private static CharBuffer sBuffer;
    private static ResourceBundle sRes;

    public static String intlString(String string) {
        return sRes.getString(string);
    }

    public static void translateContainer(Container container, ResourceBundle resourceBundle) {
        int n;
        Component[] componentArray = container.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            String string = componentArray[n].getName();
            if (string == null) continue;
            MWTranslate.translateComponent(componentArray[n], resourceBundle);
        }
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof Container)) continue;
            MWTranslate.translateContainer((Container)componentArray[n], resourceBundle);
        }
    }

    private static void translateComponent(Component component, ResourceBundle resourceBundle) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(component.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getName().equals("name") || propertyDescriptorArray[i].getPropertyType() != String.class || propertyDescriptorArray[i].getWriteMethod() == null || propertyDescriptorArray[i].getReadMethod() == null) continue;
                String string = component.getName();
                String string2 = propertyDescriptorArray[i].getName();
                try {
                    Object[] objectArray = new String[]{resourceBundle.getString(string + "." + string2)};
                    Method method = propertyDescriptorArray[i].getWriteMethod();
                    method.invoke((Object)component, objectArray);
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println("Missing resource: " + string + "." + string2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void translateMenuBar(MWMenuBar mWMenuBar, ResourceBundle resourceBundle) {
        if (sBuffer == null) {
            sBuffer = new CharBuffer(128, 128);
        }
        MWTranslate.translateMenuComponent(mWMenuBar, resourceBundle, "");
    }

    private static void translateMenuComponent(MWMenuComponent mWMenuComponent, ResourceBundle resourceBundle, String string) {
        Object object;
        String string2 = MWTranslate.identifierFor(mWMenuComponent);
        if (string2 != null) {
            try {
                object = resourceBundle.getString(string + string2 + ".label");
                mWMenuComponent.setLabel((String)object);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("Missing resource: " + string + string2 + ".label");
            }
        }
        if (mWMenuComponent.getMenuComponentCount() != 0) {
            string = string2 != null ? string2 + "." : "";
            object = mWMenuComponent.children();
            while (object.hasMoreElements()) {
                MWMenuComponent mWMenuComponent2 = (MWMenuComponent)object.nextElement();
                MWTranslate.translateMenuComponent(mWMenuComponent2, resourceBundle, string);
            }
        }
    }

    public static void scanContainer(Container container, Vector vector) {
        int n;
        Component[] componentArray = container.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            String string = componentArray[n].getName();
            if (string == null) continue;
            MWTranslate.scanComponent(componentArray[n], vector);
        }
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof Container)) continue;
            MWTranslate.scanContainer((Container)componentArray[n], vector);
        }
    }

    private static void scanComponent(Component component, Vector vector) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(component.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getPropertyType() != String.class || propertyDescriptorArray[i].getWriteMethod() == null || propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getName().equals("name")) continue;
                String string = propertyDescriptorArray[i].getName();
                Method method = propertyDescriptorArray[i].getReadMethod();
                String string2 = (String)method.invoke((Object)component, null);
                if (string2 == null || string2.equals("")) continue;
                vector.addElement(component.getName() + "." + string);
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void scanMenuBar(MWMenuBar mWMenuBar, Vector vector) {
        if (sBuffer == null) {
            sBuffer = new CharBuffer(128, 128);
        }
        for (int i = 0; i < mWMenuBar.getMenuComponentCount(); ++i) {
            MWMenuComponent mWMenuComponent = mWMenuBar.getMenuComponent(i);
            String string = MWTranslate.identifierFor(mWMenuComponent);
            vector.addElement(string + ".label");
            vector.addElement(mWMenuComponent.getLabel());
            if (mWMenuComponent.getMenuComponentCount() == 0) continue;
            MWTranslate.scanMenuComponent(mWMenuComponent, vector, string + ".");
        }
    }

    private static void scanMenuComponent(MWMenuComponent mWMenuComponent, Vector vector, String string) {
        String string2;
        MWMenuComponent mWMenuComponent2;
        int n;
        for (n = 0; n < mWMenuComponent.getMenuComponentCount(); ++n) {
            mWMenuComponent2 = mWMenuComponent.getMenuComponent(n);
            string2 = MWTranslate.identifierFor(mWMenuComponent2);
            if (string2 == null) continue;
            vector.addElement(string + string2 + ".label");
            String string3 = mWMenuComponent2.getLabel();
            int n2 = string3.indexOf(9);
            if (n2 != -1) {
                string3 = string3.substring(0, n2) + "\\t" + string3.substring(n2 + 1, string3.length());
            }
            vector.addElement(string3);
        }
        for (n = 0; n < mWMenuComponent.getMenuComponentCount(); ++n) {
            mWMenuComponent2 = mWMenuComponent.getMenuComponent(n);
            if (mWMenuComponent2.getMenuComponentCount() == 0) continue;
            string2 = MWTranslate.identifierFor(mWMenuComponent2);
            MWTranslate.scanMenuComponent(mWMenuComponent2, vector, string2 + ".");
        }
    }

    private static String identifierFor(MWMenuComponent mWMenuComponent) {
        String string;
        String string2 = mWMenuComponent.getName();
        if (string2 == null && (string = mWMenuComponent.getLabel()) != null && !string.equals("-")) {
            string2 = MWTranslate.identifierFor(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String identifierFor(String string) {
        String string2 = null;
        boolean bl = false;
        CharBuffer charBuffer = sBuffer;
        synchronized (charBuffer) {
            char c;
            sBuffer.delete(0, sBuffer.length());
            for (int i = 0; i < string.length() && (c = string.charAt(i)) != '\t'; ++i) {
                if (Character.isWhitespace(c)) {
                    bl = true;
                    continue;
                }
                if (!Character.isJavaLetterOrDigit(c)) continue;
                if (bl) {
                    bl = false;
                } else {
                    c = Character.toLowerCase(c);
                }
                sBuffer.append(c);
            }
            string2 = sBuffer.toString();
        }
        return string2;
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.mwt.resources.RES_mwt");
    }
}

