/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TreeData;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class Cell {
    public static final int NO_EVENTS = 0;
    public static final int MOUSE_PRESSED = 1;
    public static final int MOUSE_RELEASED = 2;
    public static final int MOUSE_CLICKED = 4;
    public static final int MOUSE_ENTERED = 8;
    public static final int MOUSE_EXITED = 16;
    public static final int MOUSE_MOVED = 32;
    public static final int MOUSE_DRAGGED = 64;
    public static final int ALL_EVENTS = -1;
    private int fEventMask;
    private Table fTable;

    public Cell(int n, Table table) {
        this.fEventMask = n;
        this.fTable = table;
    }

    public Cell(Table table) {
        this(0, table);
    }

    public Cell() {
        this(0, null);
    }

    public Table getTable() {
        return this.fTable;
    }

    public void setTable(Table table) {
        this.fTable = table;
    }

    public boolean isTableActive() {
        boolean bl = false;
        if (this.getTable() != null) {
            bl = this.getTable().getActiveFocus();
        }
        return bl;
    }

    public int getEventMask() {
        return this.fEventMask;
    }

    public void setEventMask(int n) {
        this.fEventMask = n;
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseClicked(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseEntered(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseExited(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseMoved(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        return false;
    }

    public void beginEdit(int n, int n2) {
    }

    protected void commitEdit(int n, int n2, Object object) {
        Object object2 = this.getTable().getCellData(n, n2);
        if (this.getTable().getTreeData() != null) {
            TreeData treeData = this.getTable().getTreeData();
            int n3 = treeData.getItemId(n);
            treeData.setItem(n3, n2, object);
        } else {
            this.getTable().getData().setData(n, n2, object);
        }
        this.cancelEdit(n, n2);
        this.getTable().fireValueChangedEvent(n, n2, object2);
    }

    public void commitEdit(int n, int n2) {
        this.cancelEdit(n, n2);
    }

    public void cancelEdit(int n, int n2) {
    }

    public abstract void render(Graphics var1, int var2, int var3, Rectangle var4, Object var5, Style var6, boolean var7);

    public Dimension getPreferredCellSize(int n, int n2) {
        Dimension dimension = new Dimension();
        this.getPreferredCellSize(n, n2, dimension);
        return dimension;
    }

    public boolean grabFocus(int n, int n2) {
        return false;
    }

    protected void getPreferredCellSize(int n, int n2, Dimension dimension) {
        Style style;
        if (dimension != null && (style = this.getTable().getCellStyle(n, n2)) != null) {
            Insets insets = style.getMargins();
            dimension.width = insets.left + insets.right;
            dimension.height = insets.top + insets.bottom;
            if (style.isHGridVisible()) {
                ++dimension.height;
            }
            if (style.isVGridVisible()) {
                ++dimension.width;
            }
        }
    }
}

