/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.text.MWKeyStroke;
import com.mathworks.util.PlatformInfo;
import java.util.Hashtable;

public class MWKeyMap
implements Cloneable {
    public static final int KEYBOARD_WINDOWS = 1;
    public static final int KEYBOARD_EMACS = 2;
    public static final int KEYBOARD_MAC = 3;
    private static int CTRL = 2;
    private static int SHIFT = 1;
    private static int ALT = 8;
    private static int META = 4;
    private int fCmdModifier = CTRL;
    private Hashtable fCommands;
    private int fKeyBindingScheme;

    public MWKeyMap() {
        this(new Hashtable());
        this.setNativeBindings();
    }

    public MWKeyMap(Hashtable hashtable) {
        this.fCommands = hashtable;
    }

    public synchronized Object clone() {
        return new MWKeyMap((Hashtable)this.fCommands.clone());
    }

    public int getCommandModifier() {
        return this.fCmdModifier;
    }

    public void setNativeBindings() {
        this.setBindingsForLookAndFeel(PlatformInfo.getPlatform());
    }

    public void setBindingsForLookAndFeel(int n) {
        switch (n) {
            case 1: {
                this.setWindowsBindings();
                break;
            }
            case 0: {
                this.setMacintoshBindings();
                break;
            }
            case 2: {
                this.setEmacsBindings();
            }
        }
    }

    public void setKeyBinding(int n, int n2, int n3) {
        this.fCommands.put(new MWKeyStroke(n2, n3), new Integer(n));
    }

    public void removeCommandBinding(int n) {
        this.fCommands.remove(new MWKeyStroke(this.fCmdModifier, n));
    }

    public void removeKeyBinding(int n, int n2) {
        this.fCommands.remove(new MWKeyStroke(n, n2));
    }

    public int getKeyBindingScheme() {
        return this.fKeyBindingScheme;
    }

    public int getCommand(int n, int n2) {
        Object v = this.fCommands.get(new MWKeyStroke(n, n2));
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    public void setEmacsBindings() {
        this.setWindowsBindings();
        this.setKeyBinding(0, CTRL, 66);
        this.setKeyBinding(3, CTRL, 70);
        this.setKeyBinding(5, CTRL, 68);
        this.setKeyBinding(6, ALT, 66);
        this.setKeyBinding(11, ALT, 70);
        this.setKeyBinding(13, CTRL, 80);
        this.setKeyBinding(15, CTRL, 78);
        this.setKeyBinding(17, CTRL, 65);
        this.setKeyBinding(19, CTRL, 69);
        this.setKeyBinding(21, ALT, 86);
        this.setKeyBinding(22, ALT | SHIFT, 86);
        this.setKeyBinding(23, CTRL, 86);
        this.setKeyBinding(24, CTRL | SHIFT, 86);
        this.setKeyBinding(34, CTRL, 89);
        this.setKeyBinding(33, ALT, 87);
        this.setKeyBinding(32, CTRL, 87);
        this.setKeyBinding(38, CTRL, 75);
        this.setKeyBinding(40, CTRL, 83);
        this.setKeyBinding(40, CTRL, 82);
        if (!PlatformInfo.isXWindows()) {
            this.removeKeyBinding(CTRL, 90);
        }
        this.removeKeyBinding(CTRL | SHIFT, 83);
        this.removeKeyBinding(CTRL | SHIFT, 82);
        this.fKeyBindingScheme = 2;
    }

    public void setWindowsBindings() {
        this.fCommands.clear();
        this.fCmdModifier = CTRL;
        this.addCommonBindings();
        this.setKeyBinding(33, CTRL, 155);
        this.setKeyBinding(34, SHIFT, 155);
        this.setKeyBinding(32, SHIFT, 127);
        this.setKeyBinding(39, 0, 27);
        this.setKeyBinding(40, CTRL | SHIFT, 83);
        this.setKeyBinding(40, CTRL | SHIFT, 82);
        this.fKeyBindingScheme = 1;
    }

    public void setMacintoshBindings() {
        this.fCommands.clear();
        this.fCmdModifier = META;
        this.addCommonBindings();
        this.setKeyBinding(40, CTRL, 83);
        this.setKeyBinding(40, CTRL, 82);
        this.fKeyBindingScheme = 3;
    }

    private void addCommonBindings() {
        this.setKeyBinding(0, 0, 37);
        this.setKeyBinding(1, SHIFT, 37);
        this.setKeyBinding(2, 0, 8);
        this.setKeyBinding(2, SHIFT, 8);
        this.setKeyBinding(3, 0, 39);
        this.setKeyBinding(4, SHIFT, 39);
        this.setKeyBinding(5, 0, 127);
        this.setKeyBinding(6, CTRL, 37);
        this.setKeyBinding(7, CTRL | SHIFT, 37);
        this.setKeyBinding(8, CTRL, 39);
        this.setKeyBinding(9, CTRL | SHIFT, 39);
        this.setKeyBinding(10, CTRL, 127);
        this.setKeyBinding(13, 0, 38);
        this.setKeyBinding(14, SHIFT, 38);
        this.setKeyBinding(15, 0, 40);
        this.setKeyBinding(16, SHIFT, 40);
        this.setKeyBinding(17, 0, 36);
        this.setKeyBinding(18, SHIFT, 36);
        this.setKeyBinding(19, 0, 35);
        this.setKeyBinding(20, SHIFT, 35);
        this.setKeyBinding(21, 0, 33);
        this.setKeyBinding(22, SHIFT, 33);
        this.setKeyBinding(23, 0, 34);
        this.setKeyBinding(24, SHIFT, 34);
        this.setKeyBinding(25, CTRL, 36);
        this.setKeyBinding(26, CTRL | SHIFT, 36);
        this.setKeyBinding(27, CTRL, 35);
        this.setKeyBinding(28, CTRL | SHIFT, 35);
        this.setKeyBinding(30, 0, 10);
        if (PlatformInfo.isWindows()) {
            this.setKeyBinding(35, this.fCmdModifier, 90);
            this.setKeyBinding(36, this.fCmdModifier, 89);
        } else if (PlatformInfo.isMacintosh()) {
            if (this.fCmdModifier == META) {
                this.setKeyBinding(35, this.fCmdModifier, 90);
                this.setKeyBinding(36, this.fCmdModifier | SHIFT, 90);
            } else {
                this.setKeyBinding(35, this.fCmdModifier, 90);
                this.setKeyBinding(36, this.fCmdModifier, 89);
                this.setKeyBinding(35, META, 90);
                this.setKeyBinding(36, META | SHIFT, 90);
                this.setKeyBinding(29, META, 65);
                this.setKeyBinding(34, META, 86);
                this.setKeyBinding(33, META, 67);
                this.setKeyBinding(32, META, 88);
            }
        }
        this.setKeyBinding(29, this.fCmdModifier, 65);
        this.setKeyBinding(34, this.fCmdModifier, 86);
        this.setKeyBinding(33, this.fCmdModifier, 67);
        this.setKeyBinding(32, this.fCmdModifier, 88);
    }
}

