/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.undo;

import com.mathworks.mwt.ObjBuffer;
import com.mathworks.mwt.undo.UndoEvent;
import com.mathworks.mwt.undo.UndoListener;
import com.mathworks.mwt.undo.UndoManagerListener;
import com.mathworks.mwt.undo.UndoableEdit;
import java.util.Enumeration;
import java.util.Vector;

public class UndoManager
implements UndoListener {
    private int fThePresent;
    private int fCleanMarker;
    private ObjBuffer fHistory = new ObjBuffer();
    private Vector fListeners;
    private boolean fOldCanUndo;
    private boolean fOldCanRedo;
    private boolean fOldIsDirty;

    public synchronized void addEdit(UndoableEdit undoableEdit) {
        this.recordUndoMgrState();
        if (this.canRedo()) {
            this.fHistory.delete(this.fThePresent, this.fHistory.length());
            if (this.fCleanMarker > this.fThePresent) {
                this.fCleanMarker = -1;
            }
        }
        this.fHistory.append(undoableEdit);
        ++this.fThePresent;
        this.notifyListenersIfChanged();
    }

    public synchronized void setCleanMarkerHere() {
        this.recordUndoMgrState();
        this.fCleanMarker = this.fThePresent;
        this.notifyListenersIfChanged();
    }

    public boolean isDirty() {
        return this.fCleanMarker != this.fThePresent;
    }

    public synchronized void clearUndoHistory() {
        this.recordUndoMgrState();
        this.fHistory.delete(0, this.fHistory.length());
        this.fThePresent = 0;
        this.fCleanMarker = 0;
        this.notifyListenersIfChanged();
    }

    public boolean canUndo() {
        return this.fThePresent > 0;
    }

    public synchronized void undo() {
        if (!this.canUndo()) {
            throw new IllegalStateException("Called undo() when canUndo() returned false");
        }
        this.recordUndoMgrState();
        --this.fThePresent;
        this.getPresentEdit().undo();
        this.notifyListenersIfChanged();
    }

    public boolean canRedo() {
        return this.fThePresent < this.fHistory.length();
    }

    public synchronized void redo() {
        if (!this.canRedo()) {
            throw new IllegalStateException("Called redo() when canRedo() returned false");
        }
        this.recordUndoMgrState();
        this.getPresentEdit().redo();
        ++this.fThePresent;
        this.notifyListenersIfChanged();
    }

    @Override
    public void undoableEditHappened(UndoEvent undoEvent) {
        this.recordUndoMgrState();
        if (this.canRedo()) {
            this.fHistory.delete(this.fThePresent, this.fHistory.length());
            if (this.fCleanMarker > this.fThePresent) {
                this.fCleanMarker = -1;
            }
        }
        if (!(this.canUndo() && this.isDirty() && undoEvent.combineWith(this.getPrevEdit()))) {
            this.fHistory.append(undoEvent.getEdit());
            ++this.fThePresent;
        }
        this.notifyListenersIfChanged();
    }

    private UndoableEdit getPresentEdit() {
        return this.getEditAt(this.fThePresent);
    }

    private UndoableEdit getPrevEdit() {
        return this.getEditAt(this.fThePresent - 1);
    }

    private UndoableEdit getEditAt(int n) {
        return (UndoableEdit)this.fHistory.getAt(n);
    }

    private void recordUndoMgrState() {
        this.fOldCanUndo = this.canUndo();
        this.fOldCanRedo = this.canRedo();
        this.fOldIsDirty = this.isDirty();
    }

    private void notifyListenersIfChanged() {
        if (this.fListeners == null || this.fListeners.isEmpty()) {
            return;
        }
        if (this.fOldIsDirty != this.isDirty()) {
            this.notifyListeners(new UndoEvent((Object)this, 2));
        }
        if (this.fOldCanUndo != this.canUndo()) {
            this.notifyListeners(new UndoEvent((Object)this, 3));
        }
        if (this.fOldCanRedo != this.canRedo()) {
            this.notifyListeners(new UndoEvent((Object)this, 4));
        }
    }

    public synchronized void addUndoManagerListener(UndoManagerListener undoManagerListener) {
        if (undoManagerListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.fListeners == null) {
            this.fListeners = new Vector();
        }
        this.fListeners.addElement(undoManagerListener);
    }

    public synchronized boolean removeUndoManagerListener(UndoManagerListener undoManagerListener) {
        if (undoManagerListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.fListeners == null) {
            return false;
        }
        return this.fListeners.removeElement(undoManagerListener);
    }

    private void notifyListeners(UndoEvent undoEvent) {
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            UndoManagerListener undoManagerListener = (UndoManagerListener)enumeration.nextElement();
            switch (undoEvent.getType()) {
                case 2: {
                    undoManagerListener.dirtyStateChanged(undoEvent);
                    break;
                }
                case 3: {
                    undoManagerListener.undoabilityChanged(undoEvent);
                    break;
                }
                case 4: {
                    undoManagerListener.redoabilityChanged(undoEvent);
                }
            }
        }
    }

    public String toString() {
        String string = "[Undo History - " + this.fHistory.length() + " items, present=" + this.fThePresent + "\n";
        for (int i = 0; i < this.fHistory.length(); ++i) {
            string = string + " " + (i == this.fCleanMarker ? "*" : " ") + this.getEditAt(i).toString() + "\n";
        }
        string = string + "]";
        return string;
    }
}

