/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlCallbackProvider;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.UrlFormatter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class HtmlUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("\\A[a-z:]{2,}://.*");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("<meta[^>]+content=\"text/html;[^>]*charset=\"?([^\"]+)", 34);
    private static final String CHARSET_TAG_FORMAT = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\" />";
    private static final Pattern[] HEAD_TAG_LOCATIONS = new Pattern[]{Pattern.compile("<head[^>]*>", 2), Pattern.compile("<html[^>]*>", 2)};

    private HtmlUtils() {
    }

    public static boolean areUrlsOnSamePage(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = HtmlUtils.getUrlWithoutAnchor(HtmlUtils.correctUrl(string));
        String string4 = HtmlUtils.getUrlWithoutAnchor(HtmlUtils.correctUrl(string2));
        URI uRI = HtmlUtils.getURI(string3);
        URI uRI2 = HtmlUtils.getURI(string4);
        if (uRI != null && uRI2 != null) {
            return uRI.equals(uRI2);
        }
        return string3.equals(string4);
    }

    public static boolean isValidUrl(String string) {
        return URL_PATTERN.matcher(string).lookingAt();
    }

    public static String correctUrl(String string) {
        String string2 = new UrlFormatter().formatUrl(string);
        return string2 == null ? string : string2;
    }

    static String getUrlWithoutAnchor(String string) {
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getBaseUrl(String string) {
        return string.replaceFirst("[#?;].*", "");
    }

    private static URI getURI(String string) {
        if (string.matches("^\\w{2,}+:.*")) {
            return HtmlUtils.getURIForUrl(string);
        }
        return HtmlUtils.getURIForFile(string);
    }

    private static URI getURIForUrl(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("file")) {
                return HtmlUtils.createFileURI(uRL);
            }
            return uRL.toURI();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static URI createFileURI(URL uRL) {
        assert (uRL.getProtocol().equals("file"));
        String string = uRL.getPath();
        return HtmlUtils.getURIForFile(string);
    }

    private static URI getURIForFile(String string) {
        if (EncodingUtils.needsDecoding(string)) {
            string = EncodingUtils.decodeUrl(string);
        }
        File file = new File(string);
        return file.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeScript(final HtmlCallbackProvider htmlCallbackProvider, final String string, long l) throws InterruptedException {
        ScriptReturnListener scriptReturnListener;
        if (SwingUtilities.isEventDispatchThread()) {
            assert (false) : "Synchronous calls to JavaScript cannot be performed on the EDT";
            return null;
        }
        ScriptReturnListener scriptReturnListener2 = scriptReturnListener = new ScriptReturnListener();
        synchronized (scriptReturnListener2) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    htmlCallbackProvider.executeScript(string, scriptReturnListener);
                }
            };
            new Thread(runnable).start();
            scriptReturnListener.wait(l);
            return scriptReturnListener.getReturnValue();
        }
    }

    public static String addBaseTag(String string, String string2) {
        String string3 = "\n<BASE href=\"" + string + "\" />\n";
        return HtmlUtils.addToHeadTag(string3, string2);
    }

    public static String addCharsetMetaTag(String string, String string2) {
        String string3 = String.format(CHARSET_TAG_FORMAT, string);
        return HtmlUtils.addToHeadTag(string3, string2);
    }

    private static String addToHeadTag(String string, String string2) {
        for (Pattern pattern : HEAD_TAG_LOCATIONS) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            return matcher.replaceFirst("$0" + string);
        }
        return string + string2;
    }

    public static Charset getCharsetFromHtml(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = CHARSET_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                return Charset.forName(string2);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static class ScriptReturnListener
    implements HtmlDataListener<String> {
        private String iRetValue;

        private ScriptReturnListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataRetrieved(String string) {
            ScriptReturnListener scriptReturnListener = this;
            synchronized (scriptReturnListener) {
                this.iRetValue = string;
                this.notifyAll();
            }
        }

        private String getReturnValue() {
            return this.iRetValue;
        }
    }
}

