/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.PrintStrategy;
import com.teamdev.jxbrowser.print.PageMargins;
import com.teamdev.jxbrowser.print.PageOrientation;
import com.teamdev.jxbrowser.print.PaperSize;
import com.teamdev.jxbrowser.print.PrintSettings;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import sun.print.DialogTypeSelection;

class JxBrowserPrintApiStrategy
implements PrintStrategy {
    JxBrowserPrintApiStrategy() {
    }

    @Override
    public boolean print(JxBrowserPanel jxBrowserPanel) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add((Attribute)DialogTypeSelection.NATIVE);
        boolean bl = printerJob.printDialog(hashPrintRequestAttributeSet);
        if (bl) {
            PrintSettings printSettings = JxBrowserPrintApiStrategy.getPrintSettings(printerJob, hashPrintRequestAttributeSet);
            jxBrowserPanel.getBrowser().print(printSettings, null);
        }
        return true;
    }

    private static PrintSettings getPrintSettings(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
        PrintSettings printSettings = new PrintSettings();
        printSettings.setPrinterName(printerJob.getPrintService().getName());
        JxBrowserPrintApiStrategy.updateNumCopies(printerJob, printRequestAttributeSet, printSettings);
        printSettings.setPageSize(PaperSize.A4);
        JxBrowserPrintApiStrategy.updatePageOrientation(printerJob, printRequestAttributeSet, printSettings);
        JxBrowserPrintApiStrategy.updatePageMargins(printerJob, printRequestAttributeSet, printSettings);
        return printSettings;
    }

    private static <T extends Attribute> T getPrintAttribute(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, Class<T> clazz) {
        Object object = printRequestAttributeSet.get(clazz);
        if (object == null) {
            object = printerJob.getPrintService().getDefaultAttributeValue(clazz);
        }
        return (T)((Attribute)clazz.cast(object));
    }

    private static void updateNumCopies(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, PrintSettings printSettings) {
        Copies copies = JxBrowserPrintApiStrategy.getPrintAttribute(printerJob, printRequestAttributeSet, Copies.class);
        printSettings.setNumberOfCopies(copies == null ? 1 : copies.getValue());
    }

    private static void updatePageOrientation(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, PrintSettings printSettings) {
        OrientationRequested orientationRequested = JxBrowserPrintApiStrategy.getPrintAttribute(printerJob, printRequestAttributeSet, OrientationRequested.class);
        if (orientationRequested != null && (orientationRequested.equals(OrientationRequested.LANDSCAPE) || orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE))) {
            printSettings.setPageOrientation(PageOrientation.LANDSCAPE);
        } else {
            printSettings.setPageOrientation(PageOrientation.PORTRAIT);
        }
        if (orientationRequested != null && (orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE) || orientationRequested.equals(OrientationRequested.REVERSE_PORTRAIT))) {
            printSettings.setReversed(true);
        }
    }

    private static void updatePageSize(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, PrintSettings printSettings) {
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        PaperSize paperSize = JxBrowserPrintApiStrategy.toPaperSize(media);
        if (paperSize == null) {
            media = (Media)printerJob.getPrintService().getDefaultAttributeValue(Media.class);
            paperSize = JxBrowserPrintApiStrategy.toPaperSize(media);
        }
        if (paperSize == null) {
            paperSize = PaperSize.A4;
        }
        printSettings.setPageSize(paperSize);
    }

    private static PaperSize toPaperSize(Media media) {
        if (media == null) {
            return null;
        }
        if (media instanceof MediaSizeName) {
            return JxBrowserPrintApiStrategy.toPaperSize((MediaSizeName)media);
        }
        if (media instanceof MediaName) {
            return JxBrowserPrintApiStrategy.toPaperSize((MediaName)media);
        }
        return null;
    }

    private static PaperSize toPaperSize(MediaSizeName mediaSizeName) {
        String string = mediaSizeName.toString();
        int n = string.indexOf(45);
        return JxBrowserPrintApiStrategy.resolvePaperSize(string.substring(n + 1));
    }

    private static PaperSize toPaperSize(MediaName mediaName) {
        Pattern pattern = Pattern.compile("^.*-(letter|a4)-.*$");
        Matcher matcher = pattern.matcher(mediaName.toString());
        if (matcher.find()) {
            return JxBrowserPrintApiStrategy.resolvePaperSize(matcher.group(1));
        }
        return null;
    }

    private static PaperSize resolvePaperSize(String string) {
        try {
            return PaperSize.valueOf((String)string.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void updatePageMargins(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet, PrintSettings printSettings) {
        MediaPrintableArea mediaPrintableArea = JxBrowserPrintApiStrategy.getPrintAttribute(printerJob, printRequestAttributeSet, MediaPrintableArea.class);
        MediaSize mediaSize = JxBrowserPrintApiStrategy.getMediaSize(printerJob, printRequestAttributeSet);
        if (mediaPrintableArea != null && mediaSize != null) {
            float f = mediaSize.getX(1000);
            float f2 = mediaSize.getY(1000);
            float f3 = mediaPrintableArea.getX(1000);
            float f4 = mediaPrintableArea.getY(1000);
            float f5 = f - mediaPrintableArea.getWidth(1000) - f3;
            float f6 = f2 - mediaPrintableArea.getHeight(1000) - f4;
            PageMargins pageMargins = new PageMargins((double)f4, (double)f3, (double)f5, (double)f6);
            printSettings.setPageMargins(pageMargins);
        } else {
            printSettings.setPageMargins(new PageMargins(25.4, 25.4, 25.4, 25.4));
        }
    }

    private static MediaSize getMediaSize(PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) {
        Media media = JxBrowserPrintApiStrategy.getPrintAttribute(printerJob, printRequestAttributeSet, Media.class);
        if (media != null && media instanceof MediaSizeName) {
            return MediaSize.getMediaSizeForName((MediaSizeName)media);
        }
        return JxBrowserPrintApiStrategy.getPrintAttribute(printerJob, printRequestAttributeSet, MediaSize.class);
    }

    @Override
    public void dispose() {
    }
}

