/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.jxbrowser.BrowserTypeConfig;
import com.mathworks.html.jxbrowser.JxBrowserKeyAdapter;
import com.mathworks.html.jxbrowser.JxBrowserKeyEvent;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.KeyEventHandler;
import com.mathworks.html.jxbrowser.SafariFindInPage;
import com.teamdev.jxbrowser.Browser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;

public class SafariConfig
implements BrowserTypeConfig,
KeyEventHandler {
    static final int MIN_DEFAULT_FONT_SIZE = 10;
    static final int MAX_DEFAULT_FONT_SIZE = 72;
    private static final MessageFormat EVENT_LISTENER_FORMAT = new MessageFormat("{0}.addEventListener(''{1}'',{2},false);");

    @Override
    public void configureBrowser(JxBrowserPanel jxBrowserPanel) {
        SafariConfig.checkFont(jxBrowserPanel.getBrowser());
        SafariConfig.attachKeyListener(jxBrowserPanel);
        jxBrowserPanel.getComponent().setKeyEventHandler(this);
    }

    private static void checkFont(Browser browser) {
        Font font = browser.getConfigurable().getDefaultFont();
        int n = font.getSize();
        boolean bl = false;
        if (n < 10) {
            n = 10;
            bl = true;
        } else if (n > 72) {
            n = 72;
            bl = true;
        }
        if (bl) {
            Font font2 = new Font(font.getName(), font.getStyle(), n);
            browser.getConfigurable().setDefaultFont(font2);
        }
    }

    private static void attachKeyListener(JxBrowserPanel jxBrowserPanel) {
        Browser browser = jxBrowserPanel.getBrowser();
        Component component = browser.getComponent();
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                component2.addKeyListener(new SafariKeyAdapter(jxBrowserPanel));
            }
        }
    }

    @Override
    public boolean interceptKeyEvent(JxBrowserSwingComponent jxBrowserSwingComponent, KeyEvent keyEvent) {
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == null) {
            if (SafariConfig.detectCommandKey(keyEvent)) {
                return false;
            }
            SafariConfig.correctKeyCode(keyEvent);
        }
        return true;
    }

    private static boolean detectCommandKey(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '[' && keyEvent.getKeyCode() == 91) {
            keyEvent.setKeyCode(157);
            keyEvent.setKeyChar('\uffff');
            return true;
        }
        if (keyEvent.getKeyChar() == ']' && keyEvent.getKeyCode() == 93) {
            keyEvent.setKeyCode(157);
            keyEvent.setKeyChar('\uffff');
            return true;
        }
        return false;
    }

    private static void correctKeyCode(KeyEvent keyEvent) {
        Integer n = SafariConfig.getExpectedKeyCode(keyEvent.getKeyChar());
        if (n != null && n.intValue() != keyEvent.getKeyCode()) {
            keyEvent.setKeyCode(n);
        }
    }

    private static Integer getExpectedKeyCode(char c) {
        switch (c) {
            case '-': {
                return 45;
            }
            case '=': {
                return 61;
            }
            case '!': {
                return 517;
            }
            case '@': {
                return 512;
            }
            case '#': {
                return 520;
            }
            case '$': {
                return 515;
            }
            case '^': {
                return 514;
            }
            case '&': {
                return 150;
            }
            case '*': {
                return 151;
            }
            case '(': {
                return 519;
            }
            case ')': {
                return 522;
            }
            case '_': {
                return 523;
            }
            case '+': {
                return 107;
            }
            case '\t': {
                return 9;
            }
            case '\n': {
                return 10;
            }
            case '[': {
                return 91;
            }
            case ']': {
                return 93;
            }
            case '\\': {
                return 92;
            }
            case ';': {
                return 59;
            }
            case ':': {
                return 513;
            }
            case '\'': {
                return 222;
            }
            case '\"': {
                return 152;
            }
            case ',': {
                return 44;
            }
            case '<': {
                return 153;
            }
            case '.': {
                return 46;
            }
            case '>': {
                return 160;
            }
            case '/': {
                return 47;
            }
            case ' ': {
                return 32;
            }
        }
        return null;
    }

    @Override
    public HtmlFindInPage getFindInPage(JxBrowserPanel jxBrowserPanel) {
        return new SafariFindInPage(jxBrowserPanel);
    }

    @Override
    public String getTextSelectionScript() {
        return "window.getSelection().toString()";
    }

    @Override
    public String createAddEventFunction(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return EVENT_LISTENER_FORMAT.format(objectArray);
    }

    @Override
    public String getUrlEncodingCharset() {
        return "UTF-8";
    }

    private static class SafariKeyAdapter
    extends JxBrowserKeyAdapter {
        private SafariKeyAdapter(JxBrowserPanel jxBrowserPanel) {
            super(jxBrowserPanel);
        }

        @Override
        protected JxBrowserKeyEvent cloneBrowserKeyEvent(JxBrowserSwingComponent jxBrowserSwingComponent, KeyEvent keyEvent) {
            SafariConfig.correctKeyCode(keyEvent);
            return super.cloneBrowserKeyEvent(jxBrowserSwingComponent, keyEvent);
        }
    }
}

