/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.AdminProxy;
import com.sun.jini.reggie.ConstrainableAdminProxy;
import com.sun.jini.reggie.ConstrainableEventLease;
import com.sun.jini.reggie.ConstrainableRegistrarProxy;
import com.sun.jini.reggie.ConstrainableRegistration;
import com.sun.jini.reggie.ConstrainableServiceLease;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarLease;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl server;
    private transient ServiceID registrarID;

    ProxyVerifier(Registrar registrar, ServiceID serviceID) {
        if (!(registrar instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("server does not implement RemoteMethodControl");
        }
        if (!(registrar instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("server does not implement TrustEquivalence");
        }
        this.server = (RemoteMethodControl)registrar;
        this.registrarID = serviceID;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        ServiceID serviceID;
        RemoteMethodControl remoteMethodControl;
        ReferentUuid referentUuid;
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        if (object instanceof ConstrainableRegistrarProxy) {
            referentUuid = (RegistrarProxy)object;
            remoteMethodControl = (RemoteMethodControl)referentUuid.server;
            serviceID = referentUuid.registrarID;
        } else if (object instanceof ConstrainableAdminProxy) {
            referentUuid = (AdminProxy)object;
            remoteMethodControl = (RemoteMethodControl)((AdminProxy)referentUuid).server;
            serviceID = ((AdminProxy)referentUuid).registrarID;
        } else if (object instanceof ConstrainableRegistration) {
            referentUuid = (Registration)object;
            if (!this.isTrustedObject(((Registration)referentUuid).lease, context)) {
                return false;
            }
            remoteMethodControl = (RemoteMethodControl)((Registration)referentUuid).server;
            serviceID = this.registrarID;
        } else if (object instanceof ConstrainableEventLease || object instanceof ConstrainableServiceLease) {
            referentUuid = (RegistrarLease)object;
            remoteMethodControl = (RemoteMethodControl)((RegistrarLease)referentUuid).server;
            serviceID = ((RegistrarLease)referentUuid).registrarID;
        } else if (object instanceof RemoteMethodControl) {
            remoteMethodControl = (RemoteMethodControl)object;
            serviceID = this.registrarID;
        } else {
            return false;
        }
        referentUuid = (TrustEquivalence)this.server.setConstraints(remoteMethodControl.getConstraints());
        return referentUuid.checkTrustEquivalence(remoteMethodControl) && this.registrarID.equals((Object)serviceID);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.registrarID.writeBytes((DataOutput)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.registrarID = new ServiceID((DataInput)objectInputStream);
        if (!(this.server instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("server does not implement RemoteMethodControl");
        }
        if (!(this.server instanceof TrustEquivalence)) {
            throw new InvalidObjectException("server does not implement TrustEquivalence");
        }
    }
}

