/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;

public final class AddFilesDropDownButton {
    private final TSDropDownButton fButton;
    private final ProjectClient fClient;
    private static final String ACTION_KEY_PREFIX = "action.add.";

    public AddFilesDropDownButton(ProjectClient projectClient) {
        this.fClient = projectClient;
        this.fButton = new TSDropDownButton(BuiltInResources.getString("toolstrip.addFiles"), BuiltInResources.getIcon("document_add.png"));
        this.fButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                final Project project = AddFilesDropDownButton.this.fClient.getProject();
                if (project != null) {
                    ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
                    for (FileSetDefinition fileSetDefinition : project.getConfiguration().getTarget().getFileSets()) {
                        if (fileSetDefinition.getKey().equals("fileset.package")) continue;
                        arrayList.add(ListItem.newItem((String)(AddFilesDropDownButton.ACTION_KEY_PREFIX + fileSetDefinition.getKey()), (String)fileSetDefinition.getSingleFileName()));
                    }
                    PopupList popupList = new PopupList(arrayList.toArray(new ListItem[arrayList.size()]));
                    popupList.addListActionListener(new ListActionListener(){

                        public void listItemSelected(ListActionEvent listActionEvent) {
                            String string = listActionEvent.getListItem().getName().substring(AddFilesDropDownButton.ACTION_KEY_PREFIX.length());
                            FileSetInstance fileSetInstance = project.getConfiguration().getFileSet(string);
                            if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
                                File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
                                if (fileArray != null) {
                                    AddFilesDropDownButton.this.fClient.getFileSetEditor(string).addAndSelect(fileArray, false);
                                }
                            } else {
                                FileChooser fileChooser = FileChooser.create(AddFilesDropDownButton.this.fClient.getComponent(), BuiltInResources.getString("dialog.title.addfiles"), new File(MatlabPath.getCWD()), fileSetInstance.getDefinition().allowsDirectories(), fileSetInstance.getDefinition().getFilters());
                                File[] fileArray = fileChooser.showOpenDialog();
                                if (fileArray != null) {
                                    AddFilesDropDownButton.this.fClient.getFileSetEditor(string).addAndSelect(fileArray, false);
                                }
                            }
                        }
                    });
                    popupList.setListStyle(ListStyle.TEXT_ONLY);
                    popupCallback.show((JComponent)popupList);
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.fButton;
    }
}

