/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.apps.NoProjectPanel;
import com.mathworks.project.impl.desktop.AbstractProjectClient;
import com.mathworks.project.impl.desktop.AppActionPanel;
import com.mathworks.project.impl.desktop.AppAuthoringPanel;
import com.mathworks.project.impl.desktop.FileManager;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.logui.BuildProgressDialog;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.workflowui.WorkflowHeader;
import com.mathworks.util.RequestFilter;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class AppsProjectClient
extends AbstractProjectClient
implements ExplicitColorAndFontProvider {
    public static final String APPS_FILE_EXTENSION = ".mlappinstall";
    private MJPanel fPane;
    public static final String NAME = "Package App";
    public static final String TITLE = "Package App";
    private final WorkflowHeader fWorkflowHeader = new WorkflowHeader();
    private final MJPanel fToolbarPanel = new MJPanel();
    private final MJLabel fCurrentProjectLabel;
    private FileManager fFileManager;
    private AppAuthoringPanel fAuthoringPanel;
    private AppActionPanel fActionPanel;
    private BuildProgressDialog fProgressDialog;
    private ParamWidgetBinder fWidgetBinder;

    public AppsProjectClient() {
        super("Package App", "Package App");
        this.fToolbarPanel.setLayout((LayoutManager)new FormLayout("2dlu, fill:d:grow, 12dlu", "2dlu, fill:d:grow, 2dlu"));
        this.fCurrentProjectLabel = new MJLabel("  ");
        this.fToolbarPanel.add((Component)this.fCurrentProjectLabel, (Object)new CellConstraints().xywh(1, 1, 2, 2));
        this.fFileManager = new FileManager(this);
        this.fAuthoringPanel = new AppAuthoringPanel(this);
        this.fActionPanel = new AppActionPanel(this);
        this.fPane = new MJPanel((LayoutManager)new BorderLayout());
        this.setContentPane((Component)this.fPane);
        PrefUtils.manageBackgroundColor((Container)((Object)this));
    }

    public ParamWidgetBinder getWidgetBinder() {
        return this.fWidgetBinder;
    }

    private void setConfiguration(Project project) {
        this.fWidgetBinder = new ParamWidgetBinder(project, true);
        this.fWidgetBinder.disposeWidgets();
        this.fFileManager.setConfiguration(project);
        this.fAuthoringPanel.setConfiguration(project);
        this.fActionPanel.setConfiguration(project);
    }

    @Override
    public void loadingFinished(final Project project) {
        super.loadingFinished(project);
        this.setConfiguration(project);
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                String string = project.getConfiguration().getParamAsString("param.appname");
                File file = new File(project.getFile().getParentFile(), string + AppsProjectClient.APPS_FILE_EXTENSION);
                project.getConfiguration().setParamAsFile("param.output", file);
            }
        }, 500);
        project.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.appname")) {
                    requestFilter.request();
                } else if (propertyChangeEvent.getPropertyName().equals("file")) {
                    AppsProjectClient.this.setProjectName(propertyChangeEvent.getNewValue().toString());
                }
            }
        });
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppsProjectClient.this.fPane.removeAll();
                MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:d, fill:d:grow, fill:d", "fill:d, fill:d:grow"));
                CellConstraints cellConstraints = new CellConstraints();
                AppsProjectClient.this.fWorkflowHeader.addPane(BuiltInResources.getString("apps.pickMainFile"), AppsProjectClient.this.fFileManager.getComponent());
                AppsProjectClient.this.fWorkflowHeader.addPane(BuiltInResources.getString("apps.describe"), AppsProjectClient.this.fAuthoringPanel.getComponent());
                AppsProjectClient.this.fWorkflowHeader.addPane(BuiltInResources.getString("apps.package"), AppsProjectClient.this.fActionPanel.getComponent());
                mJPanel.add((Component)AppsProjectClient.this.fWorkflowHeader.getComponent(), (Object)cellConstraints.xyw(1, 1, 3));
                mJPanel.add(AppsProjectClient.this.fFileManager.getComponent(), (Object)cellConstraints.xy(1, 2));
                mJPanel.add(AppsProjectClient.this.fAuthoringPanel.getComponent(), (Object)cellConstraints.xy(2, 2));
                mJPanel.add(AppsProjectClient.this.fActionPanel.getComponent(), (Object)cellConstraints.xy(3, 2));
                AppsProjectClient.this.fPane.add((Component)mJPanel, (Object)"Center");
                AppsProjectClient.this.setProjectName(AppsProjectClient.this.getProject().getFile().getAbsolutePath());
                AppsProjectClient.this.invalidate();
                AppsProjectClient.this.repaint();
            }
        });
    }

    @Override
    public void loadingFailed() {
        super.loadingFailed();
        if (this.getProject() != null) {
            this.setProjectName(this.getProject().getFile().getAbsolutePath());
        }
    }

    @Override
    protected void disableActionsRequiringOpenProject() {
    }

    @Override
    protected void enableActionsRequiringOpenProject() {
    }

    @Override
    public void projectClosed() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppsProjectClient.this.fWorkflowHeader.remove();
                AppsProjectClient.this.fFileManager.close();
                AppsProjectClient.this.fAuthoringPanel.close();
                AppsProjectClient.this.fActionPanel.close();
                AppsProjectClient.this.fPane.removeAll();
                AppsProjectClient.this.fPane.revalidate();
            }
        });
        this.disposeBuildProgressDialog();
        super.projectClosed();
    }

    @Override
    protected void updateToolbar() {
        this.setToolbarComponent((JComponent)this.fToolbarPanel, false);
    }

    @Override
    public DTLocation getDefaultLocation() {
        return DTLocation.createExternal((int)1088, (int)612);
    }

    @Override
    public void disableChangeActionsWhileRunning(DeploymentProcess deploymentProcess) {
    }

    @Override
    public void start(DeploymentProcess deploymentProcess) {
        this.startAndShowProgress(deploymentProcess);
    }

    private void startAndShowProgress(final DeploymentProcess deploymentProcess) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectGUI.getInstance().setCurrentProcess(deploymentProcess);
                AppsProjectClient.this.fActionPanel.resetOutputMessage();
                if (AppsProjectClient.this.fProgressDialog != null) {
                    AppsProjectClient.this.fProgressDialog.setVisible(false);
                    AppsProjectClient.this.fProgressDialog.dispose();
                }
                AppsProjectClient.this.fProgressDialog = new BuildProgressDialog((Component)((Object)AppsProjectClient.this), deploymentProcess);
                AppsProjectClient.this.fProgressDialog.show();
                deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

                    private void end() {
                        ProjectGUI.getInstance().setCurrentProcess(null);
                    }

                    public void subProcessStarted(SubProcessType subProcessType) {
                    }

                    public void commandStarted(String string) {
                    }

                    public void commandOutput(String string) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }

                    public void commandError(String string) {
                    }

                    public void finished() {
                        this.end();
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AppsProjectClient.this.fActionPanel.reportSuccess();
                            }
                        });
                    }

                    public void failed() {
                        AppsProjectClient.this.fActionPanel.reportFailure();
                        this.end();
                    }

                    public void canceled() {
                        AppsProjectClient.this.fActionPanel.reportCancel();
                        this.end();
                    }
                });
                deploymentProcess.start();
            }
        });
    }

    @Override
    public FileSetEditor getFileSetEditor(String string) {
        return this.fFileManager.getFileSetEditor(string);
    }

    @Override
    protected void switchToNoProjectMode() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppsProjectClient.this.setProjectName("  ");
                AppsProjectClient.this.updateToolbar();
                AppsProjectClient.this.disableActionsRequiringOpenProject();
                AppsProjectClient.this.removeAll();
                AppsProjectClient.this.setLayout((LayoutManager)new FormLayout("2dlu, 2dlu, fill:d:grow, 2dlu", "p, 2dlu, top:d:grow"));
                CellConstraints cellConstraints = new CellConstraints();
                AppsProjectClient.this.add(AppsProjectClient.this.getToolbarComponent(), cellConstraints.xyw(1, 1, 3));
                AppsProjectClient.this.add(NoProjectPanel.getComponent(), cellConstraints.xy(3, 3));
                AppsProjectClient.this.updateTitle();
                AppsProjectClient.this.revalidate();
                AppsProjectClient.this.repaint();
            }
        });
    }

    protected static Component createTitleComponent(String string, boolean bl, boolean bl2) {
        MJLabel mJLabel = new MJLabel((Icon)new ImageIcon("c:\\leftArrow.jpg"));
        MJLabel mJLabel2 = new MJLabel((Icon)new ImageIcon("c:\\square.jpg"));
        MJLabel mJLabel3 = new MJLabel((Icon)new ImageIcon("c:\\rightArrow.jpg"));
        Color color = new Color(30, 82, 140);
        MJLabel mJLabel4 = new MJLabel(string);
        mJLabel4.setBackground(color);
        mJLabel4.setForeground(Color.WHITE);
        mJLabel4.setOpaque(true);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setOpaque(true);
        mJPanel.setBackground(color);
        mJPanel.add((Component)(bl ? mJLabel : mJLabel2), "West");
        mJPanel.add((Component)mJLabel4);
        mJPanel.add((Component)(bl2 ? mJLabel3 : mJLabel2), "East");
        mJPanel.repaint();
        return mJPanel;
    }

    public static Component getInstance() {
        return ProjectGUI.getInstance().getClient(true).getComponent();
    }

    public void filesChanged(Set<String> set, List<String> list, List<String> list2, List<String> list3) {
        this.fAuthoringPanel.setPlatforms(set);
        this.fAuthoringPanel.setProducts(list, list2, list3);
    }

    public void disposeBuildProgressDialog() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AppsProjectClient.this.fProgressDialog != null) {
                    AppsProjectClient.this.fProgressDialog.setVisible(false);
                    AppsProjectClient.this.fProgressDialog.dispose();
                    AppsProjectClient.this.fProgressDialog = null;
                }
            }
        });
    }

    private void setProjectName(String string) {
        if (string == null) {
            return;
        }
        this.fCurrentProjectLabel.setText(string);
        this.fCurrentProjectLabel.setBorder(string.trim().isEmpty() ? BorderFactory.createEmptyBorder() : BorderFactory.createEtchedBorder(1));
        this.repaint();
    }
}

