/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.SectionedProjectTab;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plaf.DeploymentTabbedPaneUI;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public final class ProjectTabbedPane {
    private final MJTabbedPane fTabbedPane;
    private final List<ProjectComponent> fTabs;
    private final List<ProjectTabDefinition> fTabDefinitions;

    public ProjectTabbedPane() {
        DeploymentTabbedPaneUI deploymentTabbedPaneUI = new DeploymentTabbedPaneUI();
        this.fTabs = new ArrayList<ProjectComponent>();
        this.fTabDefinitions = new ArrayList<ProjectTabDefinition>();
        this.fTabbedPane = new MJTabbedPane(1);
        this.fTabbedPane.setUI((TabbedPaneUI)deploymentTabbedPaneUI);
        this.fTabbedPane.setName("deploytool.tabs");
        this.fTabbedPane.setFont(new Font("SansSerif", 0, 11));
    }

    public void activateDefaultTab() {
        this.fTabbedPane.setSelectedIndex(0);
    }

    public void activatePackageTab() {
        for (int i = 0; i < this.fTabs.size(); ++i) {
            if (!this.fTabDefinitions.get(i).requiresPackageScript()) continue;
            this.fTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public FileSetEditorGroup getActiveGroup() {
        int n = this.fTabbedPane.getSelectedIndex();
        ProjectComponent projectComponent = this.fTabs.get(n);
        if (projectComponent instanceof SectionedProjectTab) {
            return ((SectionedProjectTab)projectComponent).getFileSetGroup();
        }
        return null;
    }

    public void setConfiguration(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectTabbedPane.this.reset();
                Target target = project.getConfiguration().getTarget();
                List list = ProjectTabbedPane.getApplicableTabs(target);
                for (int i = 0; i < list.size(); ++i) {
                    ProjectTabDefinition projectTabDefinition = (ProjectTabDefinition)list.get(i);
                    ProjectComponent projectComponent = ProjectTabbedPane.instantiateTab(project, projectTabDefinition);
                    if (projectComponent instanceof SectionedProjectTab) {
                        SectionedProjectTab sectionedProjectTab = (SectionedProjectTab)projectComponent;
                        DataTransferSupport.installDropSupport(sectionedProjectTab.getFileSetGroup(), (Component)ProjectTabbedPane.this.fTabbedPane, (Predicate<Point>)ProjectTabbedPane.this.createTabHitTester(i));
                        FileSetEditor fileSetEditor = sectionedProjectTab.getLastEditor();
                        if (fileSetEditor != null) {
                            DataTransferSupport.installDropSupport(fileSetEditor, sectionedProjectTab.getComponent());
                        }
                    }
                    ProjectTabbedPane.this.fTabDefinitions.add(projectTabDefinition);
                    ProjectTabbedPane.this.fTabs.add(projectComponent);
                    ProjectTabbedPane.this.fTabbedPane.addTab(projectTabDefinition.getName(), projectComponent.getComponent());
                }
            }
        });
    }

    public void reset() {
        DataTransferSupport.uninstall((Component)this.fTabbedPane);
        for (ProjectComponent projectComponent : this.fTabs) {
            if (projectComponent instanceof SectionedProjectTab) {
                DataTransferSupport.uninstall(projectComponent.getComponent());
            }
            projectComponent.dispose();
        }
        this.fTabbedPane.removeAll();
        this.fTabs.clear();
        this.fTabDefinitions.clear();
    }

    private static List<ProjectTabDefinition> getApplicableTabs(Target target) {
        ArrayList<ProjectTabDefinition> arrayList = new ArrayList<ProjectTabDefinition>();
        for (ProjectTabDefinition projectTabDefinition : target.getProjectTabs()) {
            if (projectTabDefinition.requiresPackageScript() && target.getPackageScript() == null) continue;
            arrayList.add(projectTabDefinition);
        }
        return arrayList;
    }

    private static ProjectComponent instantiateTab(Project project, ProjectTabDefinition projectTabDefinition) {
        try {
            Class<?> clazz = Class.forName(projectTabDefinition.getImplementationClassName());
            for (Constructor<?> constructor : clazz.getConstructors()) {
                List<Class<?>> list = Arrays.asList(constructor.getParameterTypes());
                if (((Object)list).equals(Arrays.asList(WritableConfiguration.class))) {
                    return (ProjectComponent)constructor.newInstance(project.getConfiguration());
                }
                if (!((Object)list).equals(Arrays.asList(Project.class, List.class))) continue;
                return (ProjectComponent)constructor.newInstance(project, projectTabDefinition.getSections());
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        throw new IllegalArgumentException("No supported constructor in class: " + projectTabDefinition.getImplementationClassName());
    }

    private Predicate<Point> createTabHitTester(final int n) {
        return new Predicate<Point>(){

            public boolean accept(Point point) {
                return ProjectTabbedPane.this.fTabbedPane.getUI().getTabBounds((JTabbedPane)ProjectTabbedPane.this.fTabbedPane, n).contains(point);
            }
        };
    }

    public FileSetEditor getFileSetEditor(String string) {
        for (ProjectComponent projectComponent : this.fTabs) {
            FileSetEditor fileSetEditor;
            if (!(projectComponent instanceof SectionedProjectTab) || (fileSetEditor = ((SectionedProjectTab)projectComponent).getFileSetEditor(string)) == null) continue;
            return fileSetEditor;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fTabbedPane;
    }
}

