/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ProcessWrapper;
import com.mathworks.project.api.ProcessWrapperApi;
import com.mathworks.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;

public final class ProcessWrapperImpl
implements ProcessWrapper {
    private final Command fCommand;
    private final String[] fCommandLineArray;
    private final CommandStatus fStatus;
    private final String fFailureMessage;
    private final Object fProcessLock;
    private final Runnable fCleanup;
    private final File fWorkingDirectory;
    private final String[] fEnv;
    private final boolean fFinishStatus;
    private Process fProcess;
    private BufferedReader fOutput;
    private BufferedReader fError;
    private ReadWorker fOutWorker;
    private ReadWorker fErrorWorker;

    public ProcessWrapperImpl(Command command, String string, CommandStatus commandStatus, String string2) {
        this(command, string, commandStatus, string2, null);
    }

    public ProcessWrapperImpl(Command command, String string, CommandStatus commandStatus, String string2, Runnable runnable) {
        this(command, ProcessWrapperApi.parse((String)string), commandStatus, string2, runnable, null, true);
    }

    public ProcessWrapperImpl(Command command, String[] stringArray, CommandStatus commandStatus, String string, Runnable runnable, File file, boolean bl) {
        this.fCleanup = runnable;
        this.fCommand = command;
        this.fCommandLineArray = (String[])stringArray.clone();
        this.fStatus = commandStatus;
        this.fFailureMessage = string;
        this.fProcessLock = new Object();
        this.fWorkingDirectory = file;
        this.fEnv = null;
        this.fFinishStatus = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            Object object = this.fProcessLock;
            synchronized (object) {
                this.fProcess = Runtime.getRuntime().exec(this.fCommandLineArray, this.fEnv, this.fWorkingDirectory);
                this.fOutput = new BufferedReader(new InputStreamReader(this.fProcess.getInputStream()));
                this.fError = new BufferedReader(new InputStreamReader(this.fProcess.getErrorStream()));
                this.fOutWorker = new ReadWorker(this.fOutput, false);
                this.fErrorWorker = new ReadWorker(this.fError, true);
            }
            this.fOutWorker.start();
            this.fErrorWorker.start();
            this.fOutWorker.waitUntilFinished();
            this.fErrorWorker.waitUntilFinished();
        }
        catch (Exception exception) {
            this.fStatus.printErrorLine(this.fFailureMessage);
            this.fStatus.printErrorLine(exception.getLocalizedMessage());
            this.fStatus.failed(new CommandExecutionException(this.fCommand, (Throwable)exception));
        }
        finally {
            if (this.destroyProcess(false) != 0) {
                this.fStatus.failed(new CommandExecutionException(this.fCommand));
            } else if (this.fFinishStatus) {
                this.fStatus.finished();
            }
        }
    }

    public void cancel() {
        if (this.fOutWorker != null) {
            this.fOutWorker.cancel();
        }
        if (this.fErrorWorker != null) {
            this.fErrorWorker.cancel();
        }
        this.destroyProcess(true);
        this.fStatus.canceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int destroyProcess(boolean bl) {
        int n = 0;
        try {
            Object object = this.fProcessLock;
            synchronized (object) {
                if (this.fProcess != null) {
                    if (bl) {
                        this.fProcess.destroy();
                    } else {
                        try {
                            n = this.fProcess.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            n = 1;
                        }
                    }
                    if (this.fCleanup != null) {
                        this.fCleanup.run();
                    }
                }
                this.fProcess = null;
                if (this.fOutput != null) {
                    this.fOutput.close();
                }
                if (this.fError != null) {
                    this.fError.close();
                }
            }
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        return n;
    }

    private class ReadWorker
    extends Thread {
        private final BufferedReader fReader;
        private final boolean fIsErrorStream;
        private final CountDownLatch fLatch;
        private volatile boolean fCanceled;

        ReadWorker(BufferedReader bufferedReader, boolean bl) {
            this.fReader = bufferedReader;
            this.fIsErrorStream = bl;
            this.fLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String string;
                while ((string = this.fReader.readLine()) != null) {
                    if (this.fIsErrorStream) {
                        ProcessWrapperImpl.this.fStatus.printErrorLine(string);
                        continue;
                    }
                    ProcessWrapperImpl.this.fStatus.printOutputLine(string);
                }
            }
            catch (IOException iOException) {
                if (!this.fCanceled) {
                    ProcessWrapperImpl.this.fStatus.failed(new CommandExecutionException(ProcessWrapperImpl.this.fCommand, (Throwable)iOException));
                    ProcessWrapperImpl.this.destroyProcess(false);
                }
            }
            finally {
                this.fLatch.countDown();
            }
        }

        public void waitUntilFinished() throws InterruptedException {
            this.fLatch.await();
        }

        public void cancel() {
            this.fCanceled = true;
        }
    }
}

