/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.project.impl.filesetui.EntityControls;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.FileSetInstance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class FileSetCellRenderer {
    private final FileSetEditorGroup fGroup;
    private final FileSetInstance fSet;
    private final JComponent fTree;
    private final TableAdapter fTableAdapter;
    private final TreeAdapter fTreeAdapter;
    private final Map<File, Boolean> fExistenceCache;

    FileSetCellRenderer(FileSetEditorGroup fileSetEditorGroup, FileSetInstance fileSetInstance, JComponent jComponent) {
        this.fSet = fileSetInstance;
        this.fGroup = fileSetEditorGroup;
        this.fTree = jComponent;
        this.fTableAdapter = new TableAdapter();
        this.fTreeAdapter = new TreeAdapter();
        this.fExistenceCache = new HashMap<File, Boolean>();
    }

    TreeCellRenderer getTreeAdapter() {
        return this.fTreeAdapter;
    }

    TableCellRenderer getTableAdapter() {
        return this.fTableAdapter;
    }

    private Component customize(Object object, boolean bl, boolean bl2, Component component, ComponentWrapper componentWrapper) {
        Object object2;
        Object object3;
        if (object instanceof File) {
            object3 = (File)object;
            object2 = this.fSet.getReferenceMode((File)object3);
            String string = object2.getFileLabel((File)object3);
            String string2 = object2.getReferenceFileName((File)object3);
            componentWrapper.setText(string);
            Object object4 = object3;
            if (!string2.equals(((File)object3).getName())) {
                object4 = new File(((File)object3).getParentFile(), string2);
            }
            Icon icon = UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation((File)object4), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
            if (object2 == FileReferenceMode.DIRECT && !this.exists((File)object3)) {
                if (this.fSet.getDefinition().getKey().equals("fileset.package")) {
                    componentWrapper.setIcon(IconUtils.createGhostedIcon((Icon)icon));
                } else {
                    componentWrapper.setIcon(IconUtils.createBadgedIcon((ImageIcon)FileTypeIcon.DOCUMENT.getIcon(), (ImageIcon)DialogIcon.ERROR_10x10.getIcon(), (int)8, (int)8, (int)7, (int)7));
                }
            } else {
                componentWrapper.setIcon(icon);
            }
            componentWrapper.setToolTipText(((File)object3).getAbsolutePath());
        } else if (object instanceof EntityInstance) {
            object3 = (EntityInstance)object;
            componentWrapper.setText(((EntityInstance)object3).getName());
            componentWrapper.setIcon(((EntityInstance)object3).getDefinition().getIcon());
        } else if (object instanceof EntityControls) {
            return ((EntityControls)object).getComponent();
        }
        if (bl) {
            if (componentWrapper instanceof TreeAdapter || this.fGroup.hasFocus()) {
                componentWrapper.setBackgroundSelectionColor(ColorUtils.getSelectionBackgroundColor());
                componentWrapper.setTextSelectionColor(ColorUtils.getSelectionForegroundColor());
            }
            if (!this.fGroup.hasFocus()) {
                componentWrapper.setBackgroundSelectionColor(ColorUtils.getUnfocusedSelectionBackgroundColor((Component)this.fTree));
                componentWrapper.setTextSelectionColor(ColorUtils.getUnfocusedSelectionForegroundColor((Component)this.fTree));
            }
            componentWrapper.setBackground(FileSetCellRenderer.createNonResourceColor(componentWrapper.getBackgroundSelectionColor()));
            componentWrapper.setForeground(FileSetCellRenderer.createNonResourceColor(componentWrapper.getTextSelectionColor()));
        } else {
            object3 = FileSetCellRenderer.createNonResourceColor(this.fTree.getBackground());
            object2 = FileSetCellRenderer.createNonResourceColor(this.fTree.getForeground());
            componentWrapper.setBackgroundNonSelectionColor((Color)object3);
            componentWrapper.setTextNonSelectionColor((Color)object2);
            componentWrapper.setBackground((Color)object3);
            componentWrapper.setForeground((Color)object2);
        }
        componentWrapper.setFont(this.fTree.getFont());
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushExistenceCache() {
        Map<File, Boolean> map = this.fExistenceCache;
        synchronized (map) {
            this.fExistenceCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(File file) {
        Map<File, Boolean> map = this.fExistenceCache;
        synchronized (map) {
            Boolean bl = this.fExistenceCache.get(file);
            if (bl == null) {
                bl = file.exists();
                this.fExistenceCache.put(file, bl);
            }
            return bl;
        }
    }

    private static Color createNonResourceColor(Color color) {
        return color == null ? null : new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private class TableAdapter
    extends DefaultTableCellRenderer
    implements ComponentWrapper {
        private JTable iTable;

        private TableAdapter() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.iTable = jTable;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return FileSetCellRenderer.this.customize(object, bl, bl2, this, this);
        }

        @Override
        public void setBackgroundSelectionColor(Color color) {
            this.iTable.setSelectionBackground(color);
        }

        @Override
        public void setTextSelectionColor(Color color) {
            this.iTable.setSelectionForeground(color);
        }

        @Override
        public void setBackgroundNonSelectionColor(Color color) {
            this.iTable.setBackground(color);
        }

        @Override
        public void setTextNonSelectionColor(Color color) {
            this.iTable.setForeground(color);
        }

        @Override
        public Color getBackgroundSelectionColor() {
            return this.iTable.getSelectionBackground();
        }

        @Override
        public Color getTextSelectionColor() {
            return this.iTable.getSelectionForeground();
        }
    }

    private class TreeAdapter
    extends DefaultTreeCellRenderer
    implements ComponentWrapper {
        private TreeAdapter() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return FileSetCellRenderer.this.customize(object, bl, bl4, this, this);
        }
    }

    private static interface ComponentWrapper
    extends ExplicitColorAndFontProvider {
        public void setText(String var1);

        public void setToolTipText(String var1);

        public void setIcon(Icon var1);

        public void setFont(Font var1);

        public void setForeground(Color var1);

        public void setBackground(Color var1);

        public void setBackgroundSelectionColor(Color var1);

        public void setTextSelectionColor(Color var1);

        public void setBackgroundNonSelectionColor(Color var1);

        public void setTextNonSelectionColor(Color var1);

        public Color getBackgroundSelectionColor();

        public Color getTextSelectionColor();
    }
}

