/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.project.api.WarningState;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.DynamicFileSubset;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.EnumOptionExpression;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.InvalidParameterValueException;
import com.mathworks.project.impl.model.Logger;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.PrefsWatcher;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.ProfileManager;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.model.ReferenceSource;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.VariableGraph;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.model.XmlGenerationContext;
import com.mathworks.project.impl.model.XmlGenerationFlag;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.plugin.DefaultXpathEvaluator;
import com.mathworks.project.impl.plugin.ExpressionBasedTargetAttribute;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.Cache;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Configuration
implements WritableConfiguration {
    private final Target fTarget;
    private final Project fProject;
    private final VariableGraph fData;
    private final Cache<VariableGraph, XslInput> fXslInputCache;
    private final PropertyChangeSupport fPropertySupport = new PropertyChangeSupport(this);
    private final Map<WorkflowStep, List<WorkflowStep>> fDependenciesMap;
    private final ProfileManager fProfileManager;
    private final Set<String> fPendingMatlabDefaults = new HashSet<String>();
    private final boolean fInitializedOnMatlabThread;
    private String fLastBuildChecksum;
    private long fLastBuildTime;
    private File fPreferredPackageLocation;
    private PackageType fPreferredPackageType;
    private boolean fInitialized;
    private boolean fLoaded;
    private Set<String> fArbitraryEnumValueAllowed;
    public static final String NAME_PROPERTY = "name";
    public static final String PACKAGE_LOCATION_PROPERTY = "package-location";
    public static final String PACKAGE_TYPE_PROPERTY = "package-type";
    public static final String BUILD_CHECKSUM_PROPERTY = "build-checksum";
    public static final String BUILD_TIME_PROPERTY = "build-time";
    public static final String PROJECT_TYPE_PROPERTY = "__project_type";
    public static final String PROJECT_WINDOW_TITLE_PROPERTY = "@project-window-title";
    public static final String SETTINGS_DIALOG_WIDTH_PROPERTY = "@settings-dialog-width";
    public static final String SETTINGS_DIALOG_HEIGHT_PROPERTY = "@settings-dialog-height";
    public static final String SELECTED_PROFILE_PROPERTY = "__selected_profile";
    public static final String PACKAGE_ENABLED_PROPERTY = "__package-enabled";
    private static final String PROJECT_FILE_KEY = "@file";
    private static final String PROJECT_NAME_KEY = "@name";
    private static final String PROJECT_LOCATION_KEY = "@location";
    private static final String MORE_INFO_VISIBLE_PREFIX = "__more_info_visible:";
    public static final String PARAM_ENABLED_PREFIX = "__enabled:";
    public static final String PARAM_VISIBLE_PREFIX = "__visible:";
    public static final String PARAM_SYNTAX_PREFIX = "__syntax:";
    public static final String PARAM_SET_VISIBLE_PREFIX = "__paramset_visible:";
    public static final String STEP_ACCESSIBLE_PREFIX = "__accessible:";
    public static final String STEP_EXECUTABLE_PREFIX = "__executable:";
    public static final String STEP_VISIBLE_PREFIX = "__step_visible:";
    public static final String STEP_RESULT_PREFIX = "__result:";
    public static final String STEP_SKIP_PREFIX = "__skip:";
    private static final String ENUM_OPTIONS_PREFIX = "__options:";
    private static final String BUILD_DELIVERABLES_KEY = "__build_deliverables";
    private static final String PREFS_PREFIX = "prefs/";
    private static final OptionListWithDefault UNINITIALIZED_ENUM_OPTION_LIST;

    public Configuration(String string, Target target, Project project) {
        this.fTarget = target;
        this.fProject = project;
        this.fData = new VariableGraph();
        this.fArbitraryEnumValueAllowed = new HashSet<String>();
        this.fDependenciesMap = new LinkedHashMap<WorkflowStep, List<WorkflowStep>>();
        this.fInitializedOnMatlabThread = Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread();
        this.fXslInputCache = new Cache((Cache.Loader)new Cache.Loader<VariableGraph, XslInput>(){

            public XslInput load(VariableGraph variableGraph) {
                return Configuration.this.evaluateXslInput(variableGraph, false, false);
            }
        }, 16);
        project.setConfiguration(this);
        this.initializeData(project.getFile(), string);
        this.fProfileManager = new ProfileManager(this);
        this.fInitialized = true;
    }

    public Project getProject() {
        return this.fProject;
    }

    public ProfileManager getProfileManager() {
        return this.fProfileManager;
    }

    public boolean isBuildChecksumOutdated() {
        return this.fLastBuildChecksum != null && !this.generateChecksum().equals(this.fLastBuildChecksum);
    }

    public void updateBuildChecksum() {
        this.setBuildChecksum(this.generateChecksum());
    }

    void setBuildChecksum(String string) {
        long l = this.fLastBuildTime;
        String string2 = this.fLastBuildChecksum;
        this.fLastBuildChecksum = string != null ? string : this.generateChecksum();
        this.fLastBuildTime = System.currentTimeMillis();
        this.fPropertySupport.firePropertyChange(BUILD_CHECKSUM_PROPERTY, string2, this.fLastBuildChecksum);
        this.fPropertySupport.firePropertyChange(BUILD_TIME_PROPERTY, l, this.fLastBuildTime);
    }

    public String getBuildchecksum() {
        return this.fLastBuildChecksum;
    }

    private String generateChecksum() {
        assert (this.fProject != null);
        CRC32 cRC32 = new CRC32();
        String string = ProjectManager.configurationToXslInput(this.fProject, new XmlGenerationContext(XmlGenerationFlag.EXCLUDE_CHECKSUMS, XmlGenerationFlag.EXCLUDE_PACKAGE_PREFS, XmlGenerationFlag.EXCLUDE_FILESET_PACKAGE));
        cRC32.update(string.getBytes());
        return String.valueOf(cRC32.getValue());
    }

    public File getPreferredPackageLocation() {
        return this.fPreferredPackageLocation;
    }

    public void setPreferredPackageLocation(File file) {
        File file2 = this.fPreferredPackageLocation;
        this.fPreferredPackageLocation = file;
        this.fPropertySupport.firePropertyChange(PACKAGE_LOCATION_PROPERTY, file2, this.fPreferredPackageLocation);
    }

    public PackageType getPreferredPackageType() {
        return this.fPreferredPackageType;
    }

    public void setPreferredPackageType(PackageType packageType) {
        PackageType packageType2 = this.fPreferredPackageType;
        this.fPreferredPackageType = packageType;
        this.fPropertySupport.firePropertyChange(PACKAGE_TYPE_PROPERTY, packageType2, packageType);
    }

    public File getSpecialFileLocation(SpecialFile specialFile) {
        return (File)this.fData.getValue(specialFile.getKey());
    }

    public String getName() {
        return (String)this.fData.getValue(PROJECT_NAME_KEY);
    }

    void setFile(File file) {
        if (this.fInitialized) {
            File file2 = (File)this.fData.getValue(PROJECT_FILE_KEY);
            this.fData.setValue(PROJECT_FILE_KEY, file);
            this.fPropertySupport.firePropertyChange(NAME_PROPERTY, file2, this.fData.getValue(PROJECT_FILE_KEY));
            this.fData.setValue(PROJECT_LOCATION_KEY, file.getParentFile());
        }
    }

    public File getFile() {
        return (File)this.fData.getValue(PROJECT_FILE_KEY);
    }

    public void setName(String string) {
        if (this.fInitialized) {
            String string2 = this.getName();
            this.fData.setValue(PROJECT_NAME_KEY, string);
            this.fPropertySupport.firePropertyChange(NAME_PROPERTY, string2, this.getName());
        }
    }

    public Target getTarget() {
        return this.fTarget;
    }

    public void setParamAsString(String string, String string2) {
        this.setParam(string, string2, ParamType.STRING, ParamType.CUSTOM, ParamType.ENUM);
    }

    public void setParamAsWatermarkString(String string, String string2) {
        this.setParam(string, string2, ParamType.WATERMARK_STRING, ParamType.CUSTOM, ParamType.ENUM);
    }

    public void setParamAsStringList(String string, List<String> list) {
        this.setParam(string, list, ParamType.STRING_LIST, ParamType.CUSTOM);
    }

    public void setParamAsInt(String string, int n) {
        this.setParam(string, n, ParamType.INT, ParamType.CUSTOM);
    }

    public void setParamAsDecimal(String string, BigDecimal bigDecimal) {
        this.setParam(string, bigDecimal, ParamType.DECIMAL, ParamType.CUSTOM);
    }

    public void setParamAsBoolean(String string, boolean bl) {
        this.setParam(string, bl, ParamType.BOOLEAN, ParamType.CUSTOM);
    }

    public void setParamAsFile(String string, File file) {
        this.setParam(string, file, ParamType.FILE, ParamType.DIR, ParamType.OUT_DIR, ParamType.CUSTOM);
    }

    public void setParamAsFileList(String string, List<File> list) {
        this.setParam(string, list, ParamType.FILE_LIST, ParamType.DIR_LIST, ParamType.CUSTOM);
    }

    public void setParamAsXml(String string, XmlReader xmlReader) {
        this.setParam(string, xmlReader, ParamType.CUSTOM);
    }

    public void setParamAsWarnings(String string, Map<String, WarningState> map) {
        this.setParam(string, map, ParamType.WARNINGS);
    }

    public void setParamAsObject(String string, Object object) {
        this.setParam(string, object, ParamType.values());
    }

    public String getResourceString(String string) {
        return this.fTarget.getResourceString(string);
    }

    public String getTargetKey() {
        return this.fTarget.getKey();
    }

    public String getTargetName() {
        return this.fTarget.getName();
    }

    public Set<DynamicFileReference> evaluateDynamicFileSubset(DynamicFileSubset dynamicFileSubset) {
        if (!dynamicFileSubset.equals(this.fTarget.getBuildDeliverables())) {
            throw new IllegalArgumentException("Only the build deliverables subset is currently supported");
        }
        return (Set)this.fData.getValue(BUILD_DELIVERABLES_KEY);
    }

    public FileSetInstance getFileSet(String string) {
        FileSetInstance fileSetInstance = (FileSetInstance)this.fData.getValue(string);
        if (fileSetInstance == null) {
            throw new IllegalArgumentException("Invalid file-set key: " + string);
        }
        return fileSetInstance;
    }

    public Set<String> getParamKeys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ParamSet paramSet : this.getTarget().getParamSets()) {
            for (Param param : paramSet.getParams()) {
                linkedHashSet.add(param.getKey());
            }
        }
        return linkedHashSet;
    }

    public Set<String> getFileSetKeys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (FileSetDefinition fileSetDefinition : this.getTarget().getFileSets()) {
            linkedHashSet.add(fileSetDefinition.getKey());
        }
        return linkedHashSet;
    }

    public com.mathworks.project.api.ParamType getParamType(String string) {
        Param param = this.getTarget().getParam(string);
        return com.mathworks.project.api.ParamType.valueOf((String)param.getType().toString());
    }

    public String getParamAttribute(String string, String string2) {
        Map<String, String> map = this.getTarget().getParam(string).getExtraAttributes();
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        return map.get("_" + string2);
    }

    public Object getParamAsObject(String string) {
        return this.getParamAsObject(string, new XmlGenerationContext(new XmlGenerationFlag[0]));
    }

    public Object getParamDefaultValue(String string) {
        OptionListWithDefault optionListWithDefault;
        String string2 = ENUM_OPTIONS_PREFIX + string;
        if (this.fData.hasVariable(string2) && (optionListWithDefault = (OptionListWithDefault)this.fData.getValue(string2)) != null) {
            return optionListWithDefault.getDefault();
        }
        return this.fData.getDefaultValue(string);
    }

    public Object getParamAsObject(String string, XmlGenerationContext xmlGenerationContext) {
        this.assertProjectFileValid();
        this.assertExistenceAndType(string, ParamType.values());
        return this.fData.getValue(string);
    }

    public String getParamAsString(String string) {
        Object object = this.getParam(string, ParamType.DECIMAL, ParamType.STRING, ParamType.INT, ParamType.BOOLEAN, ParamType.DIR, ParamType.ENUM, ParamType.FILE, ParamType.CUSTOM, ParamType.WATERMARK_STRING, ParamType.OUT_DIR);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getParamAsWatermarkString(String string) {
        return this.getParamAsString(string);
    }

    public List<String> getParamAsStringList(String string) {
        return (List)this.getParam(string, ParamType.STRING_LIST, ParamType.CUSTOM, ParamType.WATERMARK_STRING);
    }

    public int getParamAsInt(String string) {
        return (Integer)this.getParam(string, ParamType.INT, ParamType.CUSTOM, ParamType.WATERMARK_STRING);
    }

    public BigDecimal getParamAsDecimal(String string) {
        return (BigDecimal)this.getParam(string, ParamType.DECIMAL, ParamType.CUSTOM);
    }

    public boolean getParamAsBoolean(String string) {
        return (Boolean)this.getParam(string, ParamType.BOOLEAN, ParamType.CUSTOM, ParamType.WATERMARK_STRING);
    }

    public File getParamAsFile(String string) {
        return (File)this.getParam(string, ParamType.FILE, ParamType.DIR, ParamType.CUSTOM, ParamType.WATERMARK_STRING, ParamType.OUT_DIR);
    }

    public List<File> getParamAsFileList(String string) {
        return (List)this.getParam(string, ParamType.FILE_LIST, ParamType.DIR_LIST, ParamType.CUSTOM, ParamType.WATERMARK_STRING);
    }

    public XmlReader getParamReader(String string) throws IOException {
        Object object = this.getParam(string, ParamType.values());
        if (object instanceof XmlReader) {
            return (XmlReader)object;
        }
        return XmlApi.getInstance().read(object.toString());
    }

    public Map<String, WarningState> getParamAsWarnings(String string) {
        return (Map)this.getParam(string, ParamType.WARNINGS, ParamType.CUSTOM, ParamType.WATERMARK_STRING);
    }

    public OptionListWithDefault getParamOptions(String string) {
        return (OptionListWithDefault)this.fData.getValue(ENUM_OPTIONS_PREFIX + string);
    }

    public void refreshParamOptions(String string) {
        this.assertExistenceAndType(string, ParamType.ENUM);
        Param param = this.fTarget.getParam(string);
        if (param.getOptionExpression() != null) {
            this.fData.generateDefaults(new HashSet<String>(Arrays.asList(Configuration.getEnumOptionsKey(param))));
        }
    }

    public static boolean isUninitialized(OptionListWithDefault optionListWithDefault) {
        return optionListWithDefault == UNINITIALIZED_ENUM_OPTION_LIST;
    }

    public ProjectType getProjectType() {
        return (ProjectType)this.fData.getValue(PROJECT_TYPE_PROPERTY);
    }

    public boolean isPackageEnabled() {
        return this.fTarget.getPackageScript() != null && (Boolean)this.fData.getValue(PACKAGE_ENABLED_PROPERTY) != false;
    }

    public String getProjectWindowTitle() {
        return (String)this.fData.getValue(PROJECT_WINDOW_TITLE_PROPERTY);
    }

    public int getSettingsDialogWidth() {
        return (Integer)this.fData.getValue(SETTINGS_DIALOG_WIDTH_PROPERTY);
    }

    public int getSettingsDialogHeight() {
        return (Integer)this.fData.getValue(SETTINGS_DIALOG_HEIGHT_PROPERTY);
    }

    public String getXML() {
        this.assertProjectFileValid();
        return ProjectManager.configurationToXml(this.fProject);
    }

    public VariableGraph getVariableGraph() {
        return this.fData;
    }

    public static boolean isBuildDeliverableChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(BUILD_DELIVERABLES_KEY);
    }

    public Param getChangedParam(PropertyChangeEvent propertyChangeEvent) {
        return this.fTarget.getParam(propertyChangeEvent.getPropertyName());
    }

    public static boolean isParamEnabledChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(PARAM_ENABLED_PREFIX);
    }

    public static boolean isParamVisibilityChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(PARAM_VISIBLE_PREFIX);
    }

    public static boolean isMoreInfoVisibilityChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(MORE_INFO_VISIBLE_PREFIX);
    }

    public static boolean isParamSyntaxChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(PARAM_SYNTAX_PREFIX);
    }

    public Param getParamWithAffectedState(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().startsWith(PARAM_ENABLED_PREFIX)) {
            return this.fTarget.getParam(propertyChangeEvent.getPropertyName().substring(PARAM_ENABLED_PREFIX.length()));
        }
        if (propertyChangeEvent.getPropertyName().startsWith(PARAM_VISIBLE_PREFIX)) {
            return this.fTarget.getParam(propertyChangeEvent.getPropertyName().substring(PARAM_VISIBLE_PREFIX.length()));
        }
        if (propertyChangeEvent.getPropertyName().startsWith(PARAM_SYNTAX_PREFIX)) {
            return this.fTarget.getParam(propertyChangeEvent.getPropertyName().substring(PARAM_SYNTAX_PREFIX.length()));
        }
        if (propertyChangeEvent.getPropertyName().startsWith(MORE_INFO_VISIBLE_PREFIX)) {
            return this.fTarget.getParam(propertyChangeEvent.getPropertyName().substring(MORE_INFO_VISIBLE_PREFIX.length()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
            this.fData.addPropertyChangeListener(propertyChangeListener);
            for (FileSetDefinition fileSetDefinition : this.getTarget().getFileSets()) {
                FileSetInstance fileSetInstance = this.getFileSet(fileSetDefinition.getKey());
                fileSetInstance.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
            this.fData.removePropertyChangeListener(propertyChangeListener);
            for (FileSetDefinition fileSetDefinition : this.getTarget().getFileSets()) {
                this.getFileSet(fileSetDefinition.getKey()).removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnsetParamKeys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        VariableGraph variableGraph = this.fData;
        synchronized (variableGraph) {
            for (ParamSet paramSet : this.fTarget.getParamSets()) {
                for (Param param : paramSet.getParams()) {
                    if (this.fData.isExplicitlySet(param.getKey())) continue;
                    linkedHashSet.add(param.getKey());
                }
            }
        }
        return linkedHashSet;
    }

    public static String getEnumOptionsKey(Param param) {
        return ENUM_OPTIONS_PREFIX + param.getKey();
    }

    public boolean isParamVisible(String string) {
        this.assertExistenceAndType(string, ParamType.values());
        return (Boolean)this.fData.getValue(PARAM_VISIBLE_PREFIX + string);
    }

    public boolean isMoreInfoVisible(String string) {
        this.assertExistenceAndType(string, ParamType.values());
        if (this.fTarget.getParam(string).getMoreInfoLinkVisible() == null) {
            return true;
        }
        return (Boolean)this.fData.getValue(MORE_INFO_VISIBLE_PREFIX + string);
    }

    public boolean isParamSetVisible(String string) {
        return (Boolean)this.fData.getValue(PARAM_SET_VISIBLE_PREFIX + string);
    }

    public static boolean isParamSetVisibilityChange(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(PARAM_SET_VISIBLE_PREFIX);
    }

    public boolean isParamExplicitlySet(String string) {
        return this.fData.isExplicitlySet(string);
    }

    public boolean shouldSaveImplicitValues(String string) {
        Param param = this.getTarget().getParam(string);
        return param.shouldSaveUnsetValue();
    }

    public static boolean isAlwaysDisabled(Param param) {
        if (param.getEnabledAttribute() != null) {
            try {
                XmlReader xmlReader = ProjectManager.createStaticXslInput();
                String string = param.getEnabledAttribute().evaluateString(new XslInput(xmlReader));
                return string != null && string.equals("false");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAlwaysInvisible(ParamSet paramSet) {
        if (paramSet.getVisibleAttribute() == null) {
            return false;
        }
        DynamicTargetAttribute dynamicTargetAttribute = paramSet.getVisibleAttribute();
        return dynamicTargetAttribute instanceof ExpressionBasedTargetAttribute && ((ExpressionBasedTargetAttribute)dynamicTargetAttribute).isAlwaysBooleanValue(false);
    }

    public static boolean isAlwaysInvisible(ParamSet paramSet, Param param, Profile profile) {
        if (!paramSet.getProfileKeys().isEmpty() && !paramSet.getProfileKeys().contains(profile.getKey())) {
            return true;
        }
        if (!param.getProfileKeys().isEmpty() && !param.getProfileKeys().contains(profile.getKey())) {
            return true;
        }
        if (param.getVisibleAttribute() != null) {
            if (param.getVisibleAttribute() instanceof ExpressionBasedTargetAttribute) {
                ExpressionBasedTargetAttribute expressionBasedTargetAttribute = (ExpressionBasedTargetAttribute)param.getVisibleAttribute();
                return expressionBasedTargetAttribute.isAlwaysBooleanValue(false);
            }
            try {
                XmlReader xmlReader = ProjectManager.createStaticXslInput();
                String string = param.getVisibleAttribute().evaluateString(new XslInput(xmlReader));
                return string != null && string.equals("false");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public Profile getActiveProfile() {
        return (Profile)this.fData.getValue(SELECTED_PROFILE_PROPERTY);
    }

    public void setForcedDisabled(String string, boolean bl) {
        String string2 = PARAM_ENABLED_PREFIX + string;
        if (bl) {
            this.fData.setValue(string2, false);
        } else {
            this.fData.setValue(string2, this.fData.getDefaultValue(string2));
        }
    }

    public boolean isParamEnabled(String string) {
        this.assertExistenceAndType(string, ParamType.values());
        return (Boolean)this.fData.getValue(PARAM_ENABLED_PREFIX + string);
    }

    public String getParamSyntax(String string) {
        this.assertExistenceAndType(string, ParamType.values());
        return (String)this.fData.getValue(PARAM_SYNTAX_PREFIX + string);
    }

    Object getSetParameterValue(String string) {
        this.assertExistenceAndType(string, ParamType.values());
        return this.fData.getExplicitValue(string);
    }

    private void setParam(String string, Object object, ParamType ... paramTypeArray) {
        this.assertProjectFileValid();
        this.assertExistenceAndType(string, paramTypeArray);
        this.fData.setValue(string, object);
    }

    private Object getParam(String string, ParamType ... paramTypeArray) {
        this.assertProjectFileValid();
        this.assertExistenceAndType(string, paramTypeArray);
        return this.fData.getValue(string);
    }

    private void assertExistenceAndType(String string, ParamType ... paramTypeArray) {
        Param param = this.fTarget.getParam(string);
        if (param == null) {
            throw new IllegalArgumentException("Invalid param key: " + string);
        }
        ParamType paramType = param.getType();
        for (ParamType paramType2 : paramTypeArray) {
            if (paramType != paramType2) continue;
            return;
        }
        throw new IllegalArgumentException("Attempting to set param " + string + " to invalid type");
    }

    private void assertProjectFileValid() {
        if (this.fProject.getFile() == null || !this.fProject.getFile().getName().startsWith(this.getName())) {
            throw new IllegalStateException("The project file has not been correctly assigned to configuration " + this.getName());
        }
    }

    private static WorkflowStepResult getWorkflowStepResult(WorkflowStep workflowStep, VariableGraph variableGraph) {
        return (WorkflowStepResult)((Object)variableGraph.getValue(STEP_RESULT_PREFIX + workflowStep.getKey()));
    }

    public boolean isStepAccessible(WorkflowStep workflowStep) {
        Object object = this.fData.getValue(STEP_ACCESSIBLE_PREFIX + workflowStep.getKey());
        if (object == null) {
            object = Boolean.FALSE;
        }
        return (Boolean)object;
    }

    public boolean isStepVisible(WorkflowStep workflowStep) {
        return (Boolean)this.fData.getValue(STEP_VISIBLE_PREFIX + workflowStep.getKey());
    }

    public static boolean isStepVisible(WorkflowStep workflowStep, VariableGraph variableGraph) {
        return (Boolean)variableGraph.getValue(STEP_VISIBLE_PREFIX + workflowStep.getKey());
    }

    public boolean isStepExecutable(WorkflowStep workflowStep) {
        return (Boolean)this.fData.getValue(STEP_EXECUTABLE_PREFIX + workflowStep.getKey());
    }

    public boolean isWorkflowStepSkipped(WorkflowStep workflowStep) {
        return Configuration.isWorkflowStepSkipped(workflowStep, this.fData);
    }

    public static boolean isWorkflowStepSkipped(WorkflowStep workflowStep, VariableGraph variableGraph) {
        Object object = variableGraph.getValue(STEP_SKIP_PREFIX + workflowStep.getKey());
        if (object == null) {
            object = workflowStep.isSkippedByDefault();
        }
        return (Boolean)object;
    }

    public boolean isWorkflowStepSkippedEvent(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(STEP_SKIP_PREFIX);
    }

    public void setWorkflowStepAccessible(WorkflowStep workflowStep, boolean bl) {
        this.fData.setValue(STEP_ACCESSIBLE_PREFIX + workflowStep.getKey(), bl);
    }

    public void setWorkflowStepExecutable(WorkflowStep workflowStep, boolean bl) {
        this.fData.setValue(STEP_EXECUTABLE_PREFIX + workflowStep.getKey(), bl);
    }

    public void setWorkflowStepSkipped(WorkflowStep workflowStep, boolean bl) {
        this.fData.setValue(STEP_SKIP_PREFIX + workflowStep.getKey(), bl);
    }

    public WorkflowStepResult getWorkflowStepResult(WorkflowStep workflowStep) {
        return (WorkflowStepResult)((Object)this.fData.getValue(STEP_RESULT_PREFIX + workflowStep.getKey()));
    }

    public void setWorkflowStepResult(WorkflowStep workflowStep, WorkflowStepResult workflowStepResult) {
        this.fData.setValue(STEP_RESULT_PREFIX + workflowStep.getKey(), (Object)workflowStepResult);
    }

    public static boolean isWorkflowStepEvent(WorkflowStep workflowStep, PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().equals(STEP_ACCESSIBLE_PREFIX + workflowStep.getKey()) || propertyChangeEvent.getPropertyName().equals(STEP_EXECUTABLE_PREFIX + workflowStep.getKey()) || propertyChangeEvent.getPropertyName().equals(STEP_RESULT_PREFIX + workflowStep.getKey());
    }

    public static boolean isWorkflowStepEvent(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getPropertyName().startsWith(STEP_ACCESSIBLE_PREFIX) || propertyChangeEvent.getPropertyName().startsWith(STEP_EXECUTABLE_PREFIX) || propertyChangeEvent.getPropertyName().startsWith(STEP_RESULT_PREFIX);
    }

    private void initializeData(File file, String string) {
        Logger.log(this, "initializeData", "Initializing Configuration data for %s", file);
        TreeSet<String> treeSet = new TreeSet<String>();
        this.fData.setDefaultGenerator(PROJECT_FILE_KEY, VariableGraph.NULL_GENERATOR);
        this.fData.setDefaultGenerator(PROJECT_NAME_KEY, VariableGraph.NULL_GENERATOR);
        this.fData.setDefaultGenerator(PROJECT_LOCATION_KEY, VariableGraph.NULL_GENERATOR);
        this.fData.setDefaultGenerator(PROJECT_WINDOW_TITLE_PROPERTY, new ProjectWindowTitleGenerator());
        this.fData.setDefaultGenerator(SETTINGS_DIALOG_WIDTH_PROPERTY, new SettingsDialogWidthGenerator());
        this.fData.setDefaultGenerator(SETTINGS_DIALOG_HEIGHT_PROPERTY, new SettingsDialogHeightGenerator());
        this.fData.setDefaultGenerator(PACKAGE_ENABLED_PROPERTY, new PackageEnabledGenerator());
        treeSet.add(PROJECT_FILE_KEY);
        treeSet.add(PROJECT_NAME_KEY);
        treeSet.add(PROJECT_LOCATION_KEY);
        treeSet.add("template-key");
        treeSet.add("template-name");
        treeSet.add("template-file");
        List<ParamSet> list = this.fTarget.getParamSets();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Iterator<Object> iterator = object2.next();
            this.fData.setDefaultGenerator(PARAM_SET_VISIBLE_PREFIX + ((ParamSet)((Object)iterator)).getKey(), new ParamBooleanAttributeGenerator(PARAM_SET_VISIBLE_PREFIX + ((ParamSet)((Object)iterator)).getKey(), ((ParamSet)((Object)iterator)).getVisibleAttribute(), ((ParamSet)((Object)iterator)).getProfileKeys()));
            for (Param param : ((ParamSet)((Object)iterator)).getParams()) {
                treeSet.add(param.getKey());
                this.fData.setDefaultGenerator(param.getKey(), new ParamDefaultGenerator(param));
                this.fData.setSerializer(param.getKey(), new ParamSerializer(param));
                this.fData.setDefaultGenerator(PARAM_SYNTAX_PREFIX + param.getKey(), new ParamStringAttributeGenerator(PARAM_SYNTAX_PREFIX + param.getKey(), param.getSyntax()));
                this.fData.setDefaultGenerator(PARAM_ENABLED_PREFIX + param.getKey(), new ParamBooleanAttributeGenerator(PARAM_ENABLED_PREFIX + param.getKey(), param.getEnabledAttribute(), new HashSet<String>()));
                this.fData.setDefaultGenerator(PARAM_VISIBLE_PREFIX + param.getKey(), new ParamBooleanAttributeGenerator(PARAM_VISIBLE_PREFIX + param.getKey(), param.getVisibleAttribute(), param.getProfileKeys()));
                if (param.getMoreInfoLinkVisible() != null) {
                    this.fData.setDefaultGenerator(MORE_INFO_VISIBLE_PREFIX + param.getKey(), new ParamBooleanAttributeGenerator(MORE_INFO_VISIBLE_PREFIX + param.getKey(), param.getMoreInfoLinkVisible(), param.getProfileKeys()));
                }
                if (param.getOptionExpression() != null && param.getType().equals((Object)ParamType.ENUM)) {
                    String string2 = ENUM_OPTIONS_PREFIX + param.getKey();
                    this.fData.setDefaultGenerator(string2, new EnumOptionsGenerator(string2, param));
                } else {
                    for (String string3 : param.getDependentKeys()) {
                        this.fData.addDependency(param.getKey(), string3);
                    }
                }
                if (param.getDefaultValueExpression() == null || param.getType() == ParamType.ENUM) continue;
                this.fData.setDefaultGenerator(param.getKey(), new MatlabBasedDefaultGenerator(param));
            }
        }
        if (this.fTarget.getWorkflow() != null) {
            this.addWorkflowStepsRecursively(treeSet, new ArrayList<WorkflowStep>(), this.fTarget.getWorkflow().getSteps(), new LinkedHashSet<String>());
        }
        if ((object2 = ProjectManager.getPrefsWatcher(this.fProject)) != null) {
            for (String string4 : ((PrefsWatcher)object2).getUsedKeys()) {
                treeSet.add(PREFS_PREFIX + string4);
                this.fData.setDefaultGenerator(PREFS_PREFIX + string4, VariableGraph.NULL_GENERATOR);
            }
        }
        if (this.fTarget.getBuildDeliverables() != null) {
            this.fData.setDefaultGenerator(BUILD_DELIVERABLES_KEY, new DynamicFileSubsetGenerator(BUILD_DELIVERABLES_KEY, this.fTarget.getBuildDeliverables()));
            this.addDependencies(BUILD_DELIVERABLES_KEY, this.fTarget.getBuildDeliverables().getGenerator(), treeSet);
        }
        for (FileSetDefinition fileSetDefinition : this.fTarget.getFileSets()) {
            treeSet.add(fileSetDefinition.getKey());
            this.fData.setDefaultGenerator(fileSetDefinition.getKey(), VariableGraph.NULL_GENERATOR);
            this.fData.setSerializer(fileSetDefinition.getKey(), new FileSetSerializer());
            for (SpecialFile specialFile : fileSetDefinition.getSpecialFiles()) {
                this.fData.setDefaultGenerator(specialFile.getKey(), new SpecialFileGenerator(specialFile));
                for (DynamicTargetAttribute dynamicTargetAttribute : specialFile.getLocationGenerators()) {
                    this.addDependencies(specialFile.getKey(), dynamicTargetAttribute, treeSet);
                }
            }
        }
        for (ParamSet paramSet : list) {
            this.addDependencies(PARAM_SET_VISIBLE_PREFIX + paramSet.getKey(), paramSet.getVisibleAttribute(), treeSet);
            if (!paramSet.getProfileKeys().isEmpty()) {
                this.fData.addDependency(PARAM_SET_VISIBLE_PREFIX + paramSet.getKey(), SELECTED_PROFILE_PROPERTY);
            }
            for (Param param : paramSet.getParams()) {
                this.addDependencies(param.getKey(), param.getDefaultValueAttribute(), treeSet);
                this.addDependencies(PARAM_ENABLED_PREFIX + param.getKey(), param.getEnabledAttribute(), treeSet);
                this.addDependencies(PARAM_VISIBLE_PREFIX + param.getKey(), param.getVisibleAttribute(), treeSet);
                this.addDependencies(PARAM_SYNTAX_PREFIX + param.getKey(), param.getSyntax(), treeSet);
                if (param.getMoreInfoLinkVisible() != null) {
                    this.addDependencies(MORE_INFO_VISIBLE_PREFIX + param.getKey(), param.getMoreInfoLinkVisible(), treeSet);
                }
                if (param.getOptionExpression() != null) {
                    Set<String> set = param.getDependentKeys();
                    if (set.isEmpty()) {
                        this.addDependencies(ENUM_OPTIONS_PREFIX + param.getKey(), param.getOptionExpression(), treeSet);
                    } else {
                        for (String string5 : set) {
                            this.fData.addDependency(ENUM_OPTIONS_PREFIX + param.getKey(), string5);
                        }
                    }
                }
                if (param.getProfileKeys().isEmpty()) continue;
                this.fData.addDependency(PARAM_VISIBLE_PREFIX + param.getKey(), SELECTED_PROFILE_PROPERTY);
            }
        }
        this.fData.setDefaultGenerator(SELECTED_PROFILE_PROPERTY, new SelectedProfileGenerator());
        for (String string6 : treeSet) {
            for (Profile profile : this.fTarget.getProfiles()) {
                if (profile.getSelectedAttribute() == null || !profile.getSelectedAttribute().hasReference(string6)) continue;
                this.fData.addDependency(SELECTED_PROFILE_PROPERTY, string6);
            }
        }
        this.fData.setDefaultGenerator(PROJECT_TYPE_PROPERTY, new ProjectTypeGenerator());
        this.fData.setDefaultGenerator("template-key", new VariableGraph.Generator(){

            @Override
            public Object generateValue(String string, VariableGraph variableGraph) {
                return ((ProjectType)variableGraph.getValue(Configuration.PROJECT_TYPE_PROPERTY)).getKey();
            }
        });
        this.fData.setDefaultGenerator("template-name", new VariableGraph.Generator(){

            @Override
            public Object generateValue(String string, VariableGraph variableGraph) {
                return ((ProjectType)variableGraph.getValue(Configuration.PROJECT_TYPE_PROPERTY)).getName();
            }
        });
        this.fData.setDefaultGenerator("template-file", new VariableGraph.Generator(){

            @Override
            public Object generateValue(String string, VariableGraph variableGraph) {
                ProjectType projectType = (ProjectType)variableGraph.getValue(Configuration.PROJECT_TYPE_PROPERTY);
                return projectType.getTemplate() != null ? projectType.getTemplate().getFile().getName() : null;
            }
        });
        this.fData.addDependency("template-name", PROJECT_TYPE_PROPERTY);
        this.fData.addDependency("template-key", PROJECT_TYPE_PROPERTY);
        this.fData.addDependency("template-file", PROJECT_TYPE_PROPERTY);
        for (ProjectType projectType : this.fTarget.getProjectTypes()) {
            if (projectType.getTemplate() == null) continue;
            Project project = projectType.getTemplate();
            for (ParamSet paramSet : project.getConfiguration().getTarget().getParamSets()) {
                for (Param param : paramSet.getParams()) {
                    if (project.getConfiguration().getSetParameterValue(param.getKey()) == null) continue;
                    this.fData.addDependency(PROJECT_TYPE_PROPERTY, param.getKey());
                }
            }
        }
        this.addDependencies(PROJECT_WINDOW_TITLE_PROPERTY, this.fTarget.getProjectWindowTitle(), treeSet);
        this.addDependencies(SETTINGS_DIALOG_HEIGHT_PROPERTY, this.fTarget.getSettingsDialogHeight(), treeSet);
        this.addDependencies(SETTINGS_DIALOG_WIDTH_PROPERTY, this.fTarget.getSettingsDialogWidth(), treeSet);
        this.addDependencies(PACKAGE_ENABLED_PROPERTY, this.fTarget.getPackageEnabledAttribute(), treeSet);
        Logger.log(this, "initializeData", "Finished setting up VariableGraph for %s", file);
        Logger.log(this, "initializeData", "Setting known initial values for %s", file);
        this.fData.setValue(PROJECT_FILE_KEY, file);
        this.fData.setValue(PROJECT_NAME_KEY, string);
        this.fData.setValue(PROJECT_LOCATION_KEY, file.getParentFile());
        for (final FileSetDefinition fileSetDefinition : this.fTarget.getFileSets()) {
            final FileSetInstance fileSetInstance = new FileSetInstance(fileSetDefinition, this.fProject);
            this.fData.setValue(fileSetDefinition.getKey(), fileSetInstance);
            fileSetInstance.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Configuration.this.fData.setValue(fileSetDefinition.getKey(), fileSetInstance);
                }
            });
            if (!fileSetDefinition.getKey().equals("fileset.package") || this.fTarget.getBuildDeliverables() == null) continue;
            fileSetInstance.add(this.fTarget.getBuildDeliverables());
        }
        for (FileSetDefinition fileSetDefinition : this.fTarget.getFileSets()) {
            FileSetInstance fileSetInstance = this.getFileSet(fileSetDefinition.getKey());
            fileSetInstance.addSpecialFileWatcher();
        }
        if (object2 != null) {
            for (String string7 : ((PrefsWatcher)object2).getUsedKeys()) {
                this.fData.setValue(PREFS_PREFIX + string7, Prefs.getPref((String)string7));
            }
            ((PrefsWatcher)object2).addChangeListener(new ChangeListener((PrefsWatcher)object2){
                final /* synthetic */ PrefsWatcher val$prefsWatcher;
                {
                    this.val$prefsWatcher = prefsWatcher;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    for (String string : this.val$prefsWatcher.getUsedKeys()) {
                        Configuration.this.fData.setValue(Configuration.PREFS_PREFIX + string, Prefs.getPref((String)string));
                    }
                }
            });
        }
        Logger.log(this, "initializeData", "complete for %s", file);
    }

    private void addWorkflowStepsRecursively(Set<String> set, List<WorkflowStep> list, List<WorkflowStep> list2, Set<String> set2) {
        for (WorkflowStep workflowStep : list2) {
            set.add(STEP_RESULT_PREFIX + workflowStep.getKey());
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            List<ParamSet> list3 = workflowStep.getParamSets();
            for (ParamSet paramSet : list3) {
                for (Param param : paramSet.getParams()) {
                    linkedHashSet.add(param.getKey());
                }
            }
            linkedHashSet.addAll(set2);
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(list);
            this.fDependenciesMap.remove(workflowStep);
            this.fDependenciesMap.put(workflowStep, linkedList);
            this.fData.setDefaultGenerator(STEP_RESULT_PREFIX + workflowStep.getKey(), VariableGraph.NULL_GENERATOR);
            this.fData.setDefaultGenerator(STEP_SKIP_PREFIX + workflowStep.getKey(), VariableGraph.NULL_GENERATOR);
            this.fData.setDefaultGenerator(STEP_ACCESSIBLE_PREFIX + workflowStep.getKey(), VariableGraph.NULL_GENERATOR);
            this.fData.setDefaultGenerator(STEP_EXECUTABLE_PREFIX + workflowStep.getKey(), VariableGraph.NULL_GENERATOR);
            this.fData.setDefaultGenerator(STEP_VISIBLE_PREFIX + workflowStep.getKey(), new ParamBooleanAttributeGenerator(STEP_VISIBLE_PREFIX + workflowStep.getKey(), workflowStep.getVisibleAttribute(), new HashSet<String>(0)));
            this.addWorkflowStepsRecursively(set, list, workflowStep.getSubSteps(), linkedHashSet);
            this.addDependencies(STEP_VISIBLE_PREFIX + workflowStep.getKey(), workflowStep.getVisibleAttribute(), set2);
            list.add(workflowStep);
        }
    }

    public boolean hasEnabledOrVisibleDependency(Param param, Param param2) {
        Set<String> set = this.fData.getDependenciesOf(PARAM_ENABLED_PREFIX + param.getKey());
        if (set != null && set.contains(param2.getKey())) {
            return true;
        }
        Set<String> set2 = this.fData.getDependenciesOf(PARAM_VISIBLE_PREFIX + param.getKey());
        return set2 != null && set2.contains(param2.getKey());
    }

    public String evaluateString(DynamicTargetAttribute dynamicTargetAttribute) {
        XslInput xslInput = new XslInput(ProjectManager.configurationToXslInput(this.fProject));
        return dynamicTargetAttribute == null ? null : dynamicTargetAttribute.evaluateString(xslInput);
    }

    private XslInput evaluateXslInput(VariableGraph variableGraph, boolean bl) {
        return this.evaluateXslInput(variableGraph, true, bl);
    }

    private XslInput evaluateXslInput(VariableGraph variableGraph, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            try {
                return (XslInput)this.fXslInputCache.get((Object)variableGraph);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        XmlGenerationContext xmlGenerationContext = bl2 ? new XmlGenerationContext(new XmlGenerationFlag[0]) : new XmlGenerationContext(XmlGenerationFlag.EXCLUDE_TEMPLATE_INFO);
        XmlWriter xmlWriter = ProjectManager.createXslInputRoot(this.fProject, xmlGenerationContext);
        variableGraph.writeAllXml(xmlWriter);
        ProjectManager.writePrefsSection(ProjectManager.getPrefsWatcher(this.fProject), xmlWriter);
        ProjectManager.writePlatformSection(xmlWriter);
        ProjectManager.writeMatlabSection(this.fProject, xmlWriter, new XmlGenerationContext(XmlGenerationFlag.EXCLUDE_PATH));
        return new XslInput(xmlWriter.getXML());
    }

    private XmlReader readXslInput(VariableGraph variableGraph, boolean bl) {
        try {
            String string = this.evaluateXslInput(variableGraph, false, bl).getText();
            return XmlApi.getInstance().read(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private void addDependencies(String string, ReferenceSource referenceSource, Set<String> set) {
        if (referenceSource != null) {
            for (String string2 : set) {
                if (!referenceSource.hasReference(string2)) continue;
                this.fData.addDependency(string, string2);
            }
        }
    }

    private boolean requiresTemplateInfo(String string) {
        return this.fData.hasDependency(string, "template-key") || this.fData.hasDependency(string, "template-name") || this.fData.hasDependency(string, "template-file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingMatlabDefaults() {
        Set<String> set = this.fPendingMatlabDefaults;
        synchronized (set) {
            return !this.fPendingMatlabDefaults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingMatlabDefault(String string) {
        Set<String> set = this.fPendingMatlabDefaults;
        synchronized (set) {
            this.fPendingMatlabDefaults.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingMatlabDefault(String string) {
        Set<String> set = this.fPendingMatlabDefaults;
        synchronized (set) {
            this.fPendingMatlabDefaults.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAffectedByPendingMatlabDefaults(String string) {
        Set<String> set = this.fPendingMatlabDefaults;
        synchronized (set) {
            for (String string2 : this.fData.getDependenciesOf(string)) {
                if (!this.fPendingMatlabDefaults.contains(string2) && !this.isAffectedByPendingMatlabDefaults(string2)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isArbitraryEnumValueAllowed(String string) {
        return this.fArbitraryEnumValueAllowed.contains(string);
    }

    public void setArbitraryEnumValueAllowed(String string, boolean bl) {
        if (bl) {
            this.fArbitraryEnumValueAllowed.add(string);
        } else {
            this.fArbitraryEnumValueAllowed.remove(string);
        }
    }

    public void loadingFinished() {
        Logger.log(this, "loadingFinished", "Entering loaded state", new Object[0]);
        this.fLoaded = true;
        this.fProfileManager.loadingFinished();
        this.regenerateDefaults();
    }

    public void regenerateDefaults() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(PROJECT_TYPE_PROPERTY);
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet2.addAll(this.fData.getAllAffectedVariables(PROJECT_TYPE_PROPERTY));
        for (ParamSet paramSet : this.fTarget.getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (param.getOptionExpression() != null) {
                    String string = ENUM_OPTIONS_PREFIX + param.getKey();
                    treeSet.add(string);
                    treeSet2.addAll(this.fData.getAllAffectedVariables(string));
                    continue;
                }
                if (param.getDefaultValueExpression() == null) continue;
                treeSet.add(param.getKey());
            }
        }
        Logger.log(this, "regenerateDefaults", "Regenerating directly affected values: %s", treeSet);
        this.fData.generateDefaults(treeSet);
        Logger.log(this, "regenerateDefaults", "Regenerating indirectly affected values: %s", treeSet2);
        this.fData.generateDefaults(treeSet2);
    }

    static {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("", "");
        UNINITIALIZED_ENUM_OPTION_LIST = new OptionListWithDefault(linkedHashMap, "");
    }

    private class FileSetSerializer
    implements VariableGraph.XmlSerializer {
        private FileSetSerializer() {
        }

        @Override
        public String serialize(Object object) {
            FileSetInstance fileSetInstance = (FileSetInstance)object;
            XmlWriter xmlWriter = XmlApi.getInstance().create("configuration");
            ProjectManager.serializeFileSet(Configuration.this.fProject.getFile(), Configuration.this, xmlWriter, fileSetInstance.getDefinition(), fileSetInstance, new XmlGenerationContext(new XmlGenerationFlag[0]));
            try {
                XmlReader xmlReader = XmlApi.getInstance().read(xmlWriter.getXML());
                return xmlReader.getChild(new String[]{fileSetInstance.getDefinition().getKey()}).getXML();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    private class ParamSerializer
    implements VariableGraph.XmlSerializer {
        private final Param fParam;

        ParamSerializer(Param param) {
            this.fParam = param;
        }

        @Override
        public String serialize(Object object) {
            XmlWriter xmlWriter = XmlApi.getInstance().create(this.fParam.getKey());
            this.fParam.getType().serialize(Configuration.this.fProject, this.fParam, object, xmlWriter, false);
            return xmlWriter.getXML();
        }
    }

    private class SettingsDialogHeightGenerator
    implements VariableGraph.Generator {
        private SettingsDialogHeightGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            if (Configuration.this.fTarget.getSettingsDialogHeight() != null) {
                return Integer.parseInt(Configuration.this.fTarget.getSettingsDialogHeight().evaluateString(Configuration.this.evaluateXslInput(variableGraph, false)).trim());
            }
            return 0;
        }
    }

    private class SettingsDialogWidthGenerator
    implements VariableGraph.Generator {
        private SettingsDialogWidthGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            if (Configuration.this.fTarget.getSettingsDialogWidth() != null) {
                return Integer.parseInt(Configuration.this.fTarget.getSettingsDialogWidth().evaluateString(Configuration.this.evaluateXslInput(variableGraph, false)).trim());
            }
            return 0;
        }
    }

    private class PackageEnabledGenerator
    implements VariableGraph.Generator {
        private PackageEnabledGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            return Configuration.this.fTarget.getPackageEnabledAttribute() == null || Configuration.this.fTarget.getPackageEnabledAttribute().evaluateBoolean(Configuration.this.evaluateXslInput(variableGraph, false));
        }
    }

    private class ProjectWindowTitleGenerator
    implements VariableGraph.Generator {
        private ProjectWindowTitleGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            if (Configuration.this.fTarget.getProjectWindowTitle() != null) {
                String string2 = Configuration.this.fTarget.getProjectWindowTitle().evaluateString(Configuration.this.evaluateXslInput(variableGraph, false));
                return Configuration.this.fTarget.getResourceString(string2);
            }
            return null;
        }
    }

    private class ProjectTypeGenerator
    implements VariableGraph.Generator {
        private ProjectTypeGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            ProjectType projectType = new ProjectType(Configuration.this.fTarget, null, Configuration.this.fTarget.getName(), Configuration.this.fTarget.getIcon(), Configuration.this.fTarget.getDescription(), null, new LinkedHashSet<String>());
            if (Configuration.this.fLoaded) {
                for (ProjectType projectType2 : Configuration.this.fTarget.getProjectTypes()) {
                    if (projectType2.getTemplate() == null) {
                        projectType = projectType2;
                        continue;
                    }
                    if (this.findDifference(projectType2.getTemplate())) continue;
                    return projectType2;
                }
            }
            return projectType;
        }

        private boolean findDifference(Project project) {
            for (ParamSet paramSet : Configuration.this.fTarget.getParamSets()) {
                for (Param param : paramSet.getParams()) {
                    Object object = project.getConfiguration().getSetParameterValue(param.getKey());
                    if (object == null || object.equals(Configuration.this.getParamAsObject(param.getKey()))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class SelectedProfileGenerator
    implements VariableGraph.Generator {
        private SelectedProfileGenerator() {
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            Profile profile = Configuration.this.fTarget.getDefaultProfile();
            for (Profile profile2 : Configuration.this.fTarget.getProfiles()) {
                if (profile2.getSelectedAttribute() == null || !profile2.getSelectedAttribute().evaluateBoolean(Configuration.this.evaluateXslInput(variableGraph, false))) continue;
                return profile2;
            }
            return profile;
        }
    }

    private class EnumOptionsGenerator
    implements VariableGraph.Generator {
        private final String fKey;
        private final Param fParam;
        private final EnumOptionExpression fExpression;
        private OptionListWithDefault fOptions;

        EnumOptionsGenerator(String string, Param param) {
            this.fKey = string;
            this.fParam = param;
            this.fExpression = param.getOptionExpression();
            this.fOptions = UNINITIALIZED_ENUM_OPTION_LIST;
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            Logger.log(this, "generateValue", "Generating options for %s", this.fParam.getKey());
            Configuration.this.addPendingMatlabDefault(this.fKey);
            Configuration.this.fData.notifyPendingAsyncLoad(string);
            if (Configuration.this.fLoaded && !Configuration.this.isAffectedByPendingMatlabDefaults(this.fKey)) {
                final Thread thread = Thread.currentThread();
                final Holder holder = new Holder();
                holder.set((Object)new ParameterRunnable<OptionListWithDefault>(){

                    public void run(final OptionListWithDefault optionListWithDefault) {
                        Logger.log(EnumOptionsGenerator.this, "generateValue", "Processing MATLAB result for %s options: %s", EnumOptionsGenerator.this.fParam.getKey(), optionListWithDefault);
                        Configuration.this.removePendingMatlabDefault(EnumOptionsGenerator.this.fKey);
                        EnumOptionsGenerator.this.fOptions = optionListWithDefault;
                        if (Thread.currentThread().equals(thread) && !Configuration.this.fInitializedOnMatlabThread) {
                            Logger.log(EnumOptionsGenerator.this, "generateValue", "Deferring processing for %s options to EDT", EnumOptionsGenerator.this.fParam.getKey());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((ParameterRunnable)holder.get()).run((Object)optionListWithDefault);
                                }
                            });
                            return;
                        }
                        Logger.log(EnumOptionsGenerator.this, "generateValue", "Applying %s for %s", EnumOptionsGenerator.this.fOptions, EnumOptionsGenerator.this.fParam.getKey());
                        try {
                            Configuration.this.fData.setValue(EnumOptionsGenerator.this.fKey, EnumOptionsGenerator.this.fOptions);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            Logger.log(EnumOptionsGenerator.this, "generateValue", "panic", new Object[0]);
                        }
                        String string = Configuration.this.getParamAsString(EnumOptionsGenerator.this.fParam.getKey());
                        if (string == null || string.length() == 0 || !optionListWithDefault.getOptions().containsKey(string) && !Configuration.this.fArbitraryEnumValueAllowed.contains(EnumOptionsGenerator.this.fParam.getKey())) {
                            Logger.log(EnumOptionsGenerator.this, "generateValue", "Resetting current value for %s to %s", EnumOptionsGenerator.this.fParam.getKey(), optionListWithDefault.getDefault());
                            Configuration.this.fData.setValue(EnumOptionsGenerator.this.fParam.getKey(), optionListWithDefault.getDefault());
                        } else {
                            Logger.log(EnumOptionsGenerator.this, "generateValue", "No need to reset current value for %s", EnumOptionsGenerator.this.fParam.getKey());
                        }
                    }
                });
                if (Matlab.isMatlabAvailable()) {
                    Logger.log(this, "generateValue", "Evaluating MATLAB options callback for %s", this.fParam.getKey());
                    this.fExpression.evaluate(Configuration.this.evaluateXslInput(variableGraph, false, Configuration.this.requiresTemplateInfo(this.fKey)), (ParameterRunnable<OptionListWithDefault>)((ParameterRunnable)holder.get()));
                } else {
                    String string2 = Configuration.this.getParamAsString(this.fParam.getKey());
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    if (string2 != null) {
                        linkedHashMap.put(string2, string2);
                    }
                    this.fOptions = new OptionListWithDefault(linkedHashMap, string2);
                }
            } else {
                Logger.log(this, "generateValue", "Not ready to run MATLAB callback for %s, so returning %s", this.fParam.getKey(), this.fOptions);
            }
            Logger.log(this, "generateValue", "Returning preliminary value %s for %s", this.fOptions, this.fParam.getKey());
            return this.fOptions;
        }
    }

    private class MatlabBasedDefaultGenerator
    implements VariableGraph.Generator {
        private final Param fParam;
        private final MatlabExpression fExpression;
        private Object fResult;

        MatlabBasedDefaultGenerator(Param param) {
            this.fParam = param;
            this.fExpression = param.getDefaultValueExpression();
            this.fResult = this.convertResult("");
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            Logger.log(this, "generateValue", "Generating default for %s", this.fParam.getKey());
            Configuration.this.fData.notifyPendingAsyncLoad(string);
            Configuration.this.addPendingMatlabDefault(this.fParam.getKey());
            if (Configuration.this.fLoaded && !Configuration.this.isAffectedByPendingMatlabDefaults(this.fParam.getKey())) {
                DefaultXpathEvaluator defaultXpathEvaluator = new DefaultXpathEvaluator("configuration");
                ParameterRunnable<Object> parameterRunnable = new ParameterRunnable<Object>(){

                    public void run(Object object) {
                        Configuration.this.removePendingMatlabDefault(MatlabBasedDefaultGenerator.this.fParam.getKey());
                        MatlabBasedDefaultGenerator.this.fResult = MatlabBasedDefaultGenerator.this.convertResult(object);
                        Configuration.this.fData.setDefaultValue(MatlabBasedDefaultGenerator.this.fParam.getKey(), MatlabBasedDefaultGenerator.this.fResult);
                    }
                };
                if (Matlab.isMatlabAvailable()) {
                    this.fExpression.evaluateAsObject(defaultXpathEvaluator.compileInput(Configuration.this.evaluateXslInput(variableGraph, false, Configuration.this.requiresTemplateInfo(this.fParam.getKey())).getText()), defaultXpathEvaluator, parameterRunnable);
                }
            } else {
                Logger.log(this, "generateValue", "Not ready to run callback for %s, so returning %s", this.fParam.getKey(), this.fResult);
            }
            return this.fResult;
        }

        private Object convertResult(Object object) {
            switch (this.fParam.getType()) {
                case STRING: {
                    return object.toString();
                }
                case FILE: {
                    return new File(object.toString());
                }
                case INT: {
                    if (object instanceof String) {
                        return new Integer((String)object);
                    }
                    if (object instanceof double[]) {
                        return (int)((double[])object)[0];
                    }
                    if (object instanceof int[]) {
                        return ((int[])object)[0];
                    }
                    throw new IllegalArgumentException("Unsupported type for int default value: " + object.getClass());
                }
                case BOOLEAN: {
                    if (object instanceof String) {
                        return object.equals("1") || Boolean.parseBoolean((String)object);
                    }
                    if (object instanceof double[]) {
                        return ((double[])object)[0] == 1.0;
                    }
                    if (!(object instanceof boolean[])) break;
                    return ((boolean[])object)[0];
                }
            }
            throw new IllegalArgumentException("MATLAB expression not supported as default value for " + (Object)((Object)this.fParam.getType()));
        }
    }

    private class ParamDefaultGenerator
    implements VariableGraph.Generator {
        private final Param fParam;

        ParamDefaultGenerator(Param param) {
            this.fParam = param;
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            if (this.fParam.getOptionExpression() != null) {
                if (!Configuration.this.fLoaded) {
                    return "";
                }
                return Configuration.this.getParamOptions(this.fParam.getKey()).getDefault();
            }
            DynamicTargetAttribute dynamicTargetAttribute = this.fParam.getDefaultValueAttribute();
            ParamType paramType = this.fParam.getType();
            if (dynamicTargetAttribute != null) {
                XmlReader xmlReader = null;
                try {
                    xmlReader = dynamicTargetAttribute.evaluate(Configuration.this.evaluateXslInput(variableGraph, Configuration.this.requiresTemplateInfo(this.fParam.getKey())));
                    if (paramType.isSimple()) {
                        try {
                            xmlReader = XmlApi.getInstance().read(XmlApi.getInstance().create("data").writeText((Object)StringUtils.normalizeSpace(xmlReader.readText())).getXML());
                        }
                        catch (IOException iOException) {
                            throw new IllegalStateException(iOException);
                        }
                    }
                    return paramType.deserialize(Configuration.this.fProject, this.fParam, xmlReader);
                }
                catch (InvalidParameterValueException invalidParameterValueException) {
                    throw new IllegalStateException("The default parameter XSL for " + this.fParam.getKey() + " generated the unacceptable result: " + xmlReader.getXML());
                }
            }
            return paramType.getDefaultValue(this.fParam);
        }
    }

    private class ParamStringAttributeGenerator
    implements VariableGraph.Generator {
        private final DynamicTargetAttribute fAttribute;
        private final String fKey;

        ParamStringAttributeGenerator(String string, DynamicTargetAttribute dynamicTargetAttribute) {
            this.fAttribute = dynamicTargetAttribute;
            this.fKey = string;
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            return this.fAttribute == null ? null : this.fAttribute.evaluateString(Configuration.this.evaluateXslInput(variableGraph, Configuration.this.requiresTemplateInfo(this.fKey)));
        }
    }

    private class ParamBooleanAttributeGenerator
    implements VariableGraph.Generator {
        private final DynamicTargetAttribute fAttribute;
        private final String fKey;
        private final Set<String> fProfiles;

        ParamBooleanAttributeGenerator(String string, DynamicTargetAttribute dynamicTargetAttribute, Set<String> set) {
            this.fAttribute = dynamicTargetAttribute;
            this.fKey = string;
            this.fProfiles = new HashSet<String>(set);
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            Profile profile;
            if (!this.fProfiles.isEmpty() && !this.fProfiles.contains((profile = (Profile)variableGraph.getValue(Configuration.SELECTED_PROFILE_PROPERTY)).getKey())) {
                return false;
            }
            return this.fAttribute == null || this.fAttribute.evaluateBoolean(Configuration.this.evaluateXslInput(variableGraph, Configuration.this.requiresTemplateInfo(this.fKey)));
        }
    }

    private class SpecialFileGenerator
    implements VariableGraph.Generator {
        private final SpecialFile fFile;

        SpecialFileGenerator(SpecialFile specialFile) {
            this.fFile = specialFile;
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            return this.fFile.getLocation(Configuration.this.readXslInput(variableGraph, Configuration.this.requiresTemplateInfo(this.fFile.getKey())));
        }
    }

    private class DynamicFileSubsetGenerator
    implements VariableGraph.Generator {
        private final DynamicFileSubset fSubset;
        private final String fKey;

        DynamicFileSubsetGenerator(String string, DynamicFileSubset dynamicFileSubset) {
            this.fSubset = dynamicFileSubset;
            this.fKey = string;
        }

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            return this.fSubset.evaluate(Configuration.this.readXslInput(variableGraph, Configuration.this.requiresTemplateInfo(this.fKey)));
        }
    }
}

