/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.jmi.Matlab;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class JavaStringGenerator {
    private JavaStringGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateForAllTargets(File file) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(JavaStringGenerator.generateForTargets(PluginManager.getTargets(), JavaStringGenerator.getPackageName(file), JavaStringGenerator.getClassName(file), "// To regenerate this file, run this command in the MATLAB Command Window:\r\n//" + JavaStringGenerator.class.getName() + ".generateForAllTargets(java.io.File([matlabroot '" + JavaStringGenerator.getRelativeToMatlabRoot(file.getAbsolutePath()) + "']));"));
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static String generateForTargets(List<Target> list, String string, String string2, String string3) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("/**");
        printWriter.println(" * Copyright 2009 The MathWorks, Inc.");
        printWriter.println(" * $Revision: 1.1.6.1 $");
        printWriter.println(" */");
        printWriter.println();
        printWriter.println("package " + string + ";");
        printWriter.println();
        if (string3 != null) {
            printWriter.println(string3);
        }
        printWriter.println("public final class " + string2);
        printWriter.println("{");
        HashSet<String> hashSet = new HashSet<String>();
        for (Target target : list) {
            JavaStringGenerator.writeConstant(printWriter, target.getKey(), target.getName(), hashSet);
            for (ParamSet paramSet : target.getParamSets()) {
                for (Param param : paramSet.getParams()) {
                    JavaStringGenerator.writeConstant(printWriter, param.getKey(), param.getDescription(), hashSet);
                }
            }
            for (FileSetDefinition fileSetDefinition : target.getFileSets()) {
                JavaStringGenerator.writeConstant(printWriter, fileSetDefinition.getKey(), fileSetDefinition.getDescription(), hashSet);
                if (!fileSetDefinition.getRootLevelEntities().isEmpty()) {
                    JavaStringGenerator.writeEntityConstantsRecursively(printWriter, fileSetDefinition.getRootLevelEntities(), hashSet);
                }
                for (SpecialFile specialFile : fileSetDefinition.getSpecialFiles()) {
                    JavaStringGenerator.writeConstant(printWriter, specialFile.getKey(), specialFile.getDescription(), hashSet);
                }
            }
        }
        printWriter.println("}");
        printWriter.close();
        return stringWriter.toString();
    }

    private static void writeEntityConstantsRecursively(PrintWriter printWriter, List<EntityDefinition> list, Set<String> set) {
        for (EntityDefinition entityDefinition : list) {
            JavaStringGenerator.writeConstant(printWriter, entityDefinition.getKey(), entityDefinition.getName(), set);
            JavaStringGenerator.writeEntityConstantsRecursively(printWriter, entityDefinition.getChildren(), set);
        }
    }

    private static void writeConstant(PrintWriter printWriter, String string, String string2, Set<String> set) {
        if (set.add(string)) {
            String string3 = JavaStringGenerator.getConstantName(string);
            String string4 = JavaStringGenerator.formatDescriptionAsComment(string2);
            if (string4 != null) {
                printWriter.println(string4);
            }
            printWriter.println("\tpublic static final String " + string3 + " = \"" + string + "\";");
            printWriter.println();
        }
    }

    private static String getPackageName(File file) {
        Stack<String> stack = new Stack<String>();
        while (file != null) {
            if (file.getName() != null && !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".java")) {
                stack.push(file.getName());
            }
            if (file.getName().equals("com")) break;
            file = file.getParentFile();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stack.isEmpty() || !((String)stack.peek()).equals("com")) {
            throw new IllegalArgumentException("The output file is not in a Java package location: " + file);
        }
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private static String getClassName(File file) {
        return file.getName().substring(0, file.getName().length() - 5);
    }

    private static String getConstantName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(stringTokenizer.nextToken().toUpperCase(Locale.ENGLISH));
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private static String formatDescriptionAsComment(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\n\t");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t/** ");
        int n = 7;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() + n + 1 > 120) {
                n = 7;
                stringBuilder.append("\r\n\t *  ");
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append(' ');
            n += 1 + string2.length();
        }
        stringBuilder.append("\r\n\t */");
        return stringBuilder.toString();
    }

    private static String getRelativeToMatlabRoot(String string) {
        String string2 = string.substring(Matlab.matlabRoot().length());
        if (!string2.startsWith("\\") && !string2.startsWith("/")) {
            string2 = File.separator + string2;
        }
        return string2;
    }
}

