/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJSpinner;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.NumericRule;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntWidget
implements ParamWidget<Integer> {
    private final MJSpinner fComponent;
    private final List<ChangeListener> fListeners = new ArrayList<ChangeListener>();

    public IntWidget(Param param, Project project, final int n, final int n2) {
        this.fComponent = new MJSpinner(){

            protected JComponent createEditor(SpinnerModel spinnerModel) {
                JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)((Object)this));
                new BasicTextValidator(numberEditor.getTextField(), new NumericRule(n, n2, numberEditor.getFormat()));
                return numberEditor;
            }
        };
        this.fComponent.setName(param.getKey() + ".spinner");
        DetailedToolTip.install((Component)this.fComponent, project.getConfiguration(), param);
        this.fComponent.setModel((SpinnerModel)new SpinnerNumberModel(n, n, n2, ParamUtils.getIntParamIncrement(param)));
        this.fComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                for (ChangeListener changeListener : IntWidget.this.fListeners) {
                    changeListener.stateChanged(new ChangeEvent(IntWidget.this));
                }
            }
        });
    }

    public void setData(Integer n) {
        this.fComponent.setValue((Object)n);
    }

    public Integer getData() {
        return (Integer)this.fComponent.getValue();
    }

    public void setEnabled(boolean bl) {
        this.fComponent.setEnabled(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListeners.remove(changeListener);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        DetailedToolTip.uninstall((Component)this.fComponent);
    }

    public boolean isExternalLabelRequired() {
        return true;
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }
}

