/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.NumericRule;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.TextFieldUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public abstract class AbstractSimpleCellEditor<T>
implements PropertyTableCellEditor<T> {
    private final MJTextField fComponent = new MJTextField();
    private final PropertyTable<T> fTable;
    private final boolean fIsInteger;
    private Object fOriginalValue;

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable) {
        this(propertyTable, false, null);
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, int n, int n2) {
        this(propertyTable, true, new NumericRule(n, n2, new DecimalFormat()));
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, ValidationRule validationRule) {
        this(propertyTable, false, validationRule);
    }

    public AbstractSimpleCellEditor(PropertyTable<T> propertyTable, Class<?> clazz) {
        this(propertyTable, clazz == Integer.class || clazz == Integer.TYPE, null);
    }

    private AbstractSimpleCellEditor(PropertyTable<T> propertyTable, boolean bl, ValidationRule validationRule) {
        this.fTable = propertyTable;
        this.fIsInteger = bl;
        this.fComponent.setFont(this.fTable.getFont());
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AbstractSimpleCellEditor.this.fTable.stopEditing(false);
                }
            });
        }
        TextFieldUtils.installCommitAndCancelKeystrokes(propertyTable, (JTextField)this.fComponent);
        if (validationRule != null) {
            new BasicTextValidator((JTextComponent)this.fComponent, validationRule);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void activate() {
    }

    public void selectAll() {
        this.fComponent.selectAll();
    }

    protected void setData(Object object, String string) {
        this.fOriginalValue = object;
        this.fComponent.setText(string);
    }

    protected Object getData() {
        if (!this.fIsInteger) {
            return this.fComponent.getText();
        }
        try {
            return new Integer(this.fComponent.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.fOriginalValue;
        }
    }
}

