/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.table;

import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableColumn;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class PropertyTableColumnModel<T>
implements TableColumnModel {
    private final PropertyTable<T> fTable;
    private final List<PropertyTableColumn<T>> fColumns;
    private final int fGridLineWidth;
    private final int[] fDividerLocations;
    private final Vector<TableColumn> fTableColumns;
    private final JComponent fTableComponent;
    private final ComponentListener fComponentListener;
    private JTableHeader fHeader;
    private boolean fSuppressWidthListener;
    private static final int MIN_COLUMN_WIDTH = 75;

    PropertyTableColumnModel(PropertyTable<T> propertyTable, List<PropertyTableColumn<T>> list, JComponent jComponent, int n) {
        this.fTable = propertyTable;
        this.fColumns = new ArrayList<PropertyTableColumn<T>>(list);
        this.fGridLineWidth = n;
        this.fDividerLocations = new int[this.fColumns.size() - 1];
        this.fTableColumns = new Vector();
        for (int i = 0; i < this.fColumns.size(); ++i) {
            final TableColumn tableColumn = new TableColumn(i);
            tableColumn.setMinWidth(75);
            tableColumn.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                    if (!PropertyTableColumnModel.this.fSuppressWidthListener && propertyChangeEvent.getPropertyName().equals("width")) {
                        PropertyTableColumnModel.this.withoutWidthReaction(new Runnable(){

                            @Override
                            public void run() {
                                int n = (Integer)propertyChangeEvent.getNewValue() - (Integer)propertyChangeEvent.getOldValue();
                                if (tableColumn.getModelIndex() < PropertyTableColumnModel.this.fColumns.size() - 1) {
                                    TableColumn tableColumn = (TableColumn)PropertyTableColumnModel.this.fTableColumns.get(tableColumn.getModelIndex() + 1);
                                    if (tableColumn.getWidth() - n < tableColumn.getMinWidth()) {
                                        tableColumn.setWidth(tableColumn.getWidth() - n);
                                    } else {
                                        tableColumn.setWidth(tableColumn.getWidth() - n);
                                        if (tableColumn.getModelIndex() < PropertyTableColumnModel.this.fDividerLocations.length) {
                                            int[] nArray = PropertyTableColumnModel.this.fDividerLocations;
                                            int n2 = tableColumn.getModelIndex();
                                            nArray[n2] = nArray[n2] + n;
                                        }
                                    }
                                }
                            }
                        });
                        PropertyTableColumnModel.this.repaintComponents();
                    }
                }
            });
            tableColumn.setHeaderValue(this.fColumns.get(i).getName());
            this.fTableColumns.add(tableColumn);
        }
        this.fTableComponent = jComponent;
        this.fComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PropertyTableColumnModel.this.withoutWidthReaction(new Runnable(){

                    @Override
                    public void run() {
                        for (TableColumn tableColumn : PropertyTableColumnModel.this.fTableColumns) {
                            tableColumn.setMaxWidth(PropertyTableColumnModel.this.fTableComponent.getWidth() - 75 * (PropertyTableColumnModel.this.fColumns.size() - 1));
                        }
                        TableColumn tableColumn = (TableColumn)PropertyTableColumnModel.this.fTableColumns.get(PropertyTableColumnModel.this.fTableColumns.size() - 1);
                        tableColumn.setWidth(PropertyTableColumnModel.this.fTableComponent.getWidth() - PropertyTableColumnModel.this.fDividerLocations[PropertyTableColumnModel.this.fDividerLocations.length - 1] - 1 - PropertyTableColumnModel.this.fGridLineWidth);
                    }
                });
                PropertyTableColumnModel.this.repaintComponents();
            }
        };
        this.fTableComponent.addComponentListener(this.fComponentListener);
    }

    public void dispose() {
        this.fTableComponent.removeComponentListener(this.fComponentListener);
    }

    public void setHeader(JTableHeader jTableHeader) {
        this.fHeader = jTableHeader;
    }

    public void setDividerLocation(final int n, final int n2) {
        this.withoutWidthReaction(new Runnable(){

            @Override
            public void run() {
                ((PropertyTableColumnModel)PropertyTableColumnModel.this).fDividerLocations[n] = n2;
                ((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n)).setWidth(n2 + PropertyTableColumnModel.this.fGridLineWidth + 1 - (n == 0 ? 0 : PropertyTableColumnModel.this.fDividerLocations[n - 1]));
                ((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n)).setPreferredWidth(((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n)).getWidth());
                ((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n + 1)).setWidth((n < PropertyTableColumnModel.this.fDividerLocations.length - 1 ? PropertyTableColumnModel.this.fDividerLocations[n + 1] : PropertyTableColumnModel.this.fTableComponent.getWidth()) + 1 + PropertyTableColumnModel.this.fGridLineWidth - PropertyTableColumnModel.this.fDividerLocations[n]);
                ((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n + 1)).setPreferredWidth(((TableColumn)PropertyTableColumnModel.this.fTableColumns.get(n + 1)).getWidth());
                PropertyTableColumnModel.this.fSuppressWidthListener = false;
            }
        });
        this.repaintComponents();
    }

    public int getDividerLocation(int n) {
        return this.fDividerLocations[n];
    }

    private void repaintComponents() {
        if (this.fHeader != null) {
            this.fHeader.revalidate();
            this.fHeader.repaint();
        }
        this.fTable.updateCellEditorBounds();
        this.fTableComponent.revalidate();
        this.fTableComponent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withoutWidthReaction(Runnable runnable) {
        boolean bl = this.fSuppressWidthListener;
        this.fSuppressWidthListener = true;
        try {
            runnable.run();
        }
        finally {
            if (!bl) {
                this.fSuppressWidthListener = false;
            }
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveColumn(int n, int n2) {
    }

    @Override
    public void setColumnMargin(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumnCount() {
        return this.fTableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.fTableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TableColumn getColumn(int n) {
        return this.fTableColumns.get(n);
    }

    @Override
    public int getColumnMargin() {
        return 0;
    }

    @Override
    public int getColumnIndexAtX(int n) {
        for (int i = 0; i < this.fDividerLocations.length; ++i) {
            if (n >= this.fDividerLocations[i]) continue;
            return i;
        }
        return this.fDividerLocations.length;
    }

    @Override
    public int getTotalColumnWidth() {
        return this.fTableComponent.getWidth();
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return false;
    }

    @Override
    public int[] getSelectedColumns() {
        return null;
    }

    @Override
    public int getSelectedColumnCount() {
        return 0;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
    }
}

