/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.ComponentManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;

public class ComponentRegistry
implements ScrService {
    private Map m_componentsByName = new HashMap();
    private Map m_componentsById = new HashMap();
    private long m_componentCounter = -1L;
    private ServiceRegistration m_registration;
    static /* synthetic */ Class class$org$apache$felix$scr$ScrService;

    ComponentRegistry(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Management Agent");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService((class$org$apache$felix$scr$ScrService == null ? (class$org$apache$felix$scr$ScrService = ComponentRegistry.class$("org.apache.felix.scr.ScrService")) : class$org$apache$felix$scr$ScrService).getName(), (Object)this, props);
    }

    void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    public Component[] getComponents() {
        if (this.m_componentsById.isEmpty()) {
            return null;
        }
        return this.m_componentsById.values().toArray(new Component[this.m_componentsById.size()]);
    }

    public Component[] getComponents(Bundle bundle) {
        Component[] all = this.getComponents();
        if (all == null || all.length == 0) {
            return null;
        }
        long bundleId = bundle.getBundleId();
        ArrayList<Component> perBundle = new ArrayList<Component>();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].getBundle().getBundleId() != bundleId) continue;
            perBundle.add(all[i]);
        }
        if (perBundle.isEmpty()) {
            return null;
        }
        return perBundle.toArray(new Component[perBundle.size()]);
    }

    public Component getComponent(long componentId) {
        return (Component)this.m_componentsById.get(new Long(componentId));
    }

    long createComponentId() {
        ++this.m_componentCounter;
        return this.m_componentCounter;
    }

    void checkComponentName(String name) {
        if (this.m_componentsByName.containsKey(name)) {
            String message = "The component name '" + name + "' has already been registered";
            Object co = this.m_componentsByName.get(name);
            if (co instanceof ComponentManager) {
                ComponentManager c = (ComponentManager)co;
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(c.getBundle().getBundleId());
                if (c.getBundle().getSymbolicName() != null) {
                    buf.append(" (").append(c.getBundle().getSymbolicName()).append(")");
                }
                buf.append(" as Component ").append(c.getId());
                buf.append(" of Class ").append(c.getClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        this.m_componentsByName.put(name, name);
    }

    void registerComponent(String name, ComponentManager component) {
        if (!name.equals(this.m_componentsByName.get(name))) {
            throw new ComponentException("The component name '" + name + "' has already been registered.");
        }
        this.m_componentsByName.put(name, component);
        this.m_componentsById.put(new Long(component.getId()), component);
    }

    ComponentManager getComponent(String name) {
        Object entry = this.m_componentsByName.get(name);
        if (entry instanceof ComponentManager) {
            return (ComponentManager)entry;
        }
        return null;
    }

    void unregisterComponent(String name) {
        Object entry = this.m_componentsByName.remove(name);
        if (entry instanceof ComponentManager) {
            Long id = new Long(((ComponentManager)entry).getId());
            this.m_componentsById.remove(id);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

