/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoableEditFromRunnables;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import javax.swing.event.UndoableEditEvent;

public class DoerCompletionObserver
implements CompletionObserver {
    private InvertableRunnable fDoer;
    private WorkspaceUndoManager fUndoManager;
    private boolean fShowMessages = false;
    private String fPreferedMessage = null;

    public DoerCompletionObserver(InvertableRunnable invertableRunnable, WorkspaceUndoManager workspaceUndoManager) {
        this(invertableRunnable, workspaceUndoManager, false, null);
    }

    public DoerCompletionObserver(InvertableRunnable invertableRunnable, WorkspaceUndoManager workspaceUndoManager, boolean bl) {
        this(invertableRunnable, workspaceUndoManager, bl, null);
    }

    public DoerCompletionObserver(InvertableRunnable invertableRunnable, WorkspaceUndoManager workspaceUndoManager, String string) {
        this(invertableRunnable, workspaceUndoManager, string != null, string);
    }

    public DoerCompletionObserver(InvertableRunnable invertableRunnable, WorkspaceUndoManager workspaceUndoManager, boolean bl, String string) {
        this.fDoer = invertableRunnable;
        this.fUndoManager = workspaceUndoManager;
        this.fShowMessages = bl;
        this.fPreferedMessage = string;
    }

    public void completed(int n, Object object) {
        if (this.fUndoManager != null) {
            if (Matlab.getExecutionStatus((int)n) == 0) {
                UndoableEditFromRunnables undoableEditFromRunnables = new UndoableEditFromRunnables(this.fDoer.getInverse());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEditFromRunnables);
                this.fUndoManager.undoableEditHappened(undoableEditEvent);
            } else {
                this.fUndoManager.doNotReceiveUndoableEdits();
                if (this.fShowMessages) {
                    String string = ArrayUtils.getResource("status.Error");
                    if (null != this.fPreferedMessage) {
                        string = this.fPreferedMessage;
                    } else if (object != null && (object instanceof MatlabException || object instanceof String)) {
                        string = object.toString();
                    }
                    ArrayDialog.showErrorDialog(string);
                }
            }
        }
    }
}

