/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.brushing;

import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class BrushingActionFactory {
    private static Hashtable<String, Action[]> sVarActionTable = new Hashtable();
    private static Hashtable<String, Boolean> sVarBrushStatusTable = new Hashtable();

    private BrushingActionFactory() {
    }

    public static Action[] getBrushingActions(String string) {
        if (sVarActionTable.containsKey(string)) {
            return sVarActionTable.get(string);
        }
        Action[] actionArray = new Action[]{new ReplaceAction(string), new RemoveAction(string, false), new RemoveAction(string, true), new NewVarAction(string), new PasteAction(string), new CopyAction(string), new ClearAction(string)};
        boolean bl = BrushingActionFactory.isVarBrushed(string);
        for (Action action : actionArray) {
            action.setEnabled(bl);
        }
        sVarActionTable.put(string, actionArray);
        return actionArray;
    }

    public static void removeBrushingActions(String string) {
        if (sVarActionTable.containsKey(string)) {
            sVarActionTable.remove(string);
        }
        if (sVarBrushStatusTable.containsKey(string)) {
            sVarBrushStatusTable.remove(string);
        }
    }

    public static void addBrushingActions(MJMenu mJMenu, String string) {
        Action[] actionArray = BrushingActionFactory.getBrushingActions(string);
        mJMenu.add((Component)new JPopupMenu.Separator());
        mJMenu.add(actionArray[0]);
        mJMenu.add(actionArray[1]);
        mJMenu.add(actionArray[2]);
        mJMenu.add((Component)new JPopupMenu.Separator());
        mJMenu.add(actionArray[3]);
        mJMenu.add((Component)new JPopupMenu.Separator());
        mJMenu.add(actionArray[4]);
        mJMenu.add(actionArray[5]);
        mJMenu.add((Component)new JPopupMenu.Separator());
        mJMenu.add(actionArray[6]);
    }

    public static void setVarBrushedState(String string, final boolean bl) {
        if (!sVarBrushStatusTable.containsKey(string)) {
            sVarBrushStatusTable.put(string, bl);
        }
        final Action[] actionArray = BrushingActionFactory.getBrushingActions(string);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Action action : actionArray) {
                    action.setEnabled(bl);
                }
            }
        });
    }

    public static void setAllVarBrushedState(String[] stringArray, boolean[] blArray) {
        final ArrayList<Action[]> arrayList = new ArrayList<Action[]>();
        final ArrayList<Action[]> arrayList2 = new ArrayList<Action[]>();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!blArray[i]) continue;
                treeSet.add(stringArray[i]);
            }
        }
        String[] stringArray2 = new String[sVarBrushStatusTable.size()];
        int n = 0;
        Enumeration<String> enumeration = sVarBrushStatusTable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray2[n] = enumeration.nextElement();
            ++n;
        }
        for (String string : stringArray2) {
            if (treeSet.contains(string)) {
                sVarBrushStatusTable.put(string, true);
                arrayList2.add(sVarActionTable.get(string));
                continue;
            }
            sVarBrushStatusTable.put(string, false);
            arrayList.add(sVarActionTable.get(string));
        }
        for (String string : treeSet) {
            if (sVarBrushStatusTable.containsKey(string)) continue;
            sVarBrushStatusTable.put(string, true);
            arrayList2.add(BrushingActionFactory.getBrushingActions(string));
        }
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Action[] actionArray;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    for (Action action : actionArray = (Action[])iterator.next()) {
                        action.setEnabled(true);
                    }
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    for (Action action : actionArray = (Action[])iterator.next()) {
                        action.setEnabled(false);
                    }
                }
            }
        });
    }

    public static boolean isVarBrushed(String string) {
        return sVarBrushStatusTable.containsKey(string) && sVarBrushStatusTable.get(string) != false;
    }

    private static class ClearAction
    extends MatlabAction {
        ClearAction(String string) {
            super(ArrayUtils.getResource("brushaction.clear"), string);
            this.fVarName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.clearLinked([],{'" + this.fVarName + "'})");
        }
    }

    private static class CopyAction
    extends MatlabAction {
        CopyAction(String string) {
            super(ArrayUtils.getResource("brushaction.copy"), string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.copyLinked([],{'" + this.fVarName + "'},{" + this.fVarName + "})");
        }
    }

    private static class PasteAction
    extends MatlabAction {
        PasteAction(String string) {
            super(ArrayUtils.getResource("brushaction.paste"), string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.pasteLinked([],{'" + this.fVarName + "'},{" + this.fVarName + "})");
        }
    }

    private static class ReplaceAction
    extends MatlabAction {
        ReplaceAction(String string) {
            super(ArrayUtils.getResource("brushaction.replace"), string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.dataEditCallback({'" + this.fVarName + "'},'action','replace','workspaceevent',true)");
        }
    }

    private static class NewVarAction
    extends MatlabAction {
        NewVarAction(String string) {
            super(ArrayUtils.getResource("brushaction.create"), string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.newvarFromVarEditor('" + this.fVarName + "')");
        }
    }

    private static class RemoveAction
    extends MatlabAction {
        private boolean fKeepFlag = false;

        RemoveAction(String string, boolean bl) {
            super(bl ? ArrayUtils.getResource("brushaction.removeunbrush") : ArrayUtils.getResource("brushaction.remove"), string);
            this.fKeepFlag = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fKeepFlag) {
                WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.dataEditCallback({'" + this.fVarName + "'},'action','remove','arguments',{true},'workspaceevent',true)");
            } else {
                WorkspaceMCRProvider.getMCRForUserActions().evalConsoleOutput("datamanager.dataEditCallback({'" + this.fVarName + "'},'action','remove','arguments',{false},'workspaceevent',true)");
            }
        }
    }

    private static abstract class MatlabAction
    extends MJAbstractAction {
        protected String fVarName;

        MatlabAction(String string, String string2) {
            super(string);
            this.setComponentName(string);
            this.fVarName = string2;
        }
    }
}

