/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipInput;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public final class ApacheZipInput
implements ZipInput {
    private final FileSystemEntry fZipFile;
    private FileSystemEntry fRealZipFile;
    private ZipFile fApacheZipFile;
    private volatile int fInputStreamCount;
    private volatile Long fLastInputStreamThreadId;

    public ApacheZipInput(FileSystemEntry fileSystemEntry) {
        this.fZipFile = fileSystemEntry;
    }

    @Override
    public void getEntries(final ZipFileSystem zipFileSystem, final Predicate<FileSystemEntry> predicate) throws IOException {
        this.withZipFile(new ThrowableClosure<Void, ZipFile, IOException>(){

            public Void run(ZipFile zipFile) throws IOException {
                Enumeration enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    if (predicate.accept((Object)ApacheZipInput.wrapEntry(zipFileSystem, zipEntry))) continue;
                    return null;
                }
                return null;
            }
        });
    }

    @Override
    public InputStream getInputStream(final FileLocation fileLocation) throws IOException {
        return this.withZipFile(new ThrowableClosure<InputStream, ZipFile, IOException>(){

            public InputStream run(ZipFile zipFile) throws IOException {
                ZipEntry zipEntry = zipFile.getEntry(fileLocation.toString());
                if (zipEntry == null) {
                    zipEntry = zipFile.getEntry(fileLocation.toString().replace(File.separatorChar, '/'));
                }
                if (zipEntry == null) {
                    zipEntry = zipFile.getEntry(fileLocation.toString().replace(File.separatorChar, '\\'));
                }
                if (zipEntry == null && fileLocation.toString().startsWith("/")) {
                    zipEntry = zipFile.getEntry(fileLocation.toString().substring(1));
                }
                if (zipEntry == null) {
                    throw new IOException("Location does not exist: " + fileLocation);
                }
                return new InputStreamFilter(zipFile.getInputStream(zipEntry));
            }
        });
    }

    @Override
    public boolean isLocked() {
        return this.fInputStreamCount > 0 && this.fLastInputStreamThreadId != null && Thread.currentThread().getId() != this.fLastInputStreamThreadId.longValue();
    }

    private <T> T withZipFile(ThrowableClosure<T, ZipFile, IOException> throwableClosure) throws IOException {
        if (this.fRealZipFile == null) {
            this.fRealZipFile = MLFileSystemUtils.getMatlabAccessibleEntry(this.fZipFile);
        }
        if (this.fApacheZipFile == null) {
            this.fApacheZipFile = new ZipFile(this.fRealZipFile.getLocation().toFile());
        }
        return (T)throwableClosure.run((Object)this.fApacheZipFile);
    }

    @Override
    public void close() throws IOException {
        if (this.fApacheZipFile != null) {
            this.fApacheZipFile.close();
        }
        if (this.fRealZipFile != null) {
            MLFileSystemUtils.releaseMatlabAccessibleEntry(this.fRealZipFile);
        }
    }

    private static FileSystemEntry wrapEntry(ZipFileSystem zipFileSystem, ZipEntry zipEntry) {
        return new FileSystemEntry((FileSystem)zipFileSystem, new FileLocation(zipEntry.getName()), false, zipEntry.isDirectory(), zipEntry.getSize(), zipEntry.getTime(), 0L);
    }

    private class InputStreamFilter
    extends FilterInputStream {
        InputStreamFilter(InputStream inputStream) {
            super(inputStream);
            ApacheZipInput.this.fInputStreamCount++;
            ApacheZipInput.this.fLastInputStreamThreadId = Thread.currentThread().getId();
        }

        @Override
        public void close() throws IOException {
            super.close();
            ApacheZipInput.this.fInputStreamCount--;
        }
    }
}

