/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileReplaceOrDeleteDialog;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.services.Prefs;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;

public final class UiFileTransfer
implements Runnable {
    private final Component fParent;
    private final AsyncReceiver<FileLocation> fReceiver;
    private final List<FileSystemEntry> fSourceFiles;
    private final FileSystem fDestinationSystem;
    private final FileLocation fDestinationParent;
    private final List<FileLocation> fDestinationFiles;
    private final List<Boolean> fConfirmRequired;
    private final UiFileTransferType fTransferType;
    private int fConfirmRequiredCount;

    public UiFileTransfer(Component component, UiFileTransferType uiFileTransferType, List<FileSystemEntry> list, AsyncReceiver<FileLocation> asyncReceiver) {
        this(component, uiFileTransferType, null, null, list, asyncReceiver);
    }

    public UiFileTransfer(Component component, UiFileTransferType uiFileTransferType, FileSystem fileSystem, FileLocation fileLocation, List<FileSystemEntry> list, AsyncReceiver<FileLocation> asyncReceiver) {
        this(component, uiFileTransferType, fileSystem, fileLocation, null, list, asyncReceiver);
    }

    public UiFileTransfer(Component component, UiFileTransferType uiFileTransferType, FileSystem fileSystem, FileLocation fileLocation, FileLocation fileLocation2, List<FileSystemEntry> list, AsyncReceiver<FileLocation> asyncReceiver) {
        list = UiFileTransfer.filterDescendents(list);
        if (PlatformInfo.isUnix() && !PlatformInfo.isMacintosh() && uiFileTransferType.equals((Object)UiFileTransferType.RECYCLE_OR_TRASH) && !Prefs.getBooleanPref((String)"GeneralDeleteFunctionRecycles", (boolean)false)) {
            uiFileTransferType = UiFileTransferType.DELETE;
        }
        this.fDestinationParent = fileLocation;
        this.fDestinationSystem = fileSystem;
        this.fParent = component;
        this.fReceiver = asyncReceiver;
        this.fTransferType = uiFileTransferType;
        this.fSourceFiles = new ArrayList<FileSystemEntry>(list);
        this.fDestinationFiles = new Vector<FileLocation>(this.fSourceFiles.size());
        this.fConfirmRequired = new Vector<Boolean>(this.fSourceFiles.size());
        Iterator<FileSystemEntry> iterator = this.fSourceFiles.iterator();
        while (iterator.hasNext()) {
            Object object;
            FileSystemEntry fileSystemEntry = iterator.next();
            FileLocation fileLocation3 = null;
            if (fileLocation != null) {
                fileLocation3 = new FileLocation(fileLocation, fileSystemEntry.getName());
                if (fileLocation2 != null && fileSystemEntry.getLocation().hasPrefix(fileLocation2)) {
                    object = fileSystemEntry.getLocation().stripPrefix(fileLocation2).toString();
                    fileLocation3 = new FileLocation(fileLocation, (String)object);
                }
            }
            if (RealFileSystem.isInRecycleBin(fileSystemEntry.getLocation())) {
                object = RealFileSystem.getOriginalLocationOfRecycledFile(fileSystemEntry.getLocation());
                fileLocation3 = new FileLocation(fileLocation, object.getName());
            }
            assert (this.fTransferType.isDeleteOrRecycle() || this.fDestinationSystem != null);
            assert (!this.fTransferType.isCopy() && this.fTransferType != UiFileTransferType.MOVE || fileLocation != null);
            if (this.isMoveToCurrentLocation(fileSystemEntry, fileLocation3)) {
                iterator.remove();
                continue;
            }
            if (this.fTransferType.isDeleteOrRecycle()) {
                if (fileLocation3 != null) {
                    this.fDestinationFiles.add(fileLocation3);
                }
                if (PlatformInfo.isMacintosh() && this.fTransferType == UiFileTransferType.RECYCLE_OR_TRASH) continue;
                this.fConfirmRequired.add(true);
                ++this.fConfirmRequiredCount;
                continue;
            }
            if (this.isCopyToCurrentLocation(fileSystemEntry, fileLocation3)) {
                fileLocation3 = this.determineCopyDestination(fileSystemEntry);
                this.fDestinationFiles.add(fileLocation3);
                this.fConfirmRequired.add(false);
                continue;
            }
            if (this.isOverwrite(fileLocation3)) {
                this.fDestinationFiles.add(fileLocation3);
                this.fConfirmRequired.add(true);
                ++this.fConfirmRequiredCount;
                continue;
            }
            this.fDestinationFiles.add(fileLocation3);
            this.fConfirmRequired.add(false);
        }
    }

    private boolean isMoveToCurrentLocation(FileSystemEntry fileSystemEntry, FileLocation fileLocation) {
        return this.fTransferType == UiFileTransferType.MOVE && fileSystemEntry.getLocation().equals((Object)fileLocation) && fileSystemEntry.getSystem().equals(this.fDestinationSystem);
    }

    private boolean isCopyToCurrentLocation(FileSystemEntry fileSystemEntry, FileLocation fileLocation) {
        return this.fTransferType.isCopy() && fileLocation != null && fileSystemEntry.getSystem().equals(this.fDestinationSystem) && fileSystemEntry.getLocation().getParent().equals((Object)this.fDestinationParent) && this.fDestinationSystem.exists(fileLocation);
    }

    private boolean isOverwrite(FileLocation fileLocation) {
        return !this.fTransferType.isDeleteOrRecycle() && fileLocation != null && this.fDestinationSystem.exists(fileLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.fTransferType.isDeleteOrRecycle()) {
            try {
                FileSystemUtils.delete(this.fParent, this.fSourceFiles, this.fTransferType == UiFileTransferType.RECYCLE_OR_TRASH, (Predicate<FileSystemEntry>)new GenericDeleteConfirmationPredicate(), this.fReceiver);
            }
            catch (IOException iOException) {
                this.fTransferType.showError(this.fParent, this.fSourceFiles.get(0));
            }
        } else {
            try {
                final ArrayList arrayList = new ArrayList();
                FileSystemUtils.withTransaction(this.fDestinationSystem, new TransactionLogic(){

                    @Override
                    public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                        fileSystemTransaction.createDirectory(UiFileTransfer.this.fDestinationParent);
                        boolean bl = UiFileTransfer.this.fDestinationSystem.getEntry(UiFileTransfer.this.fDestinationParent).isReal();
                        ConfirmationContext confirmationContext = new ConfirmationContext(UiFileTransfer.this.fSourceFiles.size(), UiFileTransfer.this.fConfirmRequiredCount);
                        for (int i = 0; i < UiFileTransfer.this.fSourceFiles.size(); ++i) {
                            FileSystemEntry fileSystemEntry = (FileSystemEntry)UiFileTransfer.this.fSourceFiles.get(i);
                            FileLocation fileLocation = UiFileTransfer.this.fDestinationFiles.isEmpty() ? null : (FileLocation)UiFileTransfer.this.fDestinationFiles.get(i);
                            boolean bl2 = !UiFileTransfer.this.fConfirmRequired.isEmpty() && (Boolean)UiFileTransfer.this.fConfirmRequired.get(i) != false || UiFileTransfer.this.fTransferType == UiFileTransferType.DELETE;
                            confirmationContext.nextStep(fileSystemEntry, fileLocation, bl2);
                            if (confirmationContext.confirmIfNecessary()) {
                                FileLocation fileLocation2;
                                fileSystemTransaction.createDirectory(fileLocation.getParent());
                                if (UiFileTransfer.this.fTransferType.isCopy()) {
                                    UiFileTransfer.this.doCopy(fileSystemEntry, fileSystemTransaction, fileLocation);
                                } else {
                                    UiFileTransfer.this.doMove(fileSystemEntry, fileSystemTransaction, fileLocation);
                                }
                                FileLocation fileLocation3 = fileLocation2 = fileLocation == null ? fileSystemEntry.getLocation() : fileLocation;
                                if (!bl) {
                                    arrayList.add(fileLocation2);
                                    continue;
                                }
                                if (UiFileTransfer.this.fReceiver.receive((Object)fileLocation2)) continue;
                                break;
                            }
                            if (confirmationContext.isCancelRequested()) break;
                        }
                    }
                });
                for (FileLocation fileLocation : arrayList) {
                    if (this.fReceiver.receive((Object)fileLocation)) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                this.fTransferType.showError(this.fParent, this.fSourceFiles.get(0));
            }
            finally {
                this.fReceiver.finished();
            }
        }
    }

    private FileReplaceOrDeleteDialog.Result doConfirmation(FileSystemEntry fileSystemEntry, FileLocation fileLocation, boolean bl) {
        final Holder holder = new Holder();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            FileReplaceOrDeleteDialog.showDialog(this.fParent, ExplorerExtensionRegistry.getInstance(), fileSystemEntry, this.fDestinationSystem == null ? fileSystemEntry : this.fDestinationSystem.getEntry(fileLocation), bl, this.fTransferType, new ParameterRunnable<FileReplaceOrDeleteDialog.Result>(){

                public void run(FileReplaceOrDeleteDialog.Result result) {
                    holder.set((Object)result);
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return (FileReplaceOrDeleteDialog.Result)((Object)holder.get());
    }

    private FileLocation determineCopyDestination(FileSystemEntry fileSystemEntry) {
        int n;
        int n2 = 1;
        String string = fileSystemEntry.getName();
        if (string.startsWith("Copy_of_")) {
            n2 = 2;
            string = string.substring("Copy_of_".length()).trim();
        } else if (string.startsWith("Copy_") && (n = string.indexOf("_of_")) > -1) {
            String string2 = string.substring("Copy_".length(), n);
            try {
                n2 = Integer.parseInt(string2) + 1;
                string = string.substring(n + 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileLocation fileLocation = new FileLocation(this.fDestinationParent, fileSystemEntry.getName());
        for (int i = n2; i < Integer.MAX_VALUE && this.fDestinationSystem.exists(fileLocation); ++i) {
            fileLocation = new FileLocation(this.fDestinationParent, i == 1 ? "Copy_of_" + string : "Copy_" + i + "_of_" + string);
        }
        return fileLocation;
    }

    private void doMove(FileSystemEntry fileSystemEntry, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation) {
        try {
            FileSystemUtils.move(fileSystemEntry, fileSystemTransaction, fileLocation);
        }
        catch (IOException iOException) {
            this.fTransferType.showError(this.fParent, fileSystemEntry);
        }
    }

    private void doCopy(FileSystemEntry fileSystemEntry, FileSystemTransaction fileSystemTransaction, FileLocation fileLocation) {
        try {
            FileSystemUtils.copy(fileSystemEntry, fileSystemTransaction, fileLocation);
        }
        catch (IOException iOException) {
            this.fTransferType.showError(this.fParent, fileSystemEntry);
        }
    }

    private static List<FileSystemEntry> filterDescendents(List<FileSystemEntry> list) {
        Map<FileLocation, FileSystemEntry> map = FileSystemUtils.mapByLocation(list);
        Iterator<Map.Entry<FileLocation, FileSystemEntry>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            FileLocation fileLocation;
            Map.Entry<FileLocation, FileSystemEntry> entry = iterator.next();
            FileLocation fileLocation2 = fileLocation = entry.getKey();
            while (fileLocation != null) {
                if (fileLocation.getParent() != null && map.containsKey(fileLocation.getParent())) {
                    map.remove(fileLocation2);
                    iterator = map.entrySet().iterator();
                    fileLocation = null;
                    continue;
                }
                fileLocation = fileLocation.getParent();
            }
        }
        return new ArrayList<FileSystemEntry>(map.values());
    }

    private class ConfirmationContext {
        private int fRemainingStepsRequiringConfirmation;
        private int fRemainingSteps;
        private boolean fConfirmationRequiredForCurrentStep;
        private boolean fAllStepsConfirmed;
        private boolean fCancelRequested;
        private FileSystemEntry fSourceFile;
        private FileLocation fDestinationFile;

        ConfirmationContext(int n, int n2) {
            this.fRemainingSteps = n;
            this.fRemainingStepsRequiringConfirmation = n2;
        }

        public void nextStep(FileSystemEntry fileSystemEntry, FileLocation fileLocation, boolean bl) {
            this.fSourceFile = fileSystemEntry;
            this.fDestinationFile = fileLocation;
            --this.fRemainingSteps;
            if (bl) {
                --this.fRemainingStepsRequiringConfirmation;
            }
            this.fConfirmationRequiredForCurrentStep = !this.fAllStepsConfirmed && bl;
        }

        public void requestCancel() {
            this.fCancelRequested = true;
        }

        public void confirmAll() {
            this.fAllStepsConfirmed = true;
        }

        public boolean isCancelRequested() {
            return this.fCancelRequested;
        }

        public boolean isConfirmationRequiredForCurrentStep() {
            return this.fConfirmationRequiredForCurrentStep;
        }

        public boolean hasFutureStepsRequiringConfirmation() {
            return !this.fAllStepsConfirmed && (PlatformInfo.isMacintosh() && UiFileTransfer.this.fTransferType == UiFileTransferType.RECYCLE_OR_TRASH && this.fRemainingSteps > 0 || this.fRemainingStepsRequiringConfirmation > 0);
        }

        public boolean confirmIfNecessary() {
            return !this.isConfirmationRequiredForCurrentStep() || this.confirm();
        }

        public boolean confirm() {
            if (this.fAllStepsConfirmed) {
                return true;
            }
            FileReplaceOrDeleteDialog.Result result = UiFileTransfer.this.doConfirmation(this.fSourceFile, this.fDestinationFile, this.hasFutureStepsRequiringConfirmation());
            switch (result) {
                case CANCEL: {
                    this.requestCancel();
                }
                case NO: {
                    return false;
                }
                case YES_TO_ALL: {
                    this.confirmAll();
                }
                case YES: {
                    return true;
                }
            }
            throw new IllegalStateException("No known option chosen");
        }
    }

    private class GenericDeleteConfirmationPredicate
    implements Predicate<FileSystemEntry> {
        private int iIndex;
        private ConfirmationContext iContext;

        private GenericDeleteConfirmationPredicate() {
            this.iContext = new ConfirmationContext(UiFileTransfer.this.fSourceFiles.size(), UiFileTransfer.this.fConfirmRequiredCount);
        }

        public boolean accept(FileSystemEntry fileSystemEntry) {
            boolean bl = !UiFileTransfer.this.fConfirmRequired.isEmpty() && (Boolean)UiFileTransfer.this.fConfirmRequired.get(this.iIndex) != false || UiFileTransfer.this.fTransferType == UiFileTransferType.DELETE;
            this.iContext.nextStep(fileSystemEntry, null, bl);
            boolean bl2 = this.iContext.confirmIfNecessary();
            ++this.iIndex;
            return bl2;
        }
    }
}

