/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButton;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonPanel;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarMode;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarModeComponent;
import com.mathworks.mlwidgets.explorer.widgets.address.IconLabel;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.BusyAffordance;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class BreadcrumbModeComponent
implements AddressBarModeComponent {
    private final AddressBar fAddressBar;
    private final AddressBarButtonPanel fButtons;
    private final MJPanel fComponent;
    private final IconLabel fIconLabel;
    private final BusyAffordance fBusyAffordance;
    private State fState;

    BreadcrumbModeComponent(AddressBar addressBar) {
        this.fAddressBar = addressBar;
        this.fButtons = new AddressBarButtonPanel();
        this.fBusyAffordance = addressBar.createBusyAffordance();
        this.fComponent = new MJPanel();
        this.fIconLabel = new IconLabel();
        this.fState = new State();
        this.rebuild();
        this.startTypingOnClick();
    }

    private void rebuild() {
        this.fButtons.removeAll();
        FileLocation[] fileLocationArray = this.fAddressBar.getPath();
        FileLocation[] fileLocationArray2 = this.fState.getVisiblePath();
        boolean bl = fileLocationArray2.length == fileLocationArray.length - 1 && fileLocationArray[0].getName().length() > 0 || fileLocationArray2.length < fileLocationArray.length - 1;
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.setLayout((LayoutManager)new FormLayout("center:20px, fill:d:grow", "p"));
        this.fComponent.removeAll();
        this.fComponent.setBackground(this.fAddressBar.getBackground());
        this.fButtons.getComponent().setBackground(this.fAddressBar.getBackground());
        this.fIconLabel.setIcon(AddressBarButtonUtils.getCurrentLocationIcon(this.fAddressBar));
        this.fIconLabel.setToolTipText(this.fAddressBar.getContext().getLocation().toString());
        this.fIconLabel.getComponent().setName("CurrentLocationIcon");
        if (!this.fState.isBusy()) {
            this.fComponent.add((Component)this.fIconLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
        } else {
            this.fComponent.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(1, 1));
        }
        if (bl) {
            this.fButtons.add(AddressBarButtonUtils.createPathExtensionButton((JComponent)this.fComponent, this.fAddressBar, fileLocationArray[fileLocationArray.length - fileLocationArray2.length - 1]));
        }
        for (int i = 0; i < fileLocationArray2.length; ++i) {
            this.fButtons.add(AddressBarButtonUtils.createBreadcrumbButton((JComponent)this.fComponent, this.fAddressBar, fileLocationArray2, fileLocationArray2[i], i + 1 < fileLocationArray2.length ? fileLocationArray2[i + 1] : null, true, false));
        }
        this.fButtons.addGap();
        this.fButtons.add(AddressBarButtonUtils.createHistoryButton((JComponent)this.fComponent, this.fAddressBar));
        this.fComponent.setBackground(this.fAddressBar.getBackground());
        this.fComponent.add((Component)this.fButtons.getComponent(), (Object)cellConstraints.xy(2, 1));
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public void notifyResized() {
        this.fState = new State();
        this.rebuild();
    }

    @Override
    public void notifyDataChanged() {
        State state = new State();
        if (!state.equals(this.fState)) {
            this.fState = state;
            this.rebuild();
        }
    }

    @Override
    public void notifyActivating(MouseEvent mouseEvent) {
    }

    @Override
    public void notifyActivated(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BreadcrumbModeComponent.this.fState = new State();
                BreadcrumbModeComponent.this.rebuild();
            }
        });
    }

    public void setToolTipText(String string) {
        assert (EventQueue.isDispatchThread()) : "This method must be called on the EDT";
        this.fIconLabel.setToolTipText(string);
    }

    private FileLocation[] calculateVisiblePath() {
        AddressBarButton addressBarButton;
        JComponent jComponent;
        Stack<FileLocation> stack = new Stack<FileLocation>();
        FileLocation[] fileLocationArray = this.fAddressBar.getPath();
        AddressBarButton addressBarButton2 = AddressBarButtonUtils.createHistoryButton((JComponent)this.fComponent, this.fAddressBar);
        AddressBarButton addressBarButton3 = AddressBarButtonUtils.createPathExtensionButton((JComponent)this.fComponent, this.fAddressBar, fileLocationArray[0]);
        int n = (int)(new MJLabel(AddressBarButtonUtils.getCurrentLocationIcon(this.fAddressBar)).getPreferredSize().getWidth() + addressBarButton3.getComponent().getPreferredSize().getWidth() + addressBarButton2.getComponent().getPreferredSize().getWidth()) + 8;
        FileLocation[] fileLocationArray2 = this.fState == null ? null : this.fState.getVisiblePath();
        for (int i = fileLocationArray.length - 1; i >= 0 && (double)n + (jComponent = (addressBarButton = AddressBarButtonUtils.createBreadcrumbButton((JComponent)this.fComponent, this.fAddressBar, fileLocationArray2, fileLocationArray[i], null, false, true)).getComponent()).getPreferredSize().getWidth() < (double)this.fComponent.getWidth(); --i) {
            stack.push(fileLocationArray[i]);
            n += (int)jComponent.getPreferredSize().getWidth();
        }
        if (stack.empty()) {
            stack.push(fileLocationArray[fileLocationArray.length - 1]);
        }
        FileLocation[] fileLocationArray3 = new FileLocation[stack.size()];
        for (int i = 0; i < fileLocationArray3.length; ++i) {
            fileLocationArray3[i] = (FileLocation)stack.pop();
        }
        return fileLocationArray3;
    }

    private void startTypingOnClick() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (BreadcrumbModeComponent.this.fAddressBar.getMode().equals((Object)AddressBarMode.BREADCRUMB_MODE)) {
                    BreadcrumbModeComponent.this.fAddressBar.setModeIfSupported(AddressBarMode.LOCATION_TYPING_MODE, mouseEvent);
                }
            }
        };
        this.fButtons.getComponent().addMouseListener(mouseAdapter);
        this.fIconLabel.getComponent().addMouseListener(mouseAdapter);
        this.fBusyAffordance.getComponent().addMouseListener(mouseAdapter);
    }

    private class State {
        private final boolean fBusy;
        private final boolean fHasFolders;
        private final FileLocation[] fVisiblePath;

        State() {
            this.fBusy = BreadcrumbModeComponent.this.fAddressBar.getWorkMonitor().isBusy();
            boolean bl = false;
            try {
                bl = !BreadcrumbModeComponent.this.fAddressBar.getContext().isSearching() && BreadcrumbModeComponent.this.fAddressBar.getContext().getList().hasFolders();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fHasFolders = bl;
            this.fVisiblePath = BreadcrumbModeComponent.this.calculateVisiblePath();
        }

        boolean isBusy() {
            return this.fBusy;
        }

        FileLocation[] getVisiblePath() {
            return (FileLocation[])this.fVisiblePath.clone();
        }

        public boolean equals(Object object) {
            return this.fBusy == ((State)object).fBusy && this.fHasFolders == ((State)object).fHasFolders && Arrays.equals(this.fVisiblePath, ((State)object).fVisiblePath);
        }

        public int hashCode() {
            return this.fHasFolders ? 1 : 0;
        }
    }
}

