/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.CatalogPanel;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.IPlotPickerTableListener;
import com.mathworks.mlwidgets.graphics.IPlotSelectionListener;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotActionEvent;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.graphics.PlotPickerDialog;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.graphics.PlotPickerPanel;
import com.mathworks.mlwidgets.graphics.PlotPickerXMLParser;
import com.mathworks.mlwidgets.graphics.PlotWidgetsResources;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mlwidgets.graphics.WindowDropdownButton;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.DTWindowRegistry;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class PlotPicker
extends MJPanel
implements IPlotSelectionListener,
IPlotPickerTableListener,
PlotPickerOpener,
ActionListener {
    static final Color DEFAULT_BACKGROUND_COLOR = new Color(249, 249, 249);
    private static volatile DTWindowCloser sDTWindowCloser = null;
    private PlotCatalog fMorePlotsDlg = null;
    private PlotPickerPanel fPlotPickerPanel;
    private WindowDropdownButton fDropdownBtn;
    private final MJButton fMainBtn;
    private AbstractAction fBigButtonAction;
    private String fMainBtnTooltip;
    private String fDropdownBtnTooltip;
    private IPlotPickerDisplayTrigger fPlotPickerRequester;
    private JComponent fHost;
    private PlotPickerUIUpdater fPlotPickerUIUpdater;
    private Border fNativeMACMainButtonBorder;
    private Border fNativeMACDropDownButtonBorder;
    private Dimension fNativeMACMainButtonPreferredSize = null;
    private String fNoVariablesText;
    private static final String RES_STR = "com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker");
    private static boolean sColdStartFlag = true;
    private static final int MIN_BUTTON_WIDTH = 50;
    private static final Object DTWINDOWCLOSER_LOCK = new Object();

    private static void initModelStateFactory() {
        if (!ModelStateFactory.isInitialized()) {
            new Thread(new ModelStateFactoryInitializer()).start();
        }
    }

    public PlotPicker(JComponent jComponent) {
        super((LayoutManager)new BorderLayout());
        PlotPicker.initModelStateFactory();
        this.fHost = jComponent;
        this.fMainBtn = new MJButton();
        this.fMainBtn.setName("plot-picker-action");
        this.fMainBtn.setHorizontalAlignment(2);
        this.fMainBtn.setBorderPainted(false);
        this.fMainBtn.setOpaque(false);
        this.fMainBtn.setIcon((Icon)new ImageIcon(PlotPicker.class.getResource("resources/browse_plots.png")));
        this.fMainBtn.setText(PlotPicker.getResourceString("PlotPicker", "SelectToPlot"));
        if (50 < this.fMainBtn.getPreferredSize().width) {
            this.fMainBtn.setMinimumSize(new Dimension(50, 1));
        }
        this.fDropdownBtn = new WindowDropdownButton(this);
        this.fDropdownBtn.setBorderPainted(false);
        this.fDropdownBtn.setPreferredSize(new Dimension(this.fDropdownBtn.getIcon().getIconWidth(), this.fDropdownBtn.getPreferredSize().height));
        this.fDropdownBtn.setName("plot-picker");
        this.fDropdownBtn.setOpaque(false);
        this.setEnabledState(EnableState.NOSELECTION, new String[0]);
        if (PlatformInfo.isMacintosh()) {
            this.fNativeMACMainButtonBorder = this.fMainBtn.getBorder();
            this.fNativeMACDropDownButtonBorder = this.fDropdownBtn.getBorder();
            this.fNativeMACMainButtonPreferredSize = this.fMainBtn.getPreferredSize();
        }
        this.setUpButtonLayout();
        this.fMainBtn.removeActionListener((ActionListener)this);
        this.fMainBtn.addActionListener((ActionListener)this);
        PlotPicker.addDTWindowCloser();
        this.setMaximumSize(new Dimension(200, (int)this.getMaximumSize().getHeight()));
        if (!PlatformInfo.isMacintosh()) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(-2, -1, -2, -1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDTWindowCloser() {
        Object object = DTWINDOWCLOSER_LOCK;
        synchronized (object) {
            if (sDTWindowCloser == null) {
                sDTWindowCloser = new DTWindowCloser(){

                    public boolean canClose() {
                        return true;
                    }

                    public void close() {
                        if (ModelStateFactory.sPlotPickerRoot != null) {
                            PlotPickerXMLParser.writeLayoutToXML(ModelStateFactory.sPlotPickerRoot);
                        }
                    }
                };
                DTWindowRegistry.getInstance().addCloser(sDTWindowCloser);
            }
        }
    }

    public static ResourceBundle getBundle() {
        return RESOURCE_BUNDLE;
    }

    public static String[] getClassNames() {
        return new String[0];
    }

    private void createPlotPickerPanel() {
        if (this.fPlotPickerPanel == null) {
            this.fPlotPickerPanel = new PlotPickerPanel();
            this.fPlotPickerPanel.addPlotPickerTableListener(this);
            this.fPlotPickerPanel.addPlotSelectionListener(this);
        }
    }

    JComponent getHost() {
        return this.fHost;
    }

    PlotPickerDialog createPlotPickerDialog() {
        this.createPlotPickerPanel();
        this.fHost.requestFocus();
        PlotPickerDialog plotPickerDialog = new PlotPickerDialog(this.fPlotPickerPanel, new CatalogPanel(new CatalogAction()), (Frame)SwingUtilities.getWindowAncestor(this.fHost));
        plotPickerDialog.setExcludedClickTargets(new Component[]{this.fMainBtn, this.fDropdownBtn});
        plotPickerDialog.setParentComponent(this.fHost);
        return plotPickerDialog;
    }

    public PlotPicker(JComponent jComponent, IPlotPickerDisplayTrigger iPlotPickerDisplayTrigger) {
        this(jComponent);
        this.fPlotPickerRequester = iPlotPickerDisplayTrigger;
        this.fPlotPickerRequester.addPlotPickerOpener(this);
    }

    public void cleanup() {
        if (this.fPlotPickerPanel != null) {
            this.fPlotPickerPanel.cleanup();
        }
        if (this.fPlotPickerRequester != null) {
            this.fPlotPickerRequester.removePlotPickerOpener(this);
        }
        this.fPlotPickerRequester = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fBigButtonAction != null) {
            this.fBigButtonAction.actionPerformed(actionEvent);
        }
    }

    static String getResourceString(String string, String string2) {
        return RESOURCE_BUNDLE.getString(string + "." + string2);
    }

    private void setDefaultPlotBehavior(PlotAction plotAction, String[] stringArray) {
        this.fBigButtonAction = new PlotCommandAction(plotAction, this.fPlotPickerPanel);
        StateNode stateNode = this.fPlotPickerPanel.getStateNode(plotAction);
        if (stateNode == null) {
            return;
        }
        String string = this.fPlotPickerPanel.getLabelForPlotPickerButton(stateNode, stringArray);
        String string2 = MJUtilities.exciseMnemonic((String)string);
        this.fMainBtn.setToolTipText(string2);
        this.fDropdownBtn.setToolTipText(string2);
        this.fMainBtn.setIcon((Icon)plotAction.getSmallIcon());
        this.fMainBtn.getAccessibleContext().setAccessibleName(string);
        this.fMainBtn.setText(string);
    }

    private void setUpButtonLayout() {
        this.fMainBtn.setName("Big Picker Button");
        this.add((Component)this.fMainBtn, "Center");
        this.add((Component)((Object)this.fDropdownBtn), "East");
        this.fDropdownBtn.setComponentToAlignWith((Component)((Object)this));
        String string = this.fMainBtn.getText();
        MJToolBar.configureButton((MJButton)this.fMainBtn);
        this.fMainBtn.setText(string);
        MJToolBar.configureButton((MJButton)this.fDropdownBtn);
        if (PlatformInfo.isMacintosh()) {
            this.fMainBtn.setMargin(new Insets(0, 5, 0, 0));
        } else {
            this.fMainBtn.setMargin(new Insets(0, 0, 0, 0));
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (PlotPicker.this.fMainBtn.isEnabled()) {
                    PlotPicker.this.toggleAppearance(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PlotPicker.this.toggleAppearance(false);
            }
        };
        this.fMainBtn.addMouseListener((MouseListener)mouseAdapter);
        this.fDropdownBtn.addMouseListener(mouseAdapter);
        if (PlatformInfo.isMacintosh()) {
            this.fMainBtn.setPreferredSize(this.fNativeMACMainButtonPreferredSize);
        }
    }

    private void setEnabledState(EnableState enableState, String[] stringArray) {
        if (PlotAction.sNeedPathRehash) {
            this.fMainBtn.setText("Please rehash path & restart");
            this.fMainBtn.setIcon((Icon)new ImageIcon(PlotPicker.class.getResource("resources/browse_plots.png")));
            this.fBigButtonAction = new ShowEmptyPlotPickerWindow();
            this.fDropdownBtn.setEnabled(false);
        } else if (enableState == EnableState.NOSELECTION || PlotAction.sNeedPathRehash) {
            this.fMainBtnTooltip = this.fMainBtn.getToolTipText();
            this.fDropdownBtnTooltip = this.fDropdownBtn.getToolTipText();
            this.fMainBtn.setToolTipText(PlotPicker.getResourceString("PlotPicker", "MakeSelect"));
            this.fDropdownBtn.setToolTipText(PlotPicker.getResourceString("PlotPicker", "MakeSelect"));
            this.fMainBtn.setIcon((Icon)new ImageIcon(PlotPicker.class.getResource("resources/browse_plots.png")));
            this.fMainBtn.setText(this.fNoVariablesText == null ? PlotPicker.getResourceString("PlotPicker", "SelectToPlot") : this.fNoVariablesText);
            this.fBigButtonAction = new ShowEmptyPlotPickerWindow();
        } else if (enableState == EnableState.NOVALIDPLOTS) {
            String string;
            this.fMainBtnTooltip = this.fMainBtn.getToolTipText();
            this.fDropdownBtnTooltip = this.fDropdownBtn.getToolTipText();
            if (stringArray == null || stringArray.length == 0) {
                string = PlotPicker.getResourceString("PlotPicker", "NoValidPlots");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PlotPicker.getResourceString("PlotPicker", "NoValidPlots"));
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(",");
                    stringBuilder.append(stringArray[i]);
                }
                string = stringBuilder.toString();
            }
            this.fMainBtn.setToolTipText(string);
            this.fDropdownBtn.setToolTipText(string);
            this.fMainBtn.setIcon((Icon)new ImageIcon(PlotPicker.class.getResource("resources/browse_plots.png")));
            this.fMainBtn.setText(string);
            this.fBigButtonAction = new ShowEmptyPlotPickerWindow();
        } else {
            this.fMainBtn.setToolTipText(this.fMainBtnTooltip);
            this.fDropdownBtn.setToolTipText(this.fDropdownBtnTooltip);
        }
    }

    private void toggleAppearance(boolean bl) {
        if (PlatformInfo.isWindowsModernAppearance()) {
            this.fMainBtn.getModel().setRollover(bl);
            this.fDropdownBtn.getModel().setRollover(bl);
        } else {
            this.fMainBtn.setFlyOverAppearance(!bl);
            this.fDropdownBtn.setFlyOverAppearance(!bl);
        }
        if (PlatformInfo.isMacintosh()) {
            this.fMainBtn.setBorder(this.fNativeMACMainButtonBorder);
            this.fDropdownBtn.setBorder(this.fNativeMACDropDownButtonBorder);
            this.fMainBtn.setMargin(new Insets(0, 5, 0, 0));
            this.fMainBtn.setPreferredSize(this.fNativeMACMainButtonPreferredSize);
        } else if (bl) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(-2, -1, -2, -1)));
        }
    }

    @Override
    public void selectionComplete(PlotActionEvent plotActionEvent) {
        this.fMainBtn.removeActionListener((ActionListener)this);
        this.fMainBtn.addActionListener((ActionListener)this);
        this.fDropdownBtn.setEnabled(true);
        this.fMainBtn.setEnabled(true);
        this.fDropdownBtn.setActive(true);
        if (plotActionEvent.getID() == PlotActionEvent.SELECTION_FAILED) {
            this.setEnabledState(EnableState.NOVALIDPLOTS, plotActionEvent.getSelectedVars());
        } else if (plotActionEvent.getID() == PlotActionEvent.NOSELECTION) {
            this.setEnabledState(EnableState.NOSELECTION, plotActionEvent.getSelectedVars());
        } else if (plotActionEvent.getID() == PlotActionEvent.SELECTION_SUCEEDED) {
            this.setEnabledState(EnableState.ENABLED, plotActionEvent.getSelectedVars());
            PlotAction plotAction = this.fPlotPickerPanel.getDefaultAction();
            this.setDefaultPlotBehavior(plotAction, plotActionEvent.getSelectedVars());
        }
    }

    @Override
    public void invoked(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() instanceof PlotAction) {
            PlotAction plotAction = (PlotAction)aWTEvent.getSource();
            this.setDefaultPlotBehavior(plotAction, this.getPlottedVars());
        }
    }

    @Deprecated
    public void setShowingSelectedLabel(boolean bl) {
    }

    public void setNoVariablesText(String string) {
        String string2 = this.fMainBtn.getText();
        String string3 = PlotPicker.getResourceString("PlotPicker", "SelectToPlot");
        if (string != null && (this.fNoVariablesText != null && this.fNoVariablesText.equals(string2) || string3.equals(string2))) {
            this.fMainBtn.setText(string);
        } else if (string == null && this.fNoVariablesText != null && this.fNoVariablesText.equals(string2)) {
            this.fMainBtn.setText(string3);
        }
        this.fNoVariablesText = string;
    }

    public String[] getPlottedVars() {
        if (this.fPlotPickerPanel != null) {
            return this.fPlotPickerPanel.getSelectedVarNames();
        }
        return new String[0];
    }

    public void setPlottedVars(String[] stringArray) {
        if (sColdStartFlag) {
            sColdStartFlag = false;
            this.fMainBtn.setEnabled(false);
            this.fDropdownBtn.setEnabled(false);
        }
        if (this.fPlotPickerUIUpdater == null || this.fPlotPickerUIUpdater.isStarted()) {
            this.fPlotPickerUIUpdater = new PlotPickerUIUpdater(this);
            this.fPlotPickerUIUpdater.setVarNames(stringArray);
            SwingUtilities.invokeLater(this.fPlotPickerUIUpdater);
        } else {
            this.fPlotPickerUIUpdater.setVarNames(stringArray);
        }
    }

    private void utSetPlottedVars(String[] stringArray) {
        this.createPlotPickerPanel();
        if (this.fDropdownBtn.isShowingContent()) {
            this.setEnabledState(EnableState.ENABLED, stringArray);
            return;
        }
        boolean bl = this.fPlotPickerPanel.setVarNames(stringArray);
        if (bl && stringArray != null && stringArray.length > 0) {
            this.fMainBtn.removeActionListener((ActionListener)this);
            this.fDropdownBtn.setActive(false);
        }
    }

    @Override
    public void openPlotPicker() {
        this.fHost.requestFocus();
        Timer timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotPicker.this.fDropdownBtn.doPostMenu();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private static URL makeImageURL(String string) {
        return PlotPicker.class.getResource("/com/mathworks/mlwidgets/graphics/resources/" + string);
    }

    public static String getDisplayName() {
        return PlotWidgetsResources.getBundle().getString("PlotPicker.tooltip");
    }

    public static ImageIcon getDefaultIcon() {
        return new ImageIcon(PlotPicker.makeImageURL("plotpicker-plot.gif"));
    }

    private static class PlotPickerUIUpdater
    implements Runnable {
        private String[] iVarNames;
        private boolean iStarted = false;
        private PlotPicker iPlotPicker;

        private PlotPickerUIUpdater(PlotPicker plotPicker) {
            this.iPlotPicker = plotPicker;
        }

        @Override
        public void run() {
            this.iStarted = true;
            this.iPlotPicker.utSetPlottedVars(this.iVarNames);
        }

        void setVarNames(String[] stringArray) {
            this.iVarNames = stringArray == null ? null : (String[])stringArray.clone();
        }

        boolean isStarted() {
            return this.iStarted;
        }
    }

    private class CatalogAction
    extends AbstractAction {
        private CatalogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PlotPicker.this.fMorePlotsDlg == null) {
                PlotPicker.this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            PlotPicker.this.fMorePlotsDlg.setPlottedVars(PlotPicker.this.fPlotPickerPanel.getSelectedVarNames());
            PlotPicker.this.fMorePlotsDlg.setVisible(true);
        }
    }

    private class ShowEmptyPlotPickerWindow
    extends AbstractAction {
        private ShowEmptyPlotPickerWindow() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlotPicker.this.fDropdownBtn.doPostMenu();
        }
    }

    private static class PlotCommandAction
    extends AbstractAction {
        private PlotAction iCmdDesc;
        private PlotPickerPanel iPlotPickerPanel;

        PlotCommandAction(PlotAction plotAction, PlotPickerPanel plotPickerPanel) {
            super(plotAction.getFunctionName());
            this.iPlotPickerPanel = plotPickerPanel;
            this.iCmdDesc = plotAction;
        }

        private static String[] deriveSelectedVars(StateNode stateNode, String[] stringArray) {
            if (stateNode != null && stringArray.length == 2 && !stateNode.isEnabledByUnswappedVariables()) {
                return new String[]{stringArray[1], stringArray[0]};
            }
            return stringArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StateNode stateNode = this.iPlotPickerPanel.getStateNode(this.iCmdDesc);
            this.iCmdDesc.execute(PlotCommandAction.deriveSelectedVars(stateNode, this.iPlotPickerPanel.getSelectedVarNames()), actionEvent.getSource());
        }
    }

    private static class ModelStateFactoryInitializer
    implements Runnable {
        private ModelStateFactoryInitializer() {
        }

        @Override
        public void run() {
            ModelStateFactory.createPlotHiearchy();
        }
    }

    public static enum EnableState {
        ENABLED,
        NOSELECTION,
        NOVALIDPLOTS;

    }
}

