/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.graphics.PlotToolSet;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mwswing.IconSet;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.FilteredGalleryModel;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class PlotToolSetFactory {
    private static TSToolSetContents sContents = null;
    private static boolean sContentsLoaded = false;
    private static TSRegistry sPendingRegistry = null;
    private static Map<String, PlotAction> sPlotActionMap = null;
    private static final String FAVORITES_NAME = Category.FAVORITES.getName();
    private static final List<GalleryInfo> sUninitializedGalleries = new ArrayList<GalleryInfo>();

    private PlotToolSetFactory() {
    }

    public static PlotToolSet createToolSet() {
        if (sContents == null) {
            PlotToolSetFactory.createContents();
        }
        PlotToolSet plotToolSet = new PlotToolSet(sContents);
        if (sPlotActionMap != null) {
            for (Map.Entry<String, PlotAction> entry : sPlotActionMap.entrySet()) {
                plotToolSet.addPlotAction(entry.getKey(), entry.getValue());
            }
            plotToolSet.addDecorator("plots", new TSToolSet.ToolDecorator(){

                public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                    GalleryView galleryView = (GalleryView)jComponent;
                    galleryView.setModel((GalleryModel)new FilteredGalleryModel(galleryView.getModel()));
                }
            });
        } else {
            final GalleryInfo galleryInfo = new GalleryInfo(plotToolSet);
            plotToolSet.addDecorator("plots", new TSToolSet.ToolDecorator(){

                public void decorateTool(JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
                    galleryInfo.fGalleryView = (GalleryView)jComponent;
                    galleryInfo.fGalleryView.setBusy(true);
                }
            });
            sUninitializedGalleries.add(galleryInfo);
        }
        return plotToolSet;
    }

    private static void createContents() {
        sContents = new TSToolSetContents("plot_toolset");
        final GalleryOptions galleryOptions = new GalleryOptions().setColumnWidth(1.1f).setLabelLineCount(1).setRowCount(1).setMinColumnCount(3).setMaxColumnCount(10).setMultiSelectPopup(true);
        sContents.addTool(new TSToolSetContents.ToolParameters("plots").setType(TSToolSetContents.ToolType.GALLERY).setLabel(PlotPicker.getResourceString("PlotToolSet", "Plot")).setGalleryOptions(galleryOptions), new TSToolSetContents.Dependency[0]);
        sContents.addTool(new TSToolSetContents.ToolParameters(FAVORITES_NAME).setType(TSToolSetContents.ToolType.GROUP).setLabel(Category.FAVORITES.getLabel()), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("plots")});
        ModelStateFactory.createPlotHiearchy(false);
        if (ModelStateFactory.isReady()) {
            PlotToolSetFactory.addPlots(FAVORITES_NAME, ModelStateFactory.createNoSelectionModelState());
            galleryOptions.setShareModel(true);
        } else {
            ModelStateFactory.addParseCompletionListener(new ModelStateFactory.ParseCompleteListener(){

                @Override
                public void parseComplete() {
                    PlotToolSetFactory.addPlots(FAVORITES_NAME, ModelStateFactory.createNoSelectionModelState());
                    galleryOptions.setShareModel(true);
                    while (!sUninitializedGalleries.isEmpty()) {
                        GalleryInfo galleryInfo = (GalleryInfo)sUninitializedGalleries.remove(0);
                        for (Map.Entry entry : sPlotActionMap.entrySet()) {
                            galleryInfo.fToolSet.addPlotAction((String)entry.getKey(), (PlotAction)entry.getValue());
                        }
                        if (galleryInfo.fGalleryView == null) continue;
                        TSToolPath tSToolPath = (TSToolPath)galleryInfo.fGalleryView.getClientProperty((Object)"tool path");
                        Map<String, PlotToolSet> map = Collections.singletonMap("plot_toolset", galleryInfo.fToolSet);
                        galleryInfo.fGalleryView.setBusy(false);
                        galleryInfo.fGalleryView.setModel((GalleryModel)new FilteredGalleryModel(TSFactory.createGalleryModel((TSToolSetContents.Tool)sContents.getTool("plots"), (TSToolPath)tSToolPath, map, (TSRegistry)sPendingRegistry, (boolean)false)));
                    }
                    if (sPendingRegistry != null) {
                        sPendingRegistry.addToolSetContents(sContents);
                        sPendingRegistry = null;
                    }
                }
            });
        }
    }

    private static void addPlots(String string, StateNode stateNode) {
        if (sPlotActionMap == null) {
            sPlotActionMap = new HashMap<String, PlotAction>();
        }
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            Object object;
            TreeNode treeNode = stateNode.getChildAt(i);
            if (!(treeNode instanceof StateNode)) continue;
            StateNode stateNode2 = (StateNode)treeNode;
            Object object2 = stateNode2.getUserObject();
            if (object2 instanceof PlotAction) {
                Image image;
                object = (PlotAction)object2;
                String string2 = ((PlotAction)object).getShortDescription();
                if (string2 == null) {
                    string2 = ((PlotAction)object).getFunctionName();
                }
                ImageIcon imageIcon = ((PlotAction)object).getSmallIcon();
                int n = imageIcon.getIconWidth();
                int n2 = imageIcon.getIconHeight();
                if (n2 > 16) {
                    if (imageIcon instanceof ImageIcon) {
                        image = imageIcon.getImage();
                    } else {
                        image = new BufferedImage(n, n2, 2);
                        Graphics graphics = image.getGraphics();
                        imageIcon.paintIcon(new JLabel(), graphics, 0, 0);
                        graphics.dispose();
                    }
                    int n3 = n * 16 / n2 + 1;
                    int n4 = 16;
                    BufferedImage bufferedImage = new BufferedImage(n3, 16, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(image, 0, 0, n3, n4, 0, 0, n, n2, null);
                    imageIcon = new ImageIcon(bufferedImage);
                    graphics2D.dispose();
                }
                image = new IconSet(new Icon[]{((PlotAction)object).getIcon(), imageIcon});
                sContents.addTool(new TSToolSetContents.ToolParameters(((PlotAction)object).getID()).setLabel(string2).setDescription(((PlotAction)object).getDescription()).setIcon((Icon)((Object)image)), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency(string)});
                sPlotActionMap.put(((PlotAction)object).getID(), (PlotAction)object);
                continue;
            }
            if (!(object2 instanceof String)) continue;
            object = (String)object2;
            sContents.addTool(new TSToolSetContents.ToolParameters((String)object).setType(TSToolSetContents.ToolType.GROUP).setLabel((String)object), new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("plots")});
            PlotToolSetFactory.addPlots((String)object, stateNode2);
        }
    }

    private static class GalleryInfo {
        private final PlotToolSet fToolSet;
        private GalleryView fGalleryView;

        private GalleryInfo(PlotToolSet plotToolSet) {
            this.fToolSet = plotToolSet;
        }
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            if (sContents == null) {
                PlotToolSetFactory.createContents();
            }
            if (sContentsLoaded) {
                tSRegistry.addToolSetContents(sContents);
            } else {
                sPendingRegistry = tSRegistry;
            }
        }
    }
}

