/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

public class CSHelpTopicMap {
    private final String fMapFileLocation;
    private Map<String, String> fTopicMap;
    private Map<String, String> fAlternateTopicMap;
    private String fAlternateMapFile;
    private static HelpDependencyProvider sDependencyProvider = new DefaultDocRootProvider();
    private static boolean sTesting = false;
    private static String sHelpPath = null;

    public CSHelpTopicMap(String string) {
        String string2 = HelpUtils.getLocalizedFilename(string);
        if (string2 != null) {
            this.fMapFileLocation = string2;
            BufferedReader bufferedReader = CSHelpTopicMap.getMapReader(this.fMapFileLocation);
            this.fTopicMap = CSHelpTopicMap.readMap(bufferedReader);
            CSHelpTopicMap.closeMapReader(bufferedReader);
        } else {
            this.fMapFileLocation = string;
        }
    }

    public CSHelpTopicMap(String string, String string2) {
        this(CSHelpTopicMap.findLocalizedMapFile(string, string2));
    }

    private static BufferedReader getMapReader(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Invalid map file: " + string);
            return null;
        }
    }

    private static void closeMapReader(BufferedReader bufferedReader) {
        block3: {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"Failed to close the topic map reader");
                }
            }
        }
    }

    private static Map<String, String> readMap(BufferedReader bufferedReader) {
        HashMap<String, String> hashMap = null;
        if (bufferedReader != null) {
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.commentChar(37);
                streamTokenizer.whitespaceChars(32, 32);
                streamTokenizer.whitespaceChars(9, 9);
                streamTokenizer.wordChars(33, 33);
                streamTokenizer.wordChars(35, 36);
                streamTokenizer.wordChars(38, 38);
                streamTokenizer.wordChars(40, 47);
                streamTokenizer.wordChars(48, 57);
                streamTokenizer.wordChars(58, 64);
                streamTokenizer.wordChars(65, 90);
                streamTokenizer.wordChars(91, 95);
                streamTokenizer.wordChars(97, 122);
                streamTokenizer.wordChars(123, 126);
                streamTokenizer.eolIsSignificant(false);
                hashMap = new HashMap<String, String>();
                while (streamTokenizer.nextToken() != -1) {
                    String string;
                    if (streamTokenizer.ttype != -3) continue;
                    String string2 = streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -3 || (string = streamTokenizer.sval) == null) continue;
                    hashMap.put(string2, string);
                }
            }
            catch (IOException iOException) {
                System.out.println("Map parse error: " + iOException);
            }
        }
        return hashMap;
    }

    private String mapAlternateLanguageID(String string) {
        if (this.fAlternateTopicMap == null) {
            this.fAlternateMapFile = CSHelpTopicMap.findAlternateMapFile(new File(this.fMapFileLocation));
            BufferedReader bufferedReader = CSHelpTopicMap.getMapReader(this.fAlternateMapFile);
            if (bufferedReader == null) {
                this.fAlternateTopicMap = new HashMap<String, String>();
            } else {
                this.fAlternateTopicMap = CSHelpTopicMap.readMap(bufferedReader);
                CSHelpTopicMap.closeMapReader(bufferedReader);
            }
        }
        return this.fAlternateTopicMap.get(string);
    }

    public String mapID(String string) {
        String string2 = null;
        if (this.exists()) {
            String string3 = new File(this.fMapFileLocation).getParent();
            string2 = this.fTopicMap.get(string);
            if (string2 == null && (string2 = this.mapAlternateLanguageID(string)) != null) {
                string3 = new File(this.fAlternateMapFile).getParent();
            }
            if (string2 != null) {
                string2 = string2.replace('/', File.separatorChar);
                File file = new File(string3, string2);
                try {
                    string2 = file.getCanonicalPath();
                    if (HelpPrefs.isUsingDocCenterBrowser()) {
                        string2 = CSHelpTopicMap.replacePathWithDocCenterRoot(string2);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Invalid topic path: " + string2);
                    string2 = null;
                }
            }
        }
        return string2;
    }

    private static String replacePathWithDocCenterRoot(String string) {
        String string2 = string;
        String string3 = HelpPrefs.getDocCenterRoot();
        if (!HelpPrefs.getDocRoot().equals(HelpPrefs.getDocCenterRoot())) {
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string2 = string2.replace(File.separatorChar, '/').replace(HelpPrefs.getDocRoot(), string3);
        }
        return string2;
    }

    public boolean exists() {
        return this.fTopicMap != null;
    }

    public String getFilePath() {
        if (this.fMapFileLocation == null) {
            return "";
        }
        return this.fMapFileLocation;
    }

    private static String findAlternateMapFile(File file) {
        String string = null;
        if (!HelpUtils.isEnglish()) {
            String string2 = HelpUtils.getAlternateLanguagePath(file.getAbsolutePath());
            string = CSHelpTopicMap.findMapFile(new File(string2));
        }
        return string;
    }

    private static String findMapFile(File file) {
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        String string = file.getName();
        do {
            string = file2.getName() + "/" + string;
        } while ((file2 = file2.getParentFile()) != null);
        return null;
    }

    static String findLocalizedMapFileName(String string, String string2) {
        String string3 = CSHelpTopicMap.findLocalizedMapFile(string, string2);
        return string3 != null ? string3 : null;
    }

    private static String findLocalizedMapFile(String string, String string2) {
        String string3 = sDependencyProvider.getHelpLocationForShortName(string);
        if (string3 == null) {
            return null;
        }
        return CSHelpTopicMap.findMapFileForProduct(string3, string2);
    }

    private static String findMapFileForProduct(String string, String string2) {
        File file;
        String string3 = string2 + ".map";
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        String string4 = HelpUtils.getLocalizedFilename(string + string3);
        boolean bl = false;
        if (string4 != null && (file = new File(string4)).exists()) {
            bl = true;
        }
        if (!bl) {
            string3 = string2 + "/" + string2 + ".map";
            string4 = HelpUtils.getLocalizedFilename(string + string3);
        }
        return string4;
    }

    public static void setDependencyProvider(HelpDependencyProvider helpDependencyProvider) {
        sDependencyProvider = helpDependencyProvider;
    }

    static HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    public static void setQE(boolean bl) {
        sTesting = bl;
        sHelpPath = null;
    }

    public static boolean isQE() {
        return sTesting;
    }

    public static void setQEHelpPath(String string) {
        sHelpPath = string;
    }

    public static String getQEHelpPath() {
        return sHelpPath;
    }

    public static class DefaultDocRootProvider
    implements HelpDependencyProvider {
        @Override
        public String getHelpLocationForShortName(String string) {
            return FunctionReferenceUtils.getHelpLocation(string);
        }

        @Override
        public String getDocRoot() {
            return MLHelpServices.getDocRoot();
        }
    }

    public static interface HelpDependencyProvider {
        public String getHelpLocationForShortName(String var1);

        public String getDocRoot();
    }
}

