/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPanelJarFileLinkListener;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ReferencePageInfo;
import com.mathworks.mlwidgets.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.html.HTMLBrowserToolbar;
import com.mathworks.mlwidgets.html.HTMLCallbackProvider;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.JToolBar;

public class ClassicHelpPanel
extends MJPanel
implements HTMLCallbackProvider {
    private HTMLRenderer fHtmlRenderer;
    private JToolBar fToolbar;
    private HelpPanelJarFileLinkListener fJarFileLinkListener;
    private boolean fRemoveInfoMessageBar = true;
    private boolean fSuppressLoadForCurrentLocation = false;

    public ClassicHelpPanel() {
        this.setLayout(new BorderLayout());
        this.fHtmlRenderer = new HTMLRenderer();
        HelpPanelPageChangedListener helpPanelPageChangedListener = new HelpPanelPageChangedListener();
        this.fHtmlRenderer.addPageChangedListener(helpPanelPageChangedListener);
        this.fHtmlRenderer.setUseSystemBrowserForExternalLinks(true);
        this.fJarFileLinkListener = new HelpPanelJarFileLinkListener();
        this.fHtmlRenderer.addJarFileLinkListener(this.fJarFileLinkListener);
        this.fHtmlRenderer.setFileNotFoundTemplate(HTMLRenderer.getLocalizedFilename(Matlab.matlabRoot() + "/toolbox/local/helperr.html"));
        this.add((Component)((Object)this.fHtmlRenderer), "Center");
    }

    public HTMLRenderer getHTMLRenderer() {
        return this.fHtmlRenderer;
    }

    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fHtmlRenderer.addPageChangedListener(pageChangedListener);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fHtmlRenderer.setVisible(bl);
    }

    public void dispose() {
        this.fHtmlRenderer.removeJarFileLinkListener(this.fJarFileLinkListener);
        this.fHtmlRenderer.dispose();
    }

    public void addToolbar() {
        this.addToolbar((JToolBar)((Object)new HTMLBrowserToolbar(this.fHtmlRenderer)));
    }

    public void addToolbar(JToolBar jToolBar) {
        if (this.fToolbar != null) {
            this.remove(this.fToolbar);
        }
        this.fToolbar = jToolBar;
        jToolBar.setFloatable(false);
        this.add(jToolBar, "North");
    }

    public void removeToolbar() {
        if (this.fToolbar != null) {
            this.remove(this.fToolbar);
        }
    }

    public void setSuppressLoadForCurrentLocation(boolean bl) {
        this.fSuppressLoadForCurrentLocation = bl;
    }

    @Override
    public void setCurrentLocation(String string) {
        String string2 = HelpUtils.getPrefixForHtmlPath(string);
        string2 = ClassicHelpPanel.encodeUrlIfNecessary(string2);
        if (this.fSuppressLoadForCurrentLocation && HTMLUtils.compareFiles(string2, this.fHtmlRenderer.getCurrentLocation())) {
            return;
        }
        this.fHtmlRenderer.setCurrentLocation(string2);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray) {
        this.setCurrentLocationAndHighlightKeywords(string, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, CharsetDetectionStrategy charsetDetectionStrategy, String[] stringArray) {
        String string2 = HelpUtils.getPrefixForHtmlPath(string);
        if (FileUtils.fileExists((String)string2) && HTMLUtils.needsEncoding(string2)) {
            string2 = "file:///" + string2;
            string2 = string2.replaceAll("\\\\", "/");
        }
        string2 = ClassicHelpPanel.encodeUrlIfNecessary(string2);
        this.fHtmlRenderer.setCurrentLocationAndHighlightKeywords(string2, charsetDetectionStrategy, stringArray);
    }

    public boolean showHelpPage(String string, String string2) {
        String string3;
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
        if (helpInfoItem != null && (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2)) != null) {
            this.setCurrentLocation(string3);
            return true;
        }
        return false;
    }

    public boolean showHelpPageForFullProductName(String string, String string2) {
        String string3;
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByName(string);
        if (helpInfoItem != null && (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2)) != null) {
            this.setCurrentLocation(string3);
            return true;
        }
        return false;
    }

    public void showHelpPageAndHighlightKeywords(String string, String string2, String[] stringArray) {
        this.showHelpPageAndHighlightKeywords(string, string2, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray);
    }

    public void showHelpPageAndHighlightKeywords(String string, String string2, CharsetDetectionStrategy charsetDetectionStrategy, String[] stringArray) {
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
        if (helpInfoItem != null) {
            String string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2);
            this.setCurrentLocationAndHighlightKeywords(string3, charsetDetectionStrategy, stringArray);
        }
    }

    public boolean showProductPage(String string) {
        String string2;
        if (string != null && string.length() != 0 && (string2 = HelpInfo.getProductPageForShortName(string)) != null) {
            this.setCurrentLocation(string2);
            return true;
        }
        return false;
    }

    public boolean showReferencePage(String string) {
        return this.showReferencePage(string, false);
    }

    public boolean showReferencePage(String string, boolean bl) {
        ReferencePageInfo[] referencePageInfoArray = HelpInfo.getAllReferencePageUrls(string, bl);
        if (referencePageInfoArray != null && referencePageInfoArray.length > 0) {
            boolean bl2;
            boolean bl3 = bl2 = referencePageInfoArray.length > 1 && ClassicHelpPanel.shouldDisplayOverloads(string);
            if (bl2) {
                this.fRemoveInfoMessageBar = false;
            }
            this.fHtmlRenderer.setCurrentLocation(referencePageInfoArray[0].getFullUrl());
            if (bl2) {
                InfoMessageBar infoMessageBar = new InfoMessageBar(string, referencePageInfoArray);
                infoMessageBar.addToBrowser();
            }
            return true;
        }
        return false;
    }

    private static boolean shouldDisplayOverloads(String string) {
        return !string.contains(".") && !string.contains("/");
    }

    public void addMouseOverLinkListener(ActionListener actionListener) {
        this.fHtmlRenderer.addMouseOverLinkListener(actionListener);
    }

    public void removeMouseOverLinkListener(ActionListener actionListener) {
        this.fHtmlRenderer.removeMouseOverLinkListener(actionListener);
    }

    @Override
    public String getCurrentLocation() {
        return this.fHtmlRenderer.getCurrentLocation();
    }

    @Override
    public void setHtmlText(String string) {
        this.fHtmlRenderer.setHtmlText(string);
    }

    public void setHtmlTextAndHighlightKeywords(String string, String[] stringArray) {
        this.fHtmlRenderer.setHtmlTextAndHighlightKeywords(string, stringArray);
    }

    @Override
    public String getHtmlText() {
        return this.fHtmlRenderer.getHtmlText();
    }

    public void displayTopic(String string, String string2) {
        if (string != null) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            this.doDisplayTopic(cSHelpTopicMap, string2);
        }
    }

    private void doDisplayTopic(CSHelpTopicMap cSHelpTopicMap, String string) {
        if (cSHelpTopicMap.exists()) {
            String string2 = cSHelpTopicMap.mapID(string);
            if (string2 != null) {
                this.setCurrentLocation(string2);
            } else {
                this.setHtmlText(this.fHtmlRenderer.getFileNotFoundText(string + " in " + cSHelpTopicMap.getFilePath()));
            }
        } else {
            this.setHtmlText(this.fHtmlRenderer.getFileNotFoundText(cSHelpTopicMap.getFilePath()));
        }
    }

    public boolean placeFocusInBrowser() {
        return this.fHtmlRenderer != null && this.fHtmlRenderer.requestFocusInWindow();
    }

    @Override
    public boolean canExecuteScripts() {
        return this.fHtmlRenderer.canExecuteScripts();
    }

    @Override
    public boolean canModifyDom() {
        return this.fHtmlRenderer.canModifyDom();
    }

    @Override
    public void executeScript(String string) {
        this.fHtmlRenderer.executeScript(string);
    }

    @Override
    public String executeScriptWithReturn(String string) {
        return this.fHtmlRenderer.executeScriptWithReturn(string);
    }

    @Override
    public void setElementText(String string, String string2) {
        this.fHtmlRenderer.setElementText(string, string2);
    }

    @Override
    public String getElementText(String string) {
        return this.fHtmlRenderer.getElementText(string);
    }

    private static String encodeUrlIfNecessary(String string) {
        block3: {
            if (HTMLUtils.needsEncoding(string)) {
                try {
                    return HTMLUtils.encodeUrl(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"We should always be able to encode URLs using UTF-8");
                }
            }
        }
        return string;
    }

    private class HelpPanelPageChangedListener
    implements PageChangedListener {
        private HelpPanelPageChangedListener() {
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            if (ClassicHelpPanel.this.fRemoveInfoMessageBar) {
                ClassicHelpPanel.this.fHtmlRenderer.removeInfoMessageBar();
            }
            ClassicHelpPanel.this.fRemoveInfoMessageBar = true;
        }
    }

    private class InfoMessageBar {
        private String fFuncName;
        private ReferencePageInfo[] fUrls;
        private String fMessage;
        private HyperlinkTextLabel.HyperlinkHandler fHyperlinkHandler;

        InfoMessageBar(String string, ReferencePageInfo[] referencePageInfoArray) {
            this.fFuncName = string;
            this.fUrls = referencePageInfoArray;
            this.createMessage(false);
            this.fHyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                    if (string.equals("more")) {
                        InfoMessageBar.this.createMessage(true);
                        ClassicHelpPanel.this.fHtmlRenderer.addInfoMessageBar(InfoMessageBar.this.fMessage, InfoMessageBar.this.fHyperlinkHandler);
                    } else {
                        ClassicHelpPanel.this.fRemoveInfoMessageBar = false;
                        ClassicHelpPanel.this.fHtmlRenderer.setCurrentLocation(string);
                    }
                }
            };
        }

        public void addToBrowser() {
            ClassicHelpPanel.this.fHtmlRenderer.addInfoMessageBar(this.fMessage, this.fHyperlinkHandler);
        }

        public String getMessage() {
            return this.fMessage;
        }

        public HyperlinkTextLabel.HyperlinkHandler getHyperlinkHandler() {
            return this.fHyperlinkHandler;
        }

        private void createMessage(boolean bl) {
            int n = this.fUrls.length - 1;
            StringBuilder stringBuilder = new StringBuilder("<html>").append(HelpUtils.getLocalizedString("infobar.message"));
            stringBuilder.append(' ').append(HTMLUtils.createHyperlink(this.fUrls[0].getFullUrl(), this.fFuncName)).append(": ");
            if (n > 2) {
                stringBuilder.append("<br>");
            }
            int n2 = this.fUrls.length;
            if (!bl && this.fUrls.length > 5) {
                n2 = 5;
            }
            int n3 = 0;
            for (int i = 1; i < n2; ++i) {
                String string;
                if (i > 1) {
                    stringBuilder.append(", ");
                }
                if (n3 == 5) {
                    stringBuilder.append("<br>");
                    n3 = 0;
                }
                if ((string = this.fUrls[i].getEntityName()) == null) {
                    string = this.fFuncName;
                }
                stringBuilder.append(HTMLUtils.createHyperlink(this.fUrls[i].getFullUrl(), this.fUrls[i].getShortName() + "/" + string));
                ++n3;
            }
            if (!bl && this.fUrls.length > 5) {
                stringBuilder.append(", ");
                stringBuilder.append(HTMLUtils.createHyperlink("more", HelpUtils.getLocalizedString("infobar.more") + "..."));
            }
            stringBuilder.append("</html>");
            this.fMessage = stringBuilder.toString();
        }
    }
}

