/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.ResourceBundle;

class DocCenterRoot {
    private static final ResourceBundle sResDocCenter = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_DocCenterInfo_notranslation");
    private static final String DEFAULT_DOMAIN = WSEndPoints.getMathWorksEndPoint() + "/";
    private static final String RELEASE_LOCATION = sResDocCenter.getString("help.releases");
    private static final String SEARCH_LOCATION = sResDocCenter.getString("help.search");
    private static final String SEARCH_RESULTS_TEMPLATE = sResDocCenter.getString("help.searchresults.template");
    private String fDocCenterDomain = DEFAULT_DOMAIN;
    private String fDocRoot;
    private String fDocWebRoot;

    DocCenterRoot() {
        this.updateDocRoot();
        this.updateDocWebRoot();
    }

    String getContentDocRoot() {
        if (!HelpPrefs.isUsingDocCenterBrowser()) {
            return this.getDocRoot();
        }
        DocLocation docLocation = HelpPrefs.getDocCenterLocation();
        switch (docLocation) {
            case WEB: {
                return this.getDocWebRoot();
            }
            case INSTALLED: {
                return this.getDocRoot();
            }
        }
        return null;
    }

    void setContentDocRoot(String string) {
        if (!HelpPrefs.isUsingDocCenterBrowser()) {
            this.setDocRoot(string);
        } else if (HelpBrowserUtils.isWebAddress((String)string)) {
            this.setDocWebRoot(string);
        } else {
            this.setDocRoot(string);
        }
    }

    String getDocRoot() {
        return this.fDocRoot;
    }

    private void updateDocRoot() {
        this.fDocRoot = Matlab.matlabRoot() + File.separator + "help";
        this.fDocRoot = HTMLUtils.getCanonicalFilepath(this.fDocRoot);
        if (PlatformInfo.isWindows()) {
            this.fDocRoot = this.fDocRoot.replace('\\', '/');
        }
    }

    void setDocRoot(String string) {
        assert (string != null && !HelpBrowserUtils.isWebAddress((String)string));
        this.fDocRoot = string;
    }

    String getDocWebRoot() {
        return this.fDocWebRoot;
    }

    private void updateDocWebRoot() {
        this.setDocWebRoot(this.getDocCenterDomain() + DocCenterRoot.getDefaultDocCenterReleasePath());
    }

    private void setDocWebRoot(String string) {
        assert (string != null && HelpBrowserUtils.isWebAddress((String)string));
        this.fDocWebRoot = string;
    }

    String getDocCenterSearchPath() {
        DocLocation docLocation = HelpPrefs.getDocCenterLocation();
        String string = "";
        switch (docLocation) {
            case WEB: {
                string = this.getDocCenterDomain() + DocCenterRoot.getDefaultDocCenterSearchLocation();
                break;
            }
            case INSTALLED: {
                StringBuilder stringBuilder = new StringBuilder("file://");
                if (PlatformInfo.isWindows()) {
                    stringBuilder.append("/");
                }
                string = stringBuilder.toString() + this.getDocRoot() + "/" + SEARCH_RESULTS_TEMPLATE;
            }
        }
        return string;
    }

    private static String getDefaultDocCenterSearchLocation() {
        return SEARCH_LOCATION + HelpUtils.getWebSearchDirectoryName() + "/" + HelpPrefs.DEFAULT_DOC_RELEASE;
    }

    private static String getDefaultDocCenterReleasePath() {
        return RELEASE_LOCATION + HelpPrefs.DEFAULT_DOC_RELEASE + "/";
    }

    boolean setDocCenterDomain(String string) {
        if (string == null) {
            return false;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.fDocCenterDomain = string;
        this.updateDocWebRoot();
        return true;
    }

    String getDocCenterDomain() {
        return this.fDocCenterDomain;
    }
}

