/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopicMapLocator {
    private static final String LOCATOR_FILE_NAME = "topicmaps.loc";
    private static final TopicMapLocator sTheLocator = new TopicMapLocator();
    private LocatorMapCache fLocatorMapCache = new LocatorMapCache();

    private TopicMapLocator() {
    }

    private LocatorMapCache getLocatorMapCache() {
        return this.fLocatorMapCache;
    }

    public static String getMapPath(String string) {
        return TopicMapLocator.getLocatorMap().get(string);
    }

    public static String[] getMapKeys() {
        Set<String> set = TopicMapLocator.getLocatorMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static String[] getMapPaths() {
        Collection<String> collection = TopicMapLocator.getLocatorMap().values();
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] getMapKeysStartingWith(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : TopicMapLocator.getLocatorMap().keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void addTestCase(String string, String string2) {
        TopicMapLocator.getLocatorMap().put(string, string2);
    }

    private static Map<String, String> getLocatorMap() {
        return TopicMapLocator.sTheLocator.getLocatorMapCache().getLocatorMap(false);
    }

    public static void rebuild() {
        sTheLocator.getLocatorMapCache().rebuild();
    }

    private static Set<String> getInstalledProducts() {
        List<String> list = HelpUtils.getDependencyProvider().getInstalledProductShortNames();
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            hashSet.add(list.get(i) + ':');
        }
        return hashSet;
    }

    private static class LocatorMapCache {
        private Map<String, String> fMap;
        private PrefListener fDocrootChangeListener;

        private LocatorMapCache() {
        }

        private synchronized Map<String, String> getLocatorMap(boolean bl) {
            if (this.fMap == null || bl) {
                this.fMap = this.buildMap();
            }
            return this.fMap;
        }

        private Map<String, String> buildMap() {
            if (this.fDocrootChangeListener == null) {
                this.fDocrootChangeListener = new PrefListener(){

                    public void prefChanged(PrefEvent prefEvent) {
                        LocatorMapCache.this.rebuild();
                    }
                };
                HelpPrefs.addPrefsListeners(this.fDocrootChangeListener, "HelpDocRoot");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Set set = TopicMapLocator.getInstalledProducts();
            String string = LocatorMapCache.getDocroot() + TopicMapLocator.LOCATOR_FILE_NAME;
            if (!HelpUtils.isEnglish()) {
                LocatorMapCache.readTopicMapFile(HelpUtils.getLocalizedFilename(string), hashMap, set);
            }
            LocatorMapCache.readTopicMapFile(string, hashMap, set);
            return hashMap;
        }

        private static String getDocroot() {
            String string = HelpUtils.getDependencyProvider().getDocRoot();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return string;
        }

        private static void readTopicMapFile(String string, Map<String, String> map, Set<String> set) {
            try {
                LocatorMapCache.doReadTopicMapFile(string, map, set);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doReadTopicMapFile(String string, Map<String, String> map, Set<String> set) throws IOException {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                while (bufferedReader.ready()) {
                    LocatorMapCache.readMapLine(bufferedReader, map, set);
                }
            }
            finally {
                bufferedReader.close();
            }
        }

        private static void readMapLine(BufferedReader bufferedReader, Map<String, String> map, Set<String> set) {
            try {
                String string = bufferedReader.readLine();
                String[] stringArray = string.split("\\s+");
                if (stringArray.length > 2 && set.contains(stringArray[0]) && !map.containsKey(stringArray[1])) {
                    map.put(stringArray[1], LocatorMapCache.getDocroot() + stringArray[2]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void rebuild() {
            this.getLocatorMap(true);
        }
    }
}

