/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchEngine;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.SuggestionObserver;
import com.mathworks.mlwidgets.help.search.lucene.LuceneDocSearchEngine;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class DocSearchEngine
implements SearchEngine<DocSearchResult> {
    private static DocSearchEngine sSingleton = null;

    protected DocSearchEngine() {
        if (Matlab.isMatlabAvailable()) {
            HelpInfo.addHelpInfoChangedListener(new HelpInfoListener());
        }
        HelpPrefs.addPrefsListeners(new HelpPrefsListener(), "HelpSelectedProducts", "HelpFilterEnabled");
    }

    protected abstract SearchResults<DocSearchResult> synchronousSearch(SearchCriteria var1) throws SearchException;

    public static synchronized void initialize() {
        if (sSingleton == null) {
            LuceneDocSearchEngine luceneDocSearchEngine = new LuceneDocSearchEngine();
            luceneDocSearchEngine.loadIndexes();
            sSingleton = luceneDocSearchEngine;
        }
    }

    public static synchronized boolean isInitialized() {
        return sSingleton != null;
    }

    public static synchronized DocSearchEngine getInstance() {
        if (!DocSearchEngine.isInitialized()) {
            DocSearchEngine.initialize();
        }
        return sSingleton;
    }

    public abstract void refresh(boolean var1);

    public abstract void suggestCommonTerms(String var1, SuggestionObserver var2, int var3);

    public abstract boolean isCleanedUp();

    private class HelpPrefsListener
    implements PrefListener {
        private HelpPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            DocSearchEngine.this.refresh(false);
        }
    }

    private class HelpInfoListener
    implements ActionListener {
        private HelpInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DocSearchEngine.this.refresh(true);
        }
    }
}

