/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.HTMLRendererSupport;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.PDFFileHandler;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class DefaultPDFFileHandler
implements PDFFileHandler {
    private static Matlab sMatlab = new Matlab();
    private Frame fFrame;
    private HTMLRendererSupport fRenderer;

    public DefaultPDFFileHandler(HTMLRendererSupport hTMLRendererSupport) {
        this.fRenderer = hTMLRendererSupport;
    }

    @Override
    public void open(Frame frame, String string) {
        this.fFrame = frame;
        if (sMatlab != null && Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabReady((Runnable)new OpenPDFFile(string));
        }
    }

    private void fireUpPdfReader(String string) {
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (PlatformInfo.isWindows()) {
            string = string.replace('/', '\\');
        }
        Object[] objectArray = new Object[]{string, "1"};
        this.fRenderer.setWaitCursor(true);
        sMatlab.feval("uiopen", objectArray, (CompletionObserver)new PDFCompletionObserver());
    }

    private class PDFCompletionObserver
    implements CompletionObserver {
        public void completed(int n, Object object) {
            DefaultPDFFileHandler.this.fRenderer.setWaitCursor(false);
        }
    }

    private class OpenPDFFile
    implements Runnable {
        private String fLocation;

        public OpenPDFFile(String string) {
            this.fLocation = string;
        }

        @Override
        public void run() {
            String string = HTMLUtils.getCanonicalUrl(this.fLocation);
            if (string.startsWith("http:") && sMatlab != null) {
                sMatlab.feval("tempname", null, (CompletionObserver)new OpenPdfFileFromWebserver(string));
            } else {
                DefaultPDFFileHandler.this.fireUpPdfReader(string);
            }
        }

        private class OpenPdfFileFromWebserver
        implements CompletionObserver {
            private String fFilename;

            public OpenPdfFileFromWebserver(String string) {
                this.fFilename = string;
            }

            public void completed(int n, Object object) {
                String string = (String)object;
                if (string != null) {
                    URL uRL;
                    String string2 = string.trim();
                    String string3 = string2 + ".pdf";
                    File file = new File(string3);
                    try {
                        uRL = new URL(this.fFilename);
                    }
                    catch (MalformedURLException malformedURLException) {
                        MJOptionPane.showMessageDialog((Component)DefaultPDFFileHandler.this.fFrame, (Object)HTMLUtils.sRes.getString("alert.error_with_pdf_file"), (String)HTMLUtils.sRes.getString("alert.alert_title"), (int)2);
                        return;
                    }
                    try {
                        InputStream inputStream = uRL.openStream();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        FileUtils.copyStream((InputStream)inputStream, (OutputStream)fileOutputStream);
                        inputStream.close();
                        ((OutputStream)fileOutputStream).close();
                        DefaultPDFFileHandler.this.fireUpPdfReader(string3);
                    }
                    catch (IOException iOException) {
                        sMatlab.evalConsoleOutput("web('" + this.fFilename + "', '-browser')");
                    }
                }
            }
        }
    }
}

