/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.RequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.JarFileLinkListener;
import com.mathworks.mlwidgets.html.LinkClickedHandler;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.SystemBrowserRequestHandler;
import java.util.Map;
import java.util.WeakHashMap;

public class HtmlConversionUtils {
    private static final Map<LinkClickedHandler, LinkClickedRequestHandler> LINK_HANDLERS = new WeakHashMap<LinkClickedHandler, LinkClickedRequestHandler>();

    public static void useSystemBrowserForExternalLinks(HtmlComponent htmlComponent) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.addRequestHandler(new SystemBrowserRequestHandler());
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.setUseSystemBrowserForExternalLinks(true);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void addJarFileLinkListener(HtmlComponent htmlComponent, final JarFileLinkListener jarFileLinkListener) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.addJarFileLinkListener(jarFileLinkListener);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void removeJarFileLinkListener(HtmlComponent htmlComponent, final JarFileLinkListener jarFileLinkListener) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.removeJarFileLinkListener(jarFileLinkListener);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void addLinkClickedHandler(HtmlComponent htmlComponent, final LinkClickedHandler linkClickedHandler) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                LinkClickedRequestHandler linkClickedRequestHandler = new LinkClickedRequestHandler(linkClickedHandler);
                LINK_HANDLERS.put(linkClickedHandler, linkClickedRequestHandler);
                mJHtmlPanel.addRequestHandler(linkClickedRequestHandler);
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.setLinkClickedHandler(linkClickedHandler);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void removeLinkClickedHandler(HtmlComponent htmlComponent, final LinkClickedHandler linkClickedHandler) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.removeLinkClickedHandler(linkClickedHandler);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void clearBrowser(HtmlComponent htmlComponent) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.setCurrentLocation("about:blank");
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.clearBrowser();
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void setFileNotFoundTemplate(HtmlComponent htmlComponent, final String string) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                hTMLRenderer.setFileNotFoundTemplate(string);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void setFileNotFoundText(HtmlComponent htmlComponent, final String string) {
        BrowserVisitor browserVisitor = new BrowserVisitor(){

            @Override
            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            }

            @Override
            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                String string2 = hTMLRenderer.getFileNotFoundText(string);
                hTMLRenderer.setHtmlText(string2);
            }
        };
        HtmlConversionUtils.visitBrowser(htmlComponent, browserVisitor);
    }

    public static void visitBrowser(HtmlComponent htmlComponent, BrowserVisitor browserVisitor) {
        if (htmlComponent instanceof MJHtmlPanel) {
            browserVisitor.visitMJHtmlPanel((MJHtmlPanel)htmlComponent);
        } else if (htmlComponent instanceof HtmlComponentAdapter) {
            HTMLRenderer hTMLRenderer = (HTMLRenderer)((Object)htmlComponent.getComponent());
            browserVisitor.visitHTMLRenderer(hTMLRenderer);
        }
    }

    public static interface BrowserVisitor {
        public void visitMJHtmlPanel(MJHtmlPanel var1);

        public void visitHTMLRenderer(HTMLRenderer var1);
    }

    private static class LinkClickedRequestHandler
    implements RequestHandler {
        private final LinkClickedHandler fHandler;

        private LinkClickedRequestHandler(LinkClickedHandler linkClickedHandler) {
            this.fHandler = linkClickedHandler;
        }

        public boolean handleRequest(BrowserRequest browserRequest) {
            if (browserRequest.getOrigin() == BrowserRequest.Origin.USER_INTERACTION && !browserRequest.isTargetOnly()) {
                this.fHandler.linkClicked(browserRequest.getUrl());
                return true;
            }
            return false;
        }
    }
}

