/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.MJLabel;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;

public class DateConversionRule
extends WorksheetRule {
    protected double fReplacementNumber;

    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.CONVERT;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.CONVERT;
    }

    @Override
    public Object clone() {
        DateConversionRule dateConversionRule = new DateConversionRule();
        dateConversionRule.fReplacementNumber = this.fReplacementNumber;
        return dateConversionRule;
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.dateconvertsummary");
    }

    @Override
    public boolean codeGenUsesDates() {
        return true;
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.dateconvertheading"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(" = ~cellfun(@isequalwithequalnans,");
        generatedCode.addCode(generatedCode.getDateArray());
        generatedCode.addCode(",");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode(") & cellfun('isclass',");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode(",'char'); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.exceldates"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(") = ");
        generatedCode.addCode(generatedCode.getDateArray());
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(");\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("excelDateFunctionFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.dates");
    }

    @Override
    Component getEditor() {
        MJLabel mJLabel = new MJLabel("datenum");
        mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        return mJLabel;
    }
}

