/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.FixedWidthDragWindow;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.TextCellRenderer;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextTableHeaderRenderer;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FixedWidthPane
extends MJComponent {
    private static int RESIZE_REGION_SIZE = 2;
    private static final Cursor fResizeCursor = new Cursor(10);
    private static final Cursor fVerticalResizeCursor = new Cursor(8);
    private static ImageIcon fFixedWidthMoveIcon = new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/mlwidgets/importtool/resources/moveFixedWidthCursor.png"));
    private static ImageIcon fFixedWidthAddIcon = new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/mlwidgets/importtool/resources/addFixedWidth.png"));
    private static final Cursor fMoveCursor = Toolkit.getDefaultToolkit().createCustomCursor(fFixedWidthMoveIcon.getImage(), new Point(16, 16), "FixedWidthMoveCursor");
    private static final Cursor fDefaultCursor = new Cursor(0);
    private static final Cursor fTextCursor = new Cursor(2);
    private boolean fFixedCharacterMoving = false;
    private FixedWidthDragWindow fFixedWidthMoveWindow;
    private int fFixedWidthMoveStartCharacterPosition = -1;
    private FixedWidthMouseAdapter fMouseAdapter = null;
    private FixedWidthComponentListener fComponentListener;
    private FixedWidthPane fSelf = this;
    private int fMovingColumn = -1;
    private boolean fDragCanceled = false;
    private boolean fVoidActions = false;
    private boolean fOverLeftAddRegion = false;
    private boolean fOverRightAddRegion = false;
    private JRootPane fRootPane;
    private TextTable fWorksheetTable;
    private TextTableHeaderRenderer fHeaderRenderer;
    private ImportTable.ImportTableHeader fTableHeader;
    private Color fOriginalGridColor;
    private Dimension fOriginalCellSpacing;
    private Component fPreviousComponent;
    private MJPopupMenu fCurrentPopup;
    private Point fTooltipLocation = null;
    private BufferedImage fBufferedImage = null;
    private boolean fShowBufferedImage = false;
    private int fBufferedImageCounter = 0;
    private String fLastTooltipText;
    public static final Stroke FIXED_WIDTH_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 3.0f}, 0.0f);

    public FixedWidthPane(JRootPane jRootPane, TextTable textTable) {
        this(jRootPane, textTable, (TextTableHeaderRenderer)((Object)textTable.getTableHeader().getDefaultRenderer()), (ImportTable.ImportTableHeader)textTable.getTableHeader());
    }

    public FixedWidthPane(JRootPane jRootPane, TextTable textTable, TextTableHeaderRenderer textTableHeaderRenderer, ImportTable.ImportTableHeader importTableHeader) {
        this.fRootPane = jRootPane;
        this.fWorksheetTable = textTable;
        this.fHeaderRenderer = textTableHeaderRenderer;
        this.fTableHeader = importTableHeader;
        this.fMouseAdapter = new FixedWidthMouseAdapter();
        this.fComponentListener = new FixedWidthComponentListener();
        this.fWorksheetTable.addComponentListener(this.fComponentListener);
        if (this.fRootPane != null) {
            this.fRootPane.addComponentListener(this.fComponentListener);
        }
        this.fOriginalCellSpacing = this.fWorksheetTable.getIntercellSpacing();
        this.fOriginalGridColor = this.fWorksheetTable.getGridColor();
        this.setFocusable(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.removeMouseListener(this.fMouseAdapter);
        this.removeMouseMotionListener(this.fMouseAdapter);
        this.removeKeyListener(this.fMouseAdapter);
        this.removeMouseWheelListener(this.fMouseAdapter);
        if (bl) {
            this.fWorksheetTable.setIntercellSpacing(new Dimension(0, this.fOriginalCellSpacing.height));
            this.addMouseListener(this.fMouseAdapter);
            this.addMouseMotionListener(this.fMouseAdapter);
            this.addMouseWheelListener(this.fMouseAdapter);
            this.addKeyListener(this.fMouseAdapter);
        } else {
            this.fWorksheetTable.setIntercellSpacing(this.fOriginalCellSpacing);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.fBufferedImage == null || !this.fShowBufferedImage) {
            Rectangle rectangle = this.fWorksheetTable.getVisibleRect();
            Rectangle rectangle2 = this.fTableHeader.getVisibleRect();
            Image image = fFixedWidthAddIcon.getImage();
            int n = fFixedWidthAddIcon.getIconWidth();
            int n2 = fFixedWidthAddIcon.getIconHeight();
            Point point = new Point(rectangle.x, rectangle.y);
            point = SwingUtilities.convertPoint((Component)((Object)this.fWorksheetTable), point, (Component)((Object)this));
            point = new Point(rectangle.x + rectangle.width, rectangle.y);
            point = SwingUtilities.convertPoint((Component)((Object)this.fWorksheetTable), point, (Component)((Object)this));
        } else {
            graphics2D.drawImage((Image)this.fBufferedImage, 0, 0, (ImageObserver)((Object)this));
        }
    }

    public void bufferRootPaneImage() {
        this.fBufferedImage = new BufferedImage(this.fRootPane.getWidth(), this.fRootPane.getHeight(), 1);
        this.fRootPane.paintAll(this.fBufferedImage.getGraphics());
    }

    public void bufferScreenUntilTableUpdate() {
        if (this.fBufferedImage == null) {
            this.bufferRootPaneImage();
        }
        this.fShowBufferedImage = true;
        ++this.fBufferedImageCounter;
        this.fWorksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                FixedWidthPane.this.fWorksheetTable.getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                FixedWidthPane.this.fBufferedImageCounter--;
                if (FixedWidthPane.this.fBufferedImageCounter <= 0) {
                    FixedWidthPane.this.fBufferedImage = null;
                    FixedWidthPane.this.fBufferedImageCounter = 0;
                    FixedWidthPane.this.fShowBufferedImage = false;
                    FixedWidthPane.this.closeDragWindow();
                    FixedWidthPane.this.fDragCanceled = false;
                }
            }
        });
    }

    private void setMoveColumn(MouseEvent mouseEvent) {
        Point point = this.getConvertedPoint(mouseEvent.getPoint());
        int n = this.fWorksheetTable.columnAtPoint(new Point(point.x + 2 * RESIZE_REGION_SIZE, point.y));
        if (n < 0) {
            n = 0;
        }
        this.fMovingColumn = n;
    }

    private boolean isAddRegion(Point point) {
        Point point2 = this.getConvertedPoint(point);
        Rectangle rectangle = this.fWorksheetTable.getVisibleRect();
        return Math.abs(point2.x - rectangle.x) <= RESIZE_REGION_SIZE || Math.abs(point2.x - (rectangle.x + rectangle.width)) <= RESIZE_REGION_SIZE;
    }

    public boolean isTableHorizontalResizePoint(Point point) {
        return this.isTableHorizontalResizePoint(point, true);
    }

    public boolean isTableHorizontalResizePoint(Point point, boolean bl) {
        int n;
        Point point2 = this.getTablePoint(point);
        Rectangle rectangle = this.fWorksheetTable.getVisibleRect();
        int n2 = this.fWorksheetTable.rowAtPoint(point2);
        int n3 = this.fWorksheetTable.columnAtPoint(point2);
        if (Math.abs(point2.x - rectangle.x) <= RESIZE_REGION_SIZE || Math.abs(point2.x - (rectangle.x + rectangle.width)) <= RESIZE_REGION_SIZE) {
            Point point3 = new Point(point2.x - 2 * RESIZE_REGION_SIZE - 1, point2.y);
            Point point4 = new Point(point2.x + 2 * RESIZE_REGION_SIZE + 1, point2.y);
            int n4 = this.fWorksheetTable.columnAtPoint(point3);
            n = this.fWorksheetTable.rowAtPoint(point3);
            int n5 = this.fWorksheetTable.columnAtPoint(point4);
            int n6 = this.fWorksheetTable.rowAtPoint(point4);
            if (!this.fWorksheetTable.isCellSelected(n, n4) && !this.fWorksheetTable.isCellSelected(n6, n5)) {
                return true;
            }
            if (!bl) {
                return true;
            }
        }
        if (rectangle.contains(point2)) {
            int n7 = n3;
            if (n3 - 1 >= 0) {
                n7 = n3 - 1;
            }
            int n8 = n3;
            if (n3 + 1 < this.fWorksheetTable.getColumnCount()) {
                n8 = n3 + 1;
            }
            Point point5 = new Point(point.x, point.y);
            SwingUtilities.convertPointToScreen(point5, (Component)((Object)this));
            n = this.fWorksheetTable.getCharacterPositionForLocationOnScreen(point5);
            if (this.fWorksheetTable.characterPositionSplitExists(n) && !this.fWorksheetTable.isCellSelected(n2, n8) && !this.fWorksheetTable.isCellSelected(n2, n3) && this.fWorksheetTable.characterPositionSplitExists(n) && !this.fWorksheetTable.isCellSelected(n2, n7) && !this.fWorksheetTable.isCellSelected(n2, n3)) {
                return true;
            }
            if (!bl && (this.fWorksheetTable.characterPositionSplitExists(n) && !this.fWorksheetTable.isCellSelected(n2, n8) && this.fWorksheetTable.isCellSelected(n2, n3) || this.fWorksheetTable.characterPositionSplitExists(n) && this.fWorksheetTable.isCellSelected(n2, n8) && !this.fWorksheetTable.isCellSelected(n2, n3) || this.fWorksheetTable.characterPositionSplitExists(n) && !this.fWorksheetTable.isCellSelected(n2, n7) && this.fWorksheetTable.isCellSelected(n2, n3) || this.fWorksheetTable.characterPositionSplitExists(n) && this.fWorksheetTable.isCellSelected(n2, n7) && !this.fWorksheetTable.isCellSelected(n2, n3))) {
                return true;
            }
        }
        return false;
    }

    public boolean isHeaderResizePoint(Point point) {
        TextTableHeaderRenderer textTableHeaderRenderer;
        Point point2 = this.getHeaderPoint(point);
        Point point3 = this.getTablePoint(point);
        if (this.fTableHeader.getVisibleRect().contains(point2) && this.fTableHeader.getDefaultRenderer() instanceof TextTableHeaderRenderer && (textTableHeaderRenderer = (TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).isFixedWidth()) {
            int n = textTableHeaderRenderer.getRulerLabelHeight();
            if (point2.y > this.fTableHeader.getHeight() - n) {
                Point point4 = new Point(point.x, point.y);
                SwingUtilities.convertPointToScreen(point4, (Component)((Object)this));
                int n2 = this.fWorksheetTable.getCharacterPositionForLocationOnScreen(point4);
                if (this.fWorksheetTable.characterPositionSplitExists(n2)) {
                    return true;
                }
                Rectangle rectangle = this.fWorksheetTable.getVisibleRect();
                if (rectangle.x + rectangle.width - point3.x <= RESIZE_REGION_SIZE) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isHeaderAddPoint(Point point) {
        TextTableHeaderRenderer textTableHeaderRenderer;
        if (this.isHeaderResizePoint(point)) {
            return false;
        }
        Point point2 = this.getHeaderPoint(point);
        Point point3 = this.getTablePoint(point);
        if (this.fTableHeader.getVisibleRect().contains(point2) && this.fTableHeader.getDefaultRenderer() instanceof TextTableHeaderRenderer && (textTableHeaderRenderer = (TextTableHeaderRenderer)((Object)this.fTableHeader.getDefaultRenderer())).isFixedWidth()) {
            int n = textTableHeaderRenderer.getRulerLabelHeight();
            if (point2.y > this.fTableHeader.getHeight() - n) {
                return true;
            }
        }
        return false;
    }

    public Point getTablePoint(Point point) {
        Point point2 = SwingUtilities.convertPoint((Component)((Object)this.fSelf), point, (Component)((Object)this.fWorksheetTable));
        return point2;
    }

    public Point getHeaderPoint(Point point) {
        Point point2 = SwingUtilities.convertPoint((Component)((Object)this.fSelf), point, this.fTableHeader);
        return point2;
    }

    public Point getConvertedPoint(Point point) {
        if (this.isTableHorizontalResizePoint(point)) {
            return this.getTablePoint(point);
        }
        if (this.isHeaderResizePoint(point)) {
            return this.getHeaderPoint(point);
        }
        return point;
    }

    public void closeDragWindow() {
        this.fDragCanceled = true;
        this.fVoidActions = false;
        if (this.fFixedWidthMoveWindow != null) {
            this.fFixedCharacterMoving = false;
            this.removeKeyListener(this.fMouseAdapter);
            this.fFixedWidthMoveWindow.setVisible(false);
            this.fFixedWidthMoveWindow = null;
            this.fFixedWidthMoveStartCharacterPosition = -1;
            this.fMovingColumn = -1;
        }
        ((TextTable)((Object)this.fTableHeader.getTable())).setDragSelectionEnabled(true);
        this.requestFocus();
        this.requestFocusInWindow();
    }

    private void setupAndShowFixedWidthWindow(MouseEvent mouseEvent) {
        this.fDragCanceled = false;
        int n = ((TextTable)((Object)this.fTableHeader.getTable())).getCharacterPositionForLocationOnScreen(mouseEvent.getLocationOnScreen());
        boolean bl = this.isAddRegion(mouseEvent.getPoint());
        this.fFixedWidthMoveWindow = new FixedWidthDragWindow(this, this.fWorksheetTable, bl);
        this.setFixedDragWindowLocation(mouseEvent);
        this.fFixedWidthMoveWindow.setVisible(true);
        this.fFixedWidthMoveStartCharacterPosition = n;
        this.setFixedDragWindowLocation(mouseEvent);
        this.fFixedWidthMoveWindow.requestFocus();
        this.fFixedWidthMoveWindow.requestFocusInWindow();
        this.setMoveColumn(mouseEvent);
    }

    private void setFixedDragWindowLocation(MouseEvent mouseEvent) {
        Cloneable cloneable;
        int n;
        Point point;
        Point point2;
        Rectangle rectangle = this.fWorksheetTable.getVisibleRect();
        if (!rectangle.contains(point2 = this.getTablePoint(point = mouseEvent.getPoint()))) {
            n = this.fWorksheetTable.columnAtPoint(point2);
            int n2 = this.fWorksheetTable.rowAtPoint(rectangle.getLocation());
            if (n >= 0) {
                cloneable = this.fWorksheetTable.getCellRect(n2, n, true);
                cloneable.y = rectangle.y;
                this.fWorksheetTable.scrollRectToVisible((Rectangle)cloneable);
            }
        }
        n = ((TextTable)((Object)this.fTableHeader.getTable())).getCharacterPositionForLocationOnScreen(mouseEvent.getLocationOnScreen());
        Point point3 = this.fWorksheetTable.getLocationOnScreenForCharacterPosition(n);
        cloneable = new Point(point3.x, this.fTableHeader.getLocationOnScreen().y + this.fTableHeader.getHeight());
        Rectangle rectangle2 = this.fWorksheetTable.getVisibleRect();
        Point point4 = new Point(rectangle2.x, rectangle2.y);
        Point point5 = new Point(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
        SwingUtilities.convertPointToScreen(point4, (Component)((Object)this.fWorksheetTable));
        SwingUtilities.convertPointToScreen(point5, (Component)((Object)this.fWorksheetTable));
        if (((Point)cloneable).x < point4.x) {
            ((Point)cloneable).x = point4.x;
        } else if (((Point)cloneable).x > point5.x) {
            ((Point)cloneable).x = point5.x;
        }
        this.fFixedWidthMoveWindow.setLocation((Point)cloneable);
    }

    private MJPopupMenu setupAndShowDeleteContextMenu(MouseEvent mouseEvent) {
        final int n = ((TextTable)((Object)this.fTableHeader.getTable())).getCharacterPositionForLocationOnScreen(mouseEvent.getLocationOnScreen());
        boolean bl = this.isAddRegion(mouseEvent.getPoint());
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        MJMenuItem mJMenuItem = new MJMenuItem(ImportToolUtils.getResourceString("ActionNames.deletecolumnsplitter"));
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FixedWidthPane.this.bufferScreenUntilTableUpdate();
                FixedWidthPane.this.fWorksheetTable.deleteColumnSplitter(n);
            }
        });
        mJPopupMenu.setVisible(true);
        mJPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
        this.setCurrentPopup(mJPopupMenu);
        return mJPopupMenu;
    }

    private MJPopupMenu setupAndShowColumnContextMenu(MouseEvent mouseEvent) {
        final int n = ((TextTable)((Object)this.fTableHeader.getTable())).getCharacterPositionForLocationOnScreen(mouseEvent.getLocationOnScreen());
        final Point point = this.getHeaderPoint(mouseEvent.getPoint());
        boolean bl = this.isAddRegion(mouseEvent.getPoint());
        final MJPopupMenu mJPopupMenu = new MJPopupMenu();
        final MJMenuItem mJMenuItem = new MJMenuItem(ImportToolUtils.getResourceString("ActionNames.addcolumnsplitter") + n);
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FixedWidthPane.this.bufferScreenUntilTableUpdate();
                FixedWidthPane.this.fWorksheetTable.addColumnSplitter(n);
            }
        });
        final MJMenuItem mJMenuItem2 = new MJMenuItem(ImportToolUtils.getResourceString("ActionNames.splitcolumn"));
        mJMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FixedWidthPane.this.bufferScreenUntilTableUpdate();
                FixedWidthPane.this.fWorksheetTable.splitColumnAtPoint(point);
            }
        });
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        mJPopupMenu.add((JMenuItem)mJMenuItem2);
        mJPopupMenu.setVisible(true);
        mJPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
        this.setCurrentPopup(mJPopupMenu);
        mJPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Point point = mJPopupMenu.getLocation();
                Point point2 = SwingUtilities.convertPoint((Component)mJPopupMenu, point, FixedWidthPane.this.fTableHeader.getTable());
                int n = FixedWidthPane.this.fTableHeader.getTable().columnAtPoint(point2);
                if (n >= 0) {
                    if (((TextTable)((Object)FixedWidthPane.this.fTableHeader.getTable())).getNumCharactersForColumn(n) > 1) {
                        mJMenuItem.setEnabled(true);
                        mJMenuItem2.setEnabled(true);
                    } else {
                        mJMenuItem.setEnabled(false);
                        mJMenuItem2.setEnabled(false);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        return mJPopupMenu;
    }

    public MJPopupMenu getCurrentPopup() {
        return this.fCurrentPopup;
    }

    private void setCurrentPopup(MJPopupMenu mJPopupMenu) {
        this.fCurrentPopup = mJPopupMenu;
        mJPopupMenu.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                FixedWidthPane.this.fCurrentPopup = null;
            }
        });
    }

    private void setupToolTip(MouseEvent mouseEvent) {
        this.fTooltipLocation = null;
        if (!(this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || this.isHeaderResizePoint(mouseEvent.getPoint()) || this.isHeaderAddPoint(mouseEvent.getPoint()))) {
            if (this.fRootPane == null) {
                this.setToolTipText(null);
                return;
            }
            Component component = SwingUtilities.getDeepestComponentAt(this.fRootPane.getContentPane(), mouseEvent.getX(), mouseEvent.getY());
            if (component != null && component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (jComponent.equals(this.fWorksheetTable)) {
                    int n;
                    Point point = this.getTablePoint(mouseEvent.getPoint());
                    int n2 = this.fWorksheetTable.rowAtPoint(point);
                    if (this.fWorksheetTable.isCellSelected(n2, n = this.fWorksheetTable.columnAtPoint(point))) {
                        this.setToolTipText(jComponent.getToolTipText());
                        Rectangle rectangle = this.fWorksheetTable.getCellRect(n2, n, true);
                        Point point2 = SwingUtilities.convertPoint((Component)((Object)this.fWorksheetTable), rectangle.getLocation(), (Component)((Object)this));
                        this.fTooltipLocation = new Point(point2.x + rectangle.width / 2, point2.y - rectangle.height - 5);
                    }
                } else {
                    this.setToolTipText(jComponent.getToolTipText());
                }
            }
        } else {
            int n = ((TextTable)((Object)this.fTableHeader.getTable())).getCharacterPositionForLocationOnScreen(mouseEvent.getLocationOnScreen());
            String string = this.fLastTooltipText;
            if (this.isAddRegion(mouseEvent.getPoint())) {
                string = ImportToolUtils.getResourceString("fixedwidthtooltips.add");
            } else if (!this.isHeaderAddPoint(mouseEvent.getPoint()) && !this.isHeaderResizePoint(mouseEvent.getPoint())) {
                string = ImportToolUtils.getResourceString("fixedwidthtooltips.move");
            } else if (!this.isHeaderAddPoint(mouseEvent.getPoint()) && this.isHeaderResizePoint(mouseEvent.getPoint())) {
                string = ImportToolUtils.getResourceString("fixedwidthtooltips.rulermove");
            } else if (this.isHeaderAddPoint(mouseEvent.getPoint())) {
                string = ImportToolUtils.getResourceString("fixedwidthtooltips.ruleradd");
            }
            this.setToolTipText(string);
        }
    }

    public void setToolTipText(String string) {
        if (string != null && !string.equals(this.fLastTooltipText)) {
            super.setToolTipText(string);
        } else if (string == null && this.fLastTooltipText != null) {
            super.setToolTipText(null);
        }
        this.fLastTooltipText = string;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (this.fTooltipLocation == null) {
            return super.getToolTipLocation(mouseEvent);
        }
        return this.fTooltipLocation;
    }

    private class FixedWidthComponentListener
    implements ComponentListener {
        private FixedWidthComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (FixedWidthPane.this.isVisible()) {
                FixedWidthPane.this.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (FixedWidthPane.this.isVisible()) {
                FixedWidthPane.this.repaint();
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (FixedWidthPane.this.isVisible()) {
                FixedWidthPane.this.repaint();
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            if (FixedWidthPane.this.isVisible()) {
                FixedWidthPane.this.repaint();
            }
        }
    }

    private class FixedWidthMouseAdapter
    extends MouseAdapter
    implements KeyListener {
        private Component fPressedComponent = null;

        private FixedWidthMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FixedWidthPane.this.fVoidActions) {
                return;
            }
            FixedWidthPane.this.fDragCanceled = false;
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()) || FixedWidthPane.this.fFixedCharacterMoving)) {
                this.redispatchMouseEvent(mouseEvent);
                this.fPressedComponent = null;
                return;
            }
            if (FixedWidthPane.this.fHeaderRenderer.isHeaderEditing()) {
                FixedWidthPane.this.fHeaderRenderer.fireEditingStopped();
            }
            if (FixedWidthPane.this.fTableHeader.getTable().isEditing() && FixedWidthPane.this.fTableHeader.getTable().getCellEditor() != null) {
                FixedWidthPane.this.fTableHeader.getTable().getCellEditor().cancelCellEditing();
            }
            if (FixedWidthPane.this.fFixedCharacterMoving) {
                int n = FixedWidthPane.this.fFixedWidthMoveWindow.getCharacterPosition();
                int n2 = FixedWidthPane.this.fFixedWidthMoveStartCharacterPosition;
                boolean bl = FixedWidthPane.this.fMovingColumn == -1 || n2 == n;
                FixedWidthPane.this.fDragCanceled = false;
                if (n2 == n && (!FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()) || FixedWidthPane.this.fWorksheetTable.characterPositionSplitExists(n2))) {
                    FixedWidthPane.this.closeDragWindow();
                    FixedWidthPane.this.repaint();
                    return;
                }
                FixedWidthPane.this.bufferScreenUntilTableUpdate();
                if (!bl) {
                    if (n == 0 || n == FixedWidthPane.this.fWorksheetTable.getMaxFixedCharacters()) {
                        if (FixedWidthPane.this.fWorksheetTable.characterPositionSplitExists(n2)) {
                            FixedWidthPane.this.fWorksheetTable.deleteColumnSplitter(n2);
                        } else {
                            FixedWidthPane.this.closeDragWindow();
                        }
                    } else {
                        FixedWidthPane.this.fWorksheetTable.moveColumnSplitter(n2, n);
                    }
                } else if (n == 0 || n == FixedWidthPane.this.fWorksheetTable.getMaxFixedCharacters()) {
                    FixedWidthPane.this.closeDragWindow();
                } else {
                    FixedWidthPane.this.fWorksheetTable.addColumnSplitter(n);
                }
            }
            FixedWidthPane.this.setCursor(fDefaultCursor);
            this.fPressedComponent = null;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (FixedWidthPane.this.fFixedWidthMoveWindow != null) {
                FixedWidthPane.this.fVoidActions = true;
                return;
            }
            FixedWidthPane.this.fDragCanceled = false;
            this.fPressedComponent = null;
            if (FixedWidthPane.this.fRootPane != null) {
                FixedWidthPane.this.fShowBufferedImage = false;
                FixedWidthPane.this.bufferRootPaneImage();
                this.fPressedComponent = SwingUtilities.getDeepestComponentAt(FixedWidthPane.this.fRootPane.getContentPane(), mouseEvent.getX(), mouseEvent.getY());
            }
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()) || FixedWidthPane.this.isAddRegion(mouseEvent.getPoint()))) {
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
            FixedWidthPane.this.fHeaderRenderer.fireEditingStopped();
            if (FixedWidthPane.this.fTableHeader.getTable().isEditing() && FixedWidthPane.this.fTableHeader.getTable().getCellEditor() != null) {
                FixedWidthPane.this.fTableHeader.getTable().getCellEditor().stopCellEditing();
            }
            if (FixedWidthPane.this.fHeaderRenderer.isFixedWidth() && (FixedWidthPane.this.getCursor() == fMoveCursor || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint())) && mouseEvent.getButton() == 1) {
                FixedWidthPane.this.fWorksheetTable.setDragSelectionEnabled(false);
                FixedWidthPane.this.fFixedCharacterMoving = true;
                FixedWidthPane.this.setupAndShowFixedWidthWindow(mouseEvent);
                FixedWidthPane.this.repaint();
            } else if (FixedWidthPane.this.fHeaderRenderer.isFixedWidth() && FixedWidthPane.this.getCursor() == fMoveCursor && !FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()) && !FixedWidthPane.this.fOverRightAddRegion && !FixedWidthPane.this.fOverLeftAddRegion) {
                FixedWidthPane.this.setupAndShowDeleteContextMenu(mouseEvent);
            } else if (FixedWidthPane.this.fHeaderRenderer.isFixedWidth() && FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint())) {
                FixedWidthPane.this.setupAndShowColumnContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (FixedWidthPane.this.fVoidActions) {
                return;
            }
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()) || FixedWidthPane.this.fFixedCharacterMoving || FixedWidthPane.this.fDragCanceled)) {
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
            if (FixedWidthPane.this.fFixedCharacterMoving) {
                FixedWidthPane.this.setFixedDragWindowLocation(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            FixedWidthPane.this.fOverLeftAddRegion = false;
            FixedWidthPane.this.fOverRightAddRegion = false;
            FixedWidthPane.this.setupToolTip(mouseEvent);
            if (!FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) && !FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint())) {
                ((TextCellRenderer)FixedWidthPane.this.fWorksheetTable.getDefaultRenderer(Object.class)).setHoverSplitterColumn(-1);
                ((TextTableHeaderRenderer)((Object)FixedWidthPane.this.fTableHeader.getDefaultRenderer())).setHoverSplitterColumn(-1);
                Point point = FixedWidthPane.this.getTablePoint(mouseEvent.getPoint());
                if (FixedWidthPane.this.fWorksheetTable.contains(point)) {
                    FixedWidthPane.this.setCursor(FixedWidthPane.this.fWorksheetTable.getCursor());
                } else {
                    FixedWidthPane.this.setCursor(fDefaultCursor);
                }
                FixedWidthPane.this.fWorksheetTable.repaint();
                FixedWidthPane.this.fTableHeader.repaint();
                if (FixedWidthPane.this.fRootPane != null) {
                    FixedWidthPane.this.fRootPane.repaint();
                }
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
            Point point = new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            SwingUtilities.convertPointToScreen(point, (Component)((Object)FixedWidthPane.this.fSelf));
            int n = FixedWidthPane.this.fWorksheetTable.getCharacterPositionForLocationOnScreen(point);
            int n2 = FixedWidthPane.this.fWorksheetTable.getColumnForCharacterPosition(n) + 1;
            if (!FixedWidthPane.this.fDragCanceled && FixedWidthPane.this.fWorksheetTable.characterPositionSplitExists(n)) {
                ((TextCellRenderer)FixedWidthPane.this.fWorksheetTable.getDefaultRenderer(Object.class)).setHoverSplitterColumn(n2);
                ((TextTableHeaderRenderer)((Object)FixedWidthPane.this.fTableHeader.getDefaultRenderer())).setHoverSplitterColumn(n2);
            } else {
                ((TextCellRenderer)FixedWidthPane.this.fWorksheetTable.getDefaultRenderer(Object.class)).setHoverSplitterColumn(-1);
                ((TextTableHeaderRenderer)((Object)FixedWidthPane.this.fTableHeader.getDefaultRenderer())).setHoverSplitterColumn(-1);
            }
            if (n == 0) {
                FixedWidthPane.this.fOverLeftAddRegion = true;
            } else if (n == FixedWidthPane.this.fWorksheetTable.getMaxFixedCharacters()) {
                FixedWidthPane.this.fOverRightAddRegion = true;
            }
            FixedWidthPane.this.fWorksheetTable.repaint();
            FixedWidthPane.this.fTableHeader.repaint();
            if (FixedWidthPane.this.fRootPane != null) {
                FixedWidthPane.this.fRootPane.repaint();
            }
            FixedWidthPane.this.setCursor(fMoveCursor);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (FixedWidthPane.this.fVoidActions) {
                return;
            }
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()))) {
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()))) {
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseEvent.getPoint()))) {
                this.redispatchMouseEvent(mouseEvent);
                return;
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!(FixedWidthPane.this.isTableHorizontalResizePoint(mouseWheelEvent.getPoint()) || FixedWidthPane.this.isHeaderResizePoint(mouseWheelEvent.getPoint()) || FixedWidthPane.this.isHeaderAddPoint(mouseWheelEvent.getPoint()))) {
                this.redispatchMouseEvent(mouseWheelEvent);
                return;
            }
        }

        private void redispatchMouseEvent(MouseEvent mouseEvent) {
            Point point;
            if (FixedWidthPane.this.fFixedCharacterMoving || FixedWidthPane.this.fRootPane == null) {
                mouseEvent.consume();
                return;
            }
            Component component = SwingUtilities.getDeepestComponentAt(FixedWidthPane.this.fRootPane.getContentPane(), mouseEvent.getX(), mouseEvent.getY());
            if (this.fPressedComponent != null) {
                component = this.fPressedComponent;
            }
            if (FixedWidthPane.this.fPreviousComponent != null && !FixedWidthPane.this.fPreviousComponent.equals(component) && mouseEvent.getID() == 503) {
                FixedWidthPane.this.fPreviousComponent.dispatchEvent(new MouseEvent(FixedWidthPane.this.fPreviousComponent, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), 0, 0, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            }
            if (component != null && !component.equals(FixedWidthPane.this.fPreviousComponent) && mouseEvent.getID() == 503) {
                point = SwingUtilities.convertPoint((Component)((Object)FixedWidthPane.this.fSelf), mouseEvent.getPoint(), component);
                component.dispatchEvent(new MouseEvent(component, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            }
            FixedWidthPane.this.fPreviousComponent = component;
            if (component != null) {
                point = SwingUtilities.convertPoint((Component)((Object)FixedWidthPane.this.fSelf), mouseEvent.getPoint(), component);
                if (mouseEvent instanceof MouseWheelEvent) {
                    component.dispatchEvent(new MouseWheelEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation()));
                } else {
                    component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
                }
            }
        }

        private void redispatchKeyEvent(KeyEvent keyEvent) {
            if (FixedWidthPane.this.fFixedCharacterMoving || FixedWidthPane.this.fRootPane == null) {
                keyEvent.consume();
                return;
            }
            FixedWidthPane.this.fRootPane.dispatchEvent(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.redispatchKeyEvent(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!FixedWidthPane.this.fFixedCharacterMoving) {
                this.redispatchKeyEvent(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.redispatchKeyEvent(keyEvent);
        }
    }
}

