/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class HeaderRowExcludeRule
extends WorksheetRule {
    private int fHeaderRow = -1;

    public HeaderRowExcludeRule() {
        this(-1);
    }

    public HeaderRowExcludeRule(int n) {
        this.fHeaderRow = n;
    }

    public int getHeaderRow() {
        return this.fHeaderRow;
    }

    public void setHeaderRow(int n) {
        this.fHeaderRow = n;
    }

    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    @Override
    public Object clone() {
        return new HeaderRowExcludeRule(this.fHeaderRow);
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.headerrowexcludesummary");
    }

    @Override
    public boolean codeGenUsesDates() {
        return false;
    }

    @Override
    public boolean codeGenNeedsNaNConvert() {
        return true;
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excludeheader"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(" = [ ");
        generatedCode.addCode(String.valueOf(this.fHeaderRow));
        generatedCode.addCode(" ]; % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findheaderrow"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(",:) = [];\n");
        if (bl) {
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("(");
            generatedCode.addCode(generatedCode.getRowExclusionIndex());
            generatedCode.addCode(",:) = [];\n");
        }
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("headerExcludeRowFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.headerrow");
    }
}

