/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

class IntervalSet
extends TreeSet<Interval> {
    IntervalSet() {
    }

    void addInterval(int n, int n2) {
        this.addInterval(new Interval(n <= n2 ? n : n2, n <= n2 ? n2 : n));
    }

    void removeInterval(int n, int n2) {
        this.removeInterval(new Interval(n <= n2 ? n : n2, n <= n2 ? n2 : n));
    }

    int getMaxIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((Interval)this.last()).iEnd;
    }

    int getMinIndex() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((Interval)this.first()).iStart;
    }

    boolean containsIndex(int n) {
        for (Interval interval : this) {
            if (interval.iStart > n || interval.iEnd < n) continue;
            return true;
        }
        return false;
    }

    List<int[]> getIntervals() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (Interval interval : this) {
            arrayList.add(new int[]{interval.iStart, interval.iEnd});
        }
        return arrayList;
    }

    private void addInterval(Interval interval) {
        if (this.isEmpty()) {
            this.add(interval);
            return;
        }
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        Interval interval2 = null;
        for (Interval interval3 : this) {
            if (interval3.iEnd + 1 < interval.iStart || interval3.iStart > interval.iEnd + 1) {
                arrayList.add(interval3);
                continue;
            }
            if (interval3.iStart <= interval.iStart && interval3.iEnd >= interval.iEnd) {
                return;
            }
            if (interval3.iStart >= interval.iStart && interval3.iEnd <= interval.iEnd) continue;
            if (interval3.iStart <= interval.iStart) {
                interval2 = new Interval(interval3.iStart, interval.iEnd);
                continue;
            }
            if (interval3.iStart < interval.iStart) continue;
            if (interval2 != null) {
                interval2 = new Interval(interval2.iStart, interval3.iEnd);
                continue;
            }
            interval2 = new Interval(interval.iStart, interval3.iEnd);
        }
        if (interval2 != null) {
            arrayList.add(interval2);
        } else {
            arrayList.add(interval);
        }
        this.clear();
        this.addAll(arrayList);
    }

    private void removeInterval(Interval interval) {
        if (this.isEmpty()) {
            return;
        }
        TreeSet treeSet = (TreeSet)this.clone();
        for (Interval interval2 : this) {
            if (interval2.iStart >= interval.iStart && interval2.iEnd <= interval.iEnd) {
                treeSet.remove(interval2);
                continue;
            }
            if (interval2.iEnd < interval.iStart || interval2.iStart > interval.iEnd) continue;
            if (interval2.iEnd >= interval.iStart) {
                treeSet.remove(interval2);
                if (interval2.iEnd > interval.iEnd) {
                    treeSet.add(new Interval(interval.iEnd + 1, interval2.iEnd));
                }
                if (interval.iStart <= interval2.iStart) continue;
                treeSet.add(new Interval(interval2.iStart, interval.iStart - 1));
                continue;
            }
            if (interval2.iEnd < interval.iEnd) continue;
            treeSet.remove(interval2);
            treeSet.add(new Interval(interval.iEnd + 1, interval2.iEnd));
        }
        this.clear();
        this.addAll(treeSet);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Interval interval : this) {
            stringBuilder.append(interval.toString());
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    static class Interval
    implements Comparable<Interval> {
        public int iStart = -1;
        public int iEnd = -1;

        Interval(int n, int n2) {
            assert (n <= n2);
            this.iStart = n;
            this.iEnd = n2;
        }

        @Override
        public int compareTo(Interval interval) {
            if (this.iStart < interval.iStart) {
                return -1;
            }
            if (this.iStart > interval.iStart) {
                return 1;
            }
            return 0;
        }

        boolean contains(int n) {
            return this.iStart <= n && this.iEnd >= n;
        }

        int[] toArray() {
            return new int[]{this.iStart, this.iEnd};
        }

        public boolean equals(Object object) {
            if (!(object instanceof Interval)) {
                return false;
            }
            Interval interval = (Interval)object;
            return this.iStart == interval.iStart && this.iEnd == interval.iEnd;
        }

        public int hashCode() {
            return this.iStart * 10000 * this.iEnd;
        }

        public String toString() {
            return Integer.toString(this.iStart) + ":" + Integer.toString(this.iEnd);
        }
    }
}

