/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.VariableInfoTabOwner;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

class VariableInfoTab
extends MJPanel {
    private VariableNameTextField fVarNameText = new VariableNameTextField();
    private MJLabel fWarnLabel = new MJLabel((Icon)new ImageIcon(VariableInfoTab.class.getResource("/com/mathworks/mlwidgets/importtool/resources/warning_small.gif")));
    private MJLabel fVarSizeLabel = new MJLabel("");
    private String fVarSizeTooltip = null;
    private int fColumnPosition = -1;
    private VariableInfoTabOwner fVariableInfoTabOwner;
    private String fLastVarName;
    private Dimension fCachedMaximumSize;
    private boolean fTemporarilyLostFocus = false;
    private static int BORDERWIDTH = 2;
    private static int TABOFFSET = 5;
    private static boolean sIsHighContrast = MJUtilities.isHighContrast();

    VariableInfoTab(VariableInfoTabOwner variableInfoTabOwner) {
        super((LayoutManager)new BorderLayout());
        this.setOpaque(false);
        this.fVariableInfoTabOwner = variableInfoTabOwner;
        this.fVarNameText.setOpaque(false);
        this.fVarNameText.setToolTipText(ImportToolUtils.getResourceString("variablename.tooltip"));
        this.fVarNameText.setSelectAllOnFocus(true);
        this.fVarNameText.setHorizontalAlignment(0);
        this.fVarNameText.setFont(this.fVarNameText.getFont().deriveFont(1, 12.0f));
        this.fVarNameText.setBorder(BorderFactory.createEmptyBorder(-1, 2, 0, 0));
        this.fVarSizeLabel.setBorder(BorderFactory.createEmptyBorder(-1, 0, 0, 0));
        if (sIsHighContrast) {
            this.fVarSizeLabel.setForeground(Color.white);
        } else {
            this.fVarSizeLabel.setForeground(Color.gray);
        }
        this.fVarSizeLabel.setFont(this.fVarNameText.getFont().deriveFont(1, 12.0f));
        this.fVarSizeLabel.setOpaque(false);
        this.fVarSizeLabel.setName("VariableInfoTab:sizelabel");
        this.setBorder(new TabBorder());
        this.fWarnLabel.setVisible(false);
        this.fWarnLabel.setName("VariableInfoTab:warnlabel");
        this.fWarnLabel.setToolTipText(ImportToolUtils.getResourceString("variablewarn.tooltip"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setOpaque(false);
        mJPanel.add((Component)this.fWarnLabel, (Object)"West");
        mJPanel.add((Component)((Object)this.fVarNameText), (Object)"Center");
        this.add((Component)mJPanel, "West");
        this.add((Component)this.fVarSizeLabel, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.fVarNameText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    return;
                }
                VariableInfoTab.this.editVariableName();
            }
        });
        this.fVarSizeLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                VariableInfoTab.this.editVariableName();
            }
        });
        this.fVarNameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                VariableInfoTab.this.fTemporarilyLostFocus = focusEvent.isTemporary();
                if (VariableInfoTab.this.fTemporarilyLostFocus) {
                    return;
                }
                VariableInfoTab.this.fVarNameText.setCaretPosition(0);
                VariableInfoTab.this.commit();
                VariableInfoTab.this.validate();
                VariableInfoTab.this.repaint();
            }
        });
        this.fVarNameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Serializable serializable;
                int n = 30;
                if (keyEvent.getKeyCode() == 10) {
                    VariableInfoTab.this.commit();
                    if (VariableInfoTab.this.fVariableInfoTabOwner != null) {
                        VariableInfoTab.this.fVariableInfoTabOwner.setFocus();
                    }
                } else {
                    serializable = VariableInfoTab.this.fVarNameText.getFontMetrics(VariableInfoTab.this.fVarNameText.getFont());
                    int n2 = ((FontMetrics)serializable).charsWidth(VariableInfoTab.this.fVarNameText.getText().toCharArray(), 0, VariableInfoTab.this.fVarNameText.getText().toCharArray().length);
                    if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                        if (n2 < ((VariableInfoTab)VariableInfoTab.this).fVarNameText.getSize().width - n) {
                            VariableInfoTab.this.fVarNameText.setPreferredSize(null);
                            VariableInfoTab.this.revalidate();
                            VariableInfoTab.this.repaint();
                        }
                    } else if (n2 > ((VariableInfoTab)VariableInfoTab.this).fVarNameText.getSize().width - 10) {
                        if (VariableInfoTab.this.fCachedMaximumSize == null) {
                            VariableInfoTab.this.fCachedMaximumSize = VariableInfoTab.this.getMaximumSize();
                            VariableInfoTab.this.setMaximumSize(null);
                        }
                        VariableInfoTab.this.fVarNameText.setPreferredSize(new Dimension(n2 + n, ((VariableInfoTab)VariableInfoTab.this).fVarNameText.getPreferredSize().height));
                        VariableInfoTab.this.revalidate();
                        VariableInfoTab.this.repaint();
                    }
                }
                if ((serializable = VariableInfoTab.this.getParent()) != null) {
                    ((Container)serializable).setComponentZOrder((Component)((Object)VariableInfoTab.this), 0);
                    ((Component)serializable).repaint();
                }
            }
        });
    }

    private void editVariableName() {
        this.fVarNameText.setCursor(Cursor.getPredefinedCursor(2));
        if (!this.fVarNameText.isFocusOwner()) {
            this.fVarNameText.selectAll();
        }
        this.fVarNameText.requestFocus();
    }

    void setVariableInfoTabOwner(VariableInfoTabOwner variableInfoTabOwner) {
        this.fVariableInfoTabOwner = variableInfoTabOwner;
    }

    MJLabel getWarningLabel() {
        return this.fWarnLabel;
    }

    void setSelectionSizeString(String string, String string2) {
        this.fVarSizeLabel.setText(string);
        this.fVarSizeTooltip = string2;
        this.updateTooltip();
    }

    void setValidSizeForeground(boolean bl) {
        if (bl) {
            if (sIsHighContrast) {
                this.fVarSizeLabel.setForeground(Color.white);
            } else {
                this.fVarSizeLabel.setForeground(Color.gray);
            }
        } else {
            this.fVarSizeLabel.setForeground(Color.red);
        }
    }

    String getSelectionSizeString() {
        if (this.fVarSizeLabel == null) {
            return null;
        }
        return this.fVarSizeLabel.getText();
    }

    void setColumnPosition(int n) {
        this.fColumnPosition = n;
    }

    int getColumnPosition() {
        return this.fColumnPosition;
    }

    void setText(String string) {
        if (string != null && string.equals(this.fVarNameText.getText())) {
            return;
        }
        if (this.variableNameEditorHasFocus()) {
            return;
        }
        this.fLastVarName = string;
        this.fVarNameText.setText(string);
        this.updateTooltip();
        this.fVarNameText.setPreferredSize(null);
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    private void updateTooltip() {
        String string = this.getSelectionSizeString();
        String string2 = "";
        string2 = string == null ? "<html><b>" + this.fVarNameText.getText() + "</b><br>" + ImportToolUtils.getResourceString("variablename.tooltip") : "<html><b>" + this.fVarNameText.getText() + "</b>: " + this.getSelectionSizeString() + "<br>" + ImportToolUtils.getResourceString("variablename.tooltip");
        this.fVarNameText.setToolTipText(string2);
        if (this.fVarSizeTooltip == null) {
            this.fVarSizeLabel.setToolTipText(string2);
        } else {
            this.fVarSizeLabel.setToolTipText(this.fVarSizeTooltip);
        }
    }

    boolean variableNameEditorHasFocus() {
        return this.fTemporarilyLostFocus || this.fVarNameText.isFocusOwner();
    }

    String getText() {
        return this.fVarNameText.getText();
    }

    void commit() {
        String string;
        this.fVarNameText.setPreferredSize(null);
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        if (!(string = this.fVarNameText.getText().trim()).matches("^[a-zA-Z]+[a-zA-z0-9_]*")) {
            this.fVarNameText.setText(this.fLastVarName);
            this.fWarnLabel.setVisible(false);
        }
        this.fWarnLabel.setVisible(this.fVariableInfoTabOwner != null && this.fVariableInfoTabOwner.externalVariableExistsInMatlab(string));
        this.fLastVarName = this.fVarNameText.getText();
        this.updateTooltip();
        if (this.fCachedMaximumSize != null) {
            this.setMaximumSize(this.fCachedMaximumSize);
            this.fCachedMaximumSize = null;
        }
        if (this.fVariableInfoTabOwner != null) {
            this.fVariableInfoTabOwner.setVariableName(this.fLastVarName, this.fColumnPosition);
            this.revalidate();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Polygon polygon = new Polygon(new int[]{rectangle.x, rectangle.x + rectangle.width - TABOFFSET, rectangle.x + rectangle.width, rectangle.x}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height, rectangle.y + rectangle.height}, 4);
        Polygon polygon2 = new Polygon(new int[]{rectangle.x + BORDERWIDTH, rectangle.x + BORDERWIDTH + rectangle.width - TABOFFSET - BORDERWIDTH, rectangle.x + rectangle.width - BORDERWIDTH, rectangle.x + BORDERWIDTH}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height, rectangle.y + rectangle.height}, 4);
        if (sIsHighContrast) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(Color.white);
        }
        graphics2D.fill(polygon2);
        graphics2D.clip(polygon);
        super.paint((Graphics)graphics2D);
        graphics2D.dispose();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + TABOFFSET, dimension.height);
    }

    private static class VariableNameTextField
    extends MJTextField {
        private VariableNameTextField() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width += 5;
            return dimension;
        }
    }

    private static class TabBorder
    implements Border {
        private TabBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(BORDERWIDTH, BORDERWIDTH, BORDERWIDTH, BORDERWIDTH);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setStroke(new BasicStroke(4.0f, 0, 2, 1.0f));
            Polygon polygon = new Polygon(new int[]{n, n + n3 - TABOFFSET, n + n3, n}, new int[]{n2, n2, n2 + n4, n2 + n4}, 4);
            graphics2D.draw(polygon);
            graphics2D.dispose();
        }
    }

    static enum MatlabVariableState {
        NEW,
        EXISTING,
        INVALID;

    }
}

