/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.mathworks.mlwidgets.prefs.binding.KeyBindingPanelUtils;
import com.mathworks.mlwidgets.prefs.binding.KeyBindingSetEntry;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.table.AccessibleTextProvider;
import com.mathworks.widgets.ButtonFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ConflictPanel {
    private final JComponent fPanel;
    private final KeyBindingManager fManager;
    private KeyBindingSetEntry fSetInProgress;
    private final MJTable fConflictTable;
    private final ConflictTableModel fConflictTableModel = new ConflictTableModel();
    private final MJButton fUnassignButton;
    private static final int CONFLICT_COLUMN = 0;
    private static final int SHORTCUT_COLUMN = 1;
    private static final int ACTION_COLUMN = 2;
    private static final int CONTEXT_COLUMN = 3;

    ConflictPanel(KeyBindingManager keyBindingManager) {
        this.fManager = keyBindingManager;
        this.fConflictTable = this.createTable(this.fConflictTableModel);
        this.fUnassignButton = new MJButton(KeyBindingPanelUtils.lookup("conflictPanel.unassign.button"));
        this.fUnassignButton.setName("ConflictUnassignButton");
        this.fUnassignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                assert (ConflictPanel.this.fConflictTable.getSelectedRowCount() == 1) : "Unassign button should be disabled if there is no selection";
                TableEntry tableEntry = ConflictPanel.this.fConflictTableModel.getEntryAt(ConflictPanel.this.fConflictTable.getSelectedRow());
                for (Context context : tableEntry.getContexts()) {
                    ConflictPanel.this.fSetInProgress.removeKeyBindingFromContext(tableEntry.getAction(), context, tableEntry.getBinding());
                }
            }
        });
        this.fPanel = KeyBindingPanelUtils.layoutTablePanel(new MJLabel(KeyBindingPanelUtils.lookup("conflictPanel.title")), this.fConflictTable, ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fUnassignButton}), true);
    }

    JComponent getComponent() {
        return this.fPanel;
    }

    void setChanged(ActionData actionData) {
        this.fConflictTableModel.recreateData(actionData);
        this.updateUnassignButtonState();
    }

    void selectedActionChanged(ActionData actionData, KeyBindingSetEntry keyBindingSetEntry) {
        assert (keyBindingSetEntry != null) : "KeyBindingSetEntry cannot be null";
        this.fSetInProgress = keyBindingSetEntry;
        this.setChanged(actionData);
    }

    private MJTable createTable(final ConflictTableModel conflictTableModel) {
        assert (this.fConflictTable == null) : "Create table should only be called onece";
        MJTable mJTable = new MJTable(conflictTableModel){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                return new Dimension((int)dimension.getWidth(), this.getRowHeight() * 3);
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    TableEntry tableEntry = conflictTableModel.getEntryAt(n);
                    String string = n2 == 0 ? KeyBindingPanelUtils.getConflictDescription(ConflictPanel.this.fManager, (KeyBindingSet)ConflictPanel.this.fSetInProgress.getModifiableSet(), tableEntry.getAction(), tableEntry.getBinding(), tableEntry.getContexts()) : KeyBindingPanelUtils.getActionDescription(tableEntry.getAction());
                    ((JComponent)component).setToolTipText(string);
                }
                return component;
            }
        };
        mJTable.setAccessibleTextProvider(new AccessibleTextProvider(){

            public String getAccessibleText(int n, int n2) {
                TableEntry tableEntry = conflictTableModel.getEntryAt(n);
                String string = "Shortcut " + tableEntry.getShortcut() + " assigned to action " + tableEntry.getActionName() + " in " + tableEntry.getComponents() + ". ";
                string = string + KeyBindingPanelUtils.getConflictDescription(ConflictPanel.this.fManager, (KeyBindingSet)ConflictPanel.this.fSetInProgress.getModifiableSet(), tableEntry.getAction(), tableEntry.getBinding(), tableEntry.getContexts());
                return string;
            }
        });
        mJTable.setName("ConflictTable");
        TableColumnModel tableColumnModel = mJTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setHeaderValue("");
        tableColumn.setCellRenderer(new ConflictTableRenderer());
        tableColumn.setMaxWidth(KeyBindingPanelUtils.getConflictColumnWidth());
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setHeaderValue(KeyBindingPanelUtils.lookup("conflictPanel.table.shortcutHeader"));
        tableColumn2.setPreferredWidth(60);
        tableColumnModel.getColumn(2).setHeaderValue(KeyBindingPanelUtils.lookup("conflictPanel.table.actionHeader"));
        TableColumn tableColumn3 = tableColumnModel.getColumn(3);
        tableColumn3.setHeaderValue(KeyBindingPanelUtils.lookup("conflictPanel.table.componentsHeader"));
        tableColumn3.setPreferredWidth(200);
        mJTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConflictPanel.this.updateUnassignButtonState();
            }
        });
        return mJTable;
    }

    private void updateUnassignButtonState() {
        this.fUnassignButton.setEnabled(this.fConflictTable.getSelectedRowCount() > 0);
    }

    boolean isUnassignButtonEnabled() {
        return this.fUnassignButton.isEnabled();
    }

    void unassignConflict() {
        assert (this.isUnassignButtonEnabled()) : " This method should only be called if the unassign button is enabled";
        this.fUnassignButton.doClick();
    }

    int getNumberOfConflicts() {
        return this.fConflictTable.getRowCount();
    }

    void selectConflictByAction(ActionData actionData) {
        assert (this.getNumberOfConflicts() > 0) : "Conflicts must be present.";
        for (int i = 0; i < this.fConflictTable.getRowCount(); ++i) {
            if (!this.fConflictTableModel.getEntryAt(i).getAction().equals((Object)actionData)) continue;
            this.fConflictTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    void clearConflictTableSelection() {
        this.fConflictTable.clearSelection();
    }

    private class ConflictTableRenderer
    extends KeyBindingPanelUtils.ConflictRenderer {
        private ConflictTableRenderer() {
        }

        @Override
        public KeyBindingPanelUtils.ConflictType getConflictType(int n) {
            TableEntry tableEntry = ConflictPanel.this.fConflictTableModel.getEntryAt(n);
            return KeyBindingPanelUtils.getConflictType(ConflictPanel.this.fManager, (KeyBindingSet)ConflictPanel.this.fSetInProgress.getModifiableSet(), tableEntry.getAction(), tableEntry.getBinding(), tableEntry.getContexts());
        }
    }

    private static class TableEntry
    extends KeyBindingPanelUtils.ConflictData {
        TableEntry(KeyStrokeList keyStrokeList, ActionData actionData, List<Context> list) {
            super(actionData, keyStrokeList, list);
        }

        String getShortcut() {
            return KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)this.getBinding());
        }

        String getActionName() {
            return this.getAction().getPreferencePanelLabel();
        }

        String getComponents() {
            return KeyBindingPanelUtils.makeContextList(this.getContexts());
        }

        TableEntry addContext(Context context) {
            ArrayList<Context> arrayList = new ArrayList<Context>(this.getContexts());
            arrayList.add(context);
            return new TableEntry(this.getBinding(), this.getAction(), arrayList);
        }
    }

    private class ConflictTableModel
    extends AbstractTableModel {
        private final List<TableEntry> fEntries = new ArrayList<TableEntry>();

        private ConflictTableModel() {
        }

        TableEntry getEntryAt(int n) {
            return this.fEntries.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableEntry tableEntry = this.fEntries.get(n);
            return n2 == 1 ? tableEntry.getShortcut() : (n2 == 2 ? tableEntry.getActionName() : (n2 == 3 ? tableEntry.getComponents() : ""));
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.fEntries.size();
        }

        private void recreateData(ActionData actionData) {
            this.fEntries.clear();
            if (actionData != null) {
                this.addTableEntries(ConflictPanel.this.fSetInProgress.getActionGlobalKeyBindings(actionData), actionData);
                for (Context context : ConflictPanel.this.fManager.getContextsWithAction((ActionDataID)actionData)) {
                    for (KeyStrokeList keyStrokeList : ConflictPanel.this.fSetInProgress.getNonGlobalKeyBindings(context, (ActionDataID)actionData)) {
                        this.addTableEntries(Arrays.asList(keyStrokeList), actionData);
                    }
                }
            }
            ConflictPanel.this.fConflictTable.setEnabled(!this.fEntries.isEmpty());
            this.fireTableDataChanged();
        }

        private void addTableEntries(List<KeyStrokeList> list, ActionData actionData) {
            Collection collection = ConflictPanel.this.fManager.getContextsWithAction((ActionDataID)actionData);
            for (KeyStrokeList keyStrokeList : list) {
                List<KeyBindingManager.Conflict> list2 = KeyBindingPanelUtils.getConflictsIfBindingIsActive((KeyBindingSet)ConflictPanel.this.fSetInProgress.getModifiableSet(), ConflictPanel.this.fManager, keyStrokeList, actionData);
                if (list2.isEmpty()) continue;
                Collection<Context> collection2 = KeyBindingPanelUtils.getContextsWithBindingForAction(collection, (KeyBindingSet)ConflictPanel.this.fSetInProgress.getModifiableSet(), actionData, keyStrokeList);
                for (KeyBindingManager.Conflict conflict : list2) {
                    ActionData actionData2 = conflict.getAction();
                    if (actionData2.equals((Object)actionData) || !collection2.contains(conflict.getContext()) && !keyStrokeList.equals((Object)conflict.getBinding())) continue;
                    boolean bl = true;
                    for (TableEntry tableEntry : this.fEntries) {
                        if (!tableEntry.getAction().equals((Object)actionData2) || !tableEntry.getBinding().equals((Object)conflict.getBinding())) continue;
                        bl = false;
                        if (tableEntry.getContexts().contains(conflict.getContext())) break;
                        this.fEntries.set(this.fEntries.indexOf(tableEntry), tableEntry.addContext(conflict.getContext()));
                        break;
                    }
                    if (!bl) continue;
                    this.fEntries.add(new TableEntry(conflict.getBinding(), actionData2, Arrays.asList(conflict.getContext())));
                }
            }
        }
    }
}

