/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.google.common.collect.ArrayListMultimap;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.shortcuts.Category;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.services.Prefs;
import com.mathworks.xml.XMLUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXParseException;

public class ShortcutUtils {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    private static final String sShortcutIconPath = sRes.getString("icon.General");
    private static String sXMLFileName = "shortcuts";
    private static String sJaXMLFileName = "shortcuts_ja";
    private static String TOOLBAR_SHORTCUTS_JA_SP3 = "Toolbar\u30b7\u30e7\u30fc\u30c8\u30ab\u30c3\u30c8";
    private static String HELP_FAVS_JA_SP3 = "Help Browser\u304a\u6c17\u306b\u5165\u308a";
    private static final String sToolbarCategory = sRes.getString("xml.Toolbar");
    private static final String sToolbarCategoryToStore = "Toolbar Shortcuts";
    private static final String sHelpCategory = sRes.getString("xml.Help");
    private static final String sHelpCategoryToStore = "Help Browser Favorites";
    private static final String SIMBIOLOGY_CATEGORY = "SimBiology";
    private static final String NONE = sRes.getString("node.category.None");
    private static final String CURRENT_VERSION = "2";
    private static final String REL_NOTES_CALLBACK = "helpview([docroot '/base/relnotes/helptargets.map'], 'general_rn_highlights');";
    private static final String OLD_REL_NOTES_CALLBACK = "helpview([docroot '/base/relnotes/relnotes_product_page.html']);";
    private static ShortcutUtils sFavHandler = null;
    private static EventListenerList sListenerList = new EventListenerList();
    private static String sSeparator = System.getProperty("file.separator");
    private static String sLocalFilename = sXMLFileName + ".xml";
    private static String sLocalFilename_2 = sXMLFileName + "_2.xml";
    private static Document sDomDoc;
    private static Element sDocumentElement;
    private static Shortcut[] sTopLevelItems;
    private static DocumentBuilder sDocBuilder;
    private static boolean sFirstRead;
    private static boolean sReEntrantProtection;
    private static SimpleElement sSimpleRoot;
    private static String sEncoding;
    private static boolean sIsDoneCreating;
    private static boolean sIsTesting;

    static String getToolbarCategory() {
        return sToolbarCategory;
    }

    static String getToolbarCategoryToStore() {
        return sToolbarCategoryToStore;
    }

    static String getHelpCategory() {
        return sHelpCategory;
    }

    static String getHelpCategoryToStore() {
        return sHelpCategoryToStore;
    }

    public static int addShortcutToBottom(String string, String string2, String string3, String string4, String string5) {
        if (string4 == null || string4.equals("")) {
            string4 = NONE;
        }
        if (string3 == null || string3.equals("")) {
            string3 = sShortcutIconPath;
        }
        while (string == null || string.equals("")) {
            string = MJOptionPane.showInputDialog(null, (Object)sRes.getString("alert.NewShortcutMsg"), (String)sRes.getString("alert.NewShortcutTitle"), (int)0);
            if (string != null) continue;
            return 2;
        }
        if (string2 == null || string2.equals("")) {
            string2 = new String("disp('" + sRes.getString("callback.None") + "')");
        }
        if (ShortcutUtils.exists(string) && !sIsTesting && (string = ShortcutUtils.alertOverwrite(string4, string)) == null) {
            return 2;
        }
        ShortcutUtils.insertShortcutAtBottom(string, string2, string3, string4, string5);
        if (string4.equals(NONE)) {
            sTopLevelItems = null;
        }
        ShortcutUtils.saveAndNotify(string, string4, 0, null, null);
        return 0;
    }

    private static String alertOverwrite(String string, String string2) {
        while (ShortcutUtils.exists(string2) || string2.equals("")) {
            string2 = MJOptionPane.showInputDialog(null, (Object)sRes.getString("alert.NewShortcutMsgSameName"), (String)sRes.getString("alert.NewShortcutTitleSameName"), (int)0);
            if (string2 != null) continue;
            return null;
        }
        return string2;
    }

    public static boolean addNewCategory(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (sTopLevelItems == null) {
            ShortcutUtils.parseForItems();
        }
        if (ShortcutUtils.getTopLevelCategoryByName(string) != null) {
            return false;
        }
        ShortcutUtils.insertNewCategoryNode(string, ShortcutUtils.getDocumentNode());
        return true;
    }

    private static Node createNewNode(String string, String string2, String string3, String string4) {
        Document document = ShortcutUtils.getDomDocument(ShortcutUtils.getShortcutsFile());
        Element element = document.createElement("FAVORITE");
        Element element2 = document.createElement("label");
        Element element3 = document.createElement("icon");
        Element element4 = document.createElement("callback");
        Element element5 = document.createElement("editable");
        Text text = document.createTextNode(string);
        Text text2 = document.createTextNode(string2);
        Text text3 = document.createTextNode(string3);
        Text text4 = document.createTextNode(string4);
        element2.appendChild(text);
        element3.appendChild(text2);
        element4.appendChild(text3);
        element5.appendChild(text4);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        return element;
    }

    private static Element createFavoriteElement(Document document, String string, String string2, String string3) {
        Element element = document.createElement("FAVORITE");
        Element element2 = document.createElement("label");
        Text text = document.createTextNode(string);
        Element element3 = document.createElement("callback");
        Text text2 = document.createTextNode(string2);
        Element element4 = document.createElement("icon");
        Text text3 = document.createTextNode(string3);
        Element element5 = document.createElement("editable");
        Text text4 = document.createTextNode("true");
        element2.appendChild(text);
        element3.appendChild(text2);
        element4.appendChild(text3);
        element5.appendChild(text4);
        element.appendChild(element2);
        element.appendChild(element4);
        element.appendChild(element3);
        element.appendChild(element5);
        return element;
    }

    private static void createInitialFavorites(File file) {
        sDomDoc = null;
        sDocumentElement = null;
        Element element = null;
        try {
            sDomDoc = XMLUtils.createDocument((String)"FAVORITESROOT");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        element = sDomDoc.getDocumentElement();
        element.setAttribute("version", CURRENT_VERSION);
        Element element2 = sDomDoc.createElement("title");
        Text text = sDomDoc.createTextNode(sRes.getString("xml.Title"));
        element2.appendChild(text);
        element.appendChild(element2);
        ShortcutUtils.createHelpCategory(element, null);
        if (!ShortcutUtils.usingToolstrip()) {
            ShortcutUtils.createToolbarCategory(element, null);
            Element element3 = ShortcutUtils.createFavoriteElement(sDomDoc, sRes.getString("invisible.Default"), "helpview([docroot '/mapfiles/matlab_env.map'], 'matlab_shortcuts');", sRes.getString("icon.Help"));
            element.appendChild(element3);
        }
        if (file == null) {
            ShortcutUtils.saveDocument(ShortcutUtils.getShortcutsFile());
        } else {
            ShortcutUtils.saveDocument(file);
        }
        sTopLevelItems = null;
        sIsDoneCreating = true;
    }

    private static boolean usingToolstrip() {
        if (sIsTesting) {
            return false;
        }
        return MatlabDesktopServices.getDesktop().useToolstrip();
    }

    private static Element createHelpCategory(Element element, Vector vector) {
        Element element2 = sDomDoc.createElement("FAVORITECATEGORY");
        Element element3 = sDomDoc.createElement("name");
        Text text = sDomDoc.createTextNode(ShortcutUtils.getHelpCategory());
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
        if (vector != null) {
            Shortcut shortcut = null;
            Element element4 = null;
            for (int i = 0; i < vector.size(); ++i) {
                shortcut = (Shortcut)vector.elementAt(i);
                element4 = ShortcutUtils.createFavoriteElement(sDomDoc, shortcut.getLabel(), shortcut.getCallback(), shortcut.getIconPath());
                element2.appendChild(element4);
            }
        } else {
            Element element5 = ShortcutUtils.createFavoriteElement(sDomDoc, sRes.getString("help.Desktop"), "helpview([docroot '/mapfiles/matlab_env.map'], 'matlabenvironment_desktop');", sRes.getString("icon.Help"));
            element2.appendChild(element5);
        }
        return element2;
    }

    private static Element createToolbarCategory(Element element, Vector vector) {
        Element element2 = sDomDoc.createElement("FAVORITECATEGORY");
        Element element3 = sDomDoc.createElement("name");
        Text text = sDomDoc.createTextNode(ShortcutUtils.getToolbarCategory());
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
        if (vector != null && vector.size() != 0) {
            Shortcut shortcut = null;
            Element element4 = null;
            for (int i = 0; i < vector.size(); ++i) {
                shortcut = (Shortcut)vector.elementAt(i);
                element4 = ShortcutUtils.createFavoriteElement(sDomDoc, shortcut.getLabel(), shortcut.getCallback(), shortcut.getIconPath());
                element2.appendChild(element4);
            }
        } else {
            Element element5 = ShortcutUtils.createFavoriteElement(sDomDoc, sRes.getString("toolbar.Default"), "helpview([docroot '/techdoc/env_csh/env_csh.map'], 'shortcut_on_toolbar', 'CSHelpWindow');", sRes.getString("icon.General"));
            element2.appendChild(element5);
            Element element6 = ShortcutUtils.createFavoriteElement(sDomDoc, sRes.getString("toolbar.WhatsNew"), REL_NOTES_CALLBACK, sRes.getString("icon.General"));
            element2.appendChild(element6);
        }
        return element;
    }

    public static boolean editCategory(String string, String string2, String string3) {
        if (!string.equals(string3) && ShortcutUtils.getTopLevelCategoryByName(string3) == null) {
            Category category = ShortcutUtils.getTopLevelCategoryByName(string);
            category.setLabel(string3);
            ShortcutUtils.renameCatagoryElement(ShortcutUtils.getDocumentNode(), string, string3);
            sTopLevelItems = null;
            ShortcutUtils.saveAndNotify(null, string3, 4, null, string);
            return true;
        }
        return false;
    }

    public static int editShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Element element = null;
        if (string6 == null) {
            string6 = "";
        }
        while (string3 == null || string3.equals("")) {
            string3 = MJOptionPane.showInputDialog(null, (Object)sRes.getString("alert.NewShortcutMsg"), (String)sRes.getString("alert.NewShortcutTitle"), (int)0);
            if (string3 != null) continue;
            return 2;
        }
        if (!string.equals(string3) && ShortcutUtils.exists(string3) && !sIsTesting && (string3 = ShortcutUtils.alertOverwrite(string4, string3)) == null) {
            return 2;
        }
        if (!string2.equals(string4)) {
            ShortcutUtils.insertShortcutAtBottom(string3, string5, string6, string4, "true");
            ShortcutUtils.remove(string2, string);
            sTopLevelItems = null;
            ShortcutUtils.saveAndNotify(string3, string4, 4, string, string2);
        } else {
            element = ShortcutUtils.findElement(string2, string);
            if (element != null) {
                NodeList nodeList = element.getElementsByTagName("editable");
                if (nodeList.item(0).getFirstChild().getNodeValue().equals("true")) {
                    ShortcutUtils.setNodeValueByLabel(element, "label", string3);
                    ShortcutUtils.setNodeValueByLabel(element, "callback", string5);
                    ShortcutUtils.setNodeValueByLabel(element, "icon", string6);
                    Category category = ShortcutUtils.getTopLevelCategoryByName(string2);
                    if (category != null) {
                        Shortcut shortcut = (Shortcut)category.getObject(string);
                        shortcut.setLabel(string3);
                        shortcut.setCallback(string5);
                        shortcut.setIconPath(string6);
                    } else {
                        sTopLevelItems = null;
                    }
                    ShortcutUtils.saveAndNotify(string3, string4, 4, string, string2);
                } else {
                    System.out.println("This favorite is read-only");
                }
            } else {
                ShortcutUtils.addShortcutToBottom(string3, string5, string6, string4, "true");
            }
        }
        return 0;
    }

    private static Element findCategoryElement(Element element, String string) {
        Element element2 = null;
        if (string.equals(NONE)) {
            return ShortcutUtils.getDocumentNode();
        }
        try {
            NodeList nodeList = element.getElementsByTagName("FAVORITECATEGORY");
            block2: for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                NodeList nodeList2 = element3.getElementsByTagName("name");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    String string2 = nodeList2.item(j).getFirstChild().getNodeValue();
                    if (!string2.equals(string)) continue;
                    element2 = element3;
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return element2;
    }

    private static void renameCatagoryElement(Element element, String string, String string2) {
        Element element2 = ShortcutUtils.findCategoryElement(element, string);
        if (element2 != null) {
            ShortcutUtils.setNodeValueByLabel(element2, "name", string2);
        }
    }

    private static Element findElement(String string, String string2) {
        Element element;
        block8: {
            block7: {
                element = null;
                Element element2 = null;
                if (string.equals(ShortcutUtils.getTopLevelNodeName())) {
                    Element element3 = ShortcutUtils.getFirstElement(ShortcutUtils.getDocumentNode());
                    if (element3 != null) {
                        Element element4 = element3;
                        element4 = element3;
                        while (element4 != null) {
                            Shortcut shortcut;
                            if (ShortcutUtils.isAShortcutNode(element4) && (shortcut = ShortcutUtils.extractShortcutInfoFromElement(element4)).getLabel().equals(string2)) {
                                return element4;
                            }
                            element4 = ShortcutUtils.getNextElement(element4);
                        }
                    }
                    return null;
                }
                element2 = ShortcutUtils.findCategoryElement(ShortcutUtils.getDocumentNode(), string);
                if (element2 == null) break block7;
                NodeList nodeList = element2.getElementsByTagName("FAVORITE");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element5 = (Element)nodeList.item(i);
                    NodeList nodeList2 = element5.getElementsByTagName("label");
                    String string3 = nodeList2.item(0).getFirstChild().getNodeValue();
                    if (!string3.equals(string2)) continue;
                    element = (Element)nodeList.item(i);
                }
                break block8;
            }
            Element element6 = ShortcutUtils.getFirstElement(ShortcutUtils.getDocumentNode());
            if (element6 == null) break block8;
            Element element7 = element6;
            element7 = element6;
            while (element7 != null) {
                Shortcut shortcut;
                if (ShortcutUtils.isAShortcutNode(element7) && (shortcut = ShortcutUtils.extractShortcutInfoFromElement(element7)).getLabel().equals(string2)) {
                    return element7;
                }
                element7 = ShortcutUtils.getNextElement(element7);
            }
        }
        return element;
    }

    private static Element getDocumentNode() {
        if (sDocumentElement == null) {
            try {
                sDocumentElement = ShortcutUtils.getDomDocument(ShortcutUtils.getShortcutsFile()).getDocumentElement();
            }
            catch (Exception exception) {
                ShortcutUtils.recoverFile();
                sDocumentElement = ShortcutUtils.getDocumentNode();
            }
        }
        return sDocumentElement;
    }

    private static void recoverFile() {
        File file = ShortcutUtils.getShortcutsFile();
        if (file.exists()) {
            try {
                String string = ShortcutUtils.getShortcutsFile().getPath().concat("_recovery");
                File file2 = new File(string);
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println(sRes.getString("alert.Corrupted"));
        ShortcutUtils.createInitialFavorites(null);
        ShortcutUtils.notifyListeners(new ShortcutEvent(null, null, 3, null, null));
    }

    private static File getShortcutsFile() {
        if (sIsTesting) {
            return new File(sLocalFilename);
        }
        File file = new File(Prefs.getPropertyDirectory() + sSeparator + sLocalFilename_2);
        if (ShortcutUtils.usingToolstrip() && !file.exists()) {
            try {
                File file2 = new File(Prefs.getPropertyDirectory() + sSeparator + sLocalFilename);
                if (file2.exists()) {
                    ShortcutUtils.copyFile(file2, file);
                } else {
                    boolean bl = ShortcutUtils.checkForPreviousFile(file);
                    if (!bl) {
                        ShortcutUtils.createInitialFavorites(file);
                    }
                }
            }
            catch (IOException iOException) {}
        } else if (!ShortcutUtils.usingToolstrip()) {
            file = new File(Prefs.getPropertyDirectory() + sSeparator + sLocalFilename);
        }
        if (!file.exists()) {
            ShortcutUtils.checkForPreviousFile(file);
        }
        return file;
    }

    private static boolean checkForPreviousFile(File object) {
        File file;
        boolean bl = false;
        String string = Prefs.getPreviousPropertyDirectory();
        if (string != null && (file = new File(string + sSeparator + sLocalFilename)).exists()) {
            Object object2;
            Element element;
            Element element2 = null;
            try {
                sDomDoc = ShortcutUtils.getDomDocument(file);
                element2 = sDomDoc.getDocumentElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Locale.getDefault().getLanguage().equals("ja")) {
                element = ShortcutUtils.findCategoryElement(element2, TOOLBAR_SHORTCUTS_JA_SP3);
                if (element != null) {
                    ShortcutUtils.renameCatagoryElement(element2, TOOLBAR_SHORTCUTS_JA_SP3, ShortcutUtils.getDefaultToolbarCategoryName());
                }
                if ((object2 = ShortcutUtils.findCategoryElement(element2, HELP_FAVS_JA_SP3)) != null) {
                    ShortcutUtils.renameCatagoryElement(element2, HELP_FAVS_JA_SP3, ShortcutUtils.getDefaultHelpCategoryName());
                }
            }
            if ((element = ShortcutUtils.findCategoryElement(element2, ShortcutUtils.getDefaultHelpCategoryName())) != null) {
                object2 = ShortcutUtils.createHelpCategory(element2, null);
                element2.insertBefore((Node)object2, element);
                element2.removeChild(element);
            }
            XMLUtils.replaceTextRecursively((Document)sDomDoc, (Node)element2, (String)"callback", (String)OLD_REL_NOTES_CALLBACK, (String)REL_NOTES_CALLBACK);
            object2 = new File(Prefs.getPropertyDirectory() + sSeparator + sLocalFilename);
            ShortcutUtils.saveDocument((File)object2);
            object = object2;
            bl = true;
        }
        return bl;
    }

    private static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
    }

    static Document getDomDocument(File file) {
        if (sDomDoc == null) {
            sDomDoc = ShortcutUtils.parseForDomDocument(file);
        }
        if (sDomDoc == null && !file.exists()) {
            ShortcutUtils.createInitialFavorites(null);
        } else if (sDomDoc == null && file.exists()) {
            ShortcutUtils.recoverFile();
        }
        return sDomDoc;
    }

    public static String getHelpIconString() {
        return sRes.getString("icon.Help");
    }

    private static String getNodeValueByLabel(Element element, String string) {
        Element element2 = ShortcutUtils.getFirstElement(element);
        if (element2 != null) {
            for (Node node = element2; node != null; node = node.getNextSibling()) {
                if (node == null || !node.getNodeName().equals(string)) continue;
                return node.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    private static String getNodeValueByLabel(SimpleElement simpleElement, String string) {
        SimpleNodeList simpleNodeList = simpleElement.getChildElements();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.elementAt(i);
            if (simpleElement2 == null || ShortcutUtils.isASimpleCategoryNode(simpleElement2) || ShortcutUtils.isASimpleShortcutNode(simpleElement2) || !simpleElement2.getNodeName().equals(string)) continue;
            return simpleElement2.getNodeValue();
        }
        return null;
    }

    public static String getTopLevelNodeName() {
        return NONE;
    }

    private static boolean exists(String string) {
        String[] stringArray;
        for (String string2 : stringArray = ShortcutUtils.getShortcutCategories()) {
            Vector vector = ShortcutUtils.getShortcutsByCategory(string2);
            if (vector != null && !string2.equals(NONE)) {
                Enumeration enumeration = vector.elements();
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    Shortcut shortcut = (Shortcut)enumeration.nextElement();
                    if (!shortcut.getLabel().equals(string)) continue;
                    return true;
                }
                continue;
            }
            if (!string2.equals(NONE)) continue;
            for (int i = 0; i < sTopLevelItems.length; ++i) {
                if (sTopLevelItems[i] instanceof Category || !sTopLevelItems[i].getLabel().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean existsInCategory(String string, String string2) {
        block4: {
            block3: {
                Vector vector = ShortcutUtils.getShortcutsByCategory(string);
                if (vector == null || string.equals(NONE)) break block3;
                Enumeration enumeration = vector.elements();
                if (enumeration == null) break block4;
                while (enumeration.hasMoreElements()) {
                    Shortcut shortcut = (Shortcut)enumeration.nextElement();
                    if (!shortcut.getLabel().equals(string2)) continue;
                    return true;
                }
                break block4;
            }
            if (string.equals(NONE)) {
                for (int i = 0; i < sTopLevelItems.length; ++i) {
                    if (sTopLevelItems[i] instanceof Category || !sTopLevelItems[i].getLabel().equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String[] getShortcutCategories() {
        if (sTopLevelItems == null) {
            ShortcutUtils.parseForItems();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ShortcutUtils.getTopLevelNodeName());
        if (sTopLevelItems != null) {
            for (Shortcut shortcut : sTopLevelItems) {
                if (!(shortcut instanceof Category)) continue;
                arrayList.add(shortcut.getLabel());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Vector getShortcutsByCategory(String string) {
        if (sTopLevelItems == null) {
            ShortcutUtils.parseForItems();
        }
        if (sTopLevelItems == null) {
            return null;
        }
        if (string.equals(NONE)) {
            Vector<Shortcut> vector = new Vector<Shortcut>();
            for (int i = 0; i < sTopLevelItems.length; ++i) {
                if (sTopLevelItems[i] instanceof Category) continue;
                vector.addElement(sTopLevelItems[i]);
            }
            return vector;
        }
        for (int i = 0; i < sTopLevelItems.length; ++i) {
            if (!(sTopLevelItems[i] instanceof Category) || !((Category)sTopLevelItems[i]).getLabel().equals(string)) continue;
            return ((Category)sTopLevelItems[i]).getItems();
        }
        return null;
    }

    private static Shortcut extractShortcutInfoFromElement(Element element) {
        String string = ShortcutUtils.getNodeValueByLabel(element, "label");
        String string2 = ShortcutUtils.getNodeValueByLabel(element, "icon");
        String string3 = ShortcutUtils.getNodeValueByLabel(element, "callback");
        String string4 = ShortcutUtils.getNodeValueByLabel(element, "editable");
        boolean bl = true;
        if (string4 != null) {
            bl = string4.equals("true");
        }
        return new Shortcut(string, string3, string2, bl);
    }

    private static Shortcut extractShortcutInfoFromSimpleElement(SimpleElement simpleElement) {
        String string = ShortcutUtils.getNodeValueByLabel(simpleElement, "label");
        String string2 = ShortcutUtils.getNodeValueByLabel(simpleElement, "icon");
        String string3 = ShortcutUtils.getNodeValueByLabel(simpleElement, "callback");
        String string4 = ShortcutUtils.getNodeValueByLabel(simpleElement, "editable");
        boolean bl = string4.equals("true");
        return new Shortcut(string, string3, string2, bl);
    }

    private static Category extractCategoryInfoFromSimpleElement(SimpleElement simpleElement) {
        String string = ShortcutUtils.getNodeValueByLabel(simpleElement, "name");
        String string2 = ShortcutUtils.getNodeValueByLabel(simpleElement, "icon");
        if (string.equals(ShortcutUtils.getHelpCategoryToStore())) {
            string2 = ShortcutUtils.getHelpCategory();
            string = ShortcutUtils.getHelpCategory();
        }
        if (string.equals(ShortcutUtils.getToolbarCategoryToStore()) && !ShortcutUtils.usingToolstrip()) {
            string2 = ShortcutUtils.getToolbarCategory();
            string = ShortcutUtils.getToolbarCategory();
        }
        return new Category(string, null, string2);
    }

    private static Category extractCategoryInfoFromElement(Element element) {
        String string = ShortcutUtils.getNodeValueByLabel(element, "name");
        String string2 = ShortcutUtils.getNodeValueByLabel(element, "icon");
        if (string.equals(ShortcutUtils.getDefaultHelpCategoryName()) || string.equals(ShortcutUtils.getDefaultToolbarCategoryName()) && !ShortcutUtils.usingToolstrip()) {
            string2 = string;
        }
        return new Category(string, null, string2);
    }

    public static String getDefaultToolbarCategoryName() {
        String string = sRes.getString("node.category.None");
        if (sIsTesting) {
            string = sToolbarCategory;
        }
        return string;
    }

    public static String getDefaultHelpCategoryName() {
        return ShortcutUtils.getHelpCategory();
    }

    private static Category getTopLevelCategoryByName(String string) {
        if (sTopLevelItems == null) {
            ShortcutUtils.parseForItems();
        }
        if (sTopLevelItems != null) {
            for (int i = 0; i < sTopLevelItems.length; ++i) {
                if (!(sTopLevelItems[i] instanceof Category) || !((Category)sTopLevelItems[i]).getLabel().equals(string)) continue;
                return (Category)sTopLevelItems[i];
            }
        }
        return null;
    }

    public static String getTitle() {
        NodeList nodeList = ShortcutUtils.getDocumentNode().getElementsByTagName("title");
        String string = nodeList.item(0).getFirstChild().getNodeValue();
        return string;
    }

    private static void insertNewCategoryNode(String string, Node node) {
        Element element = sDomDoc.createElement("FAVORITECATEGORY");
        Element element2 = sDomDoc.createElement("name");
        Text text = sDomDoc.createTextNode(string);
        element2.appendChild(text);
        element.appendChild(element2);
        node.appendChild(element);
        if (node == ShortcutUtils.getDocumentNode()) {
            sTopLevelItems = null;
        }
        ShortcutUtils.saveAndNotify(null, string, 2, null, null);
    }

    private static void insertShortcutAtBottom(String string, String string2, String string3, String string4, String string5) {
        Element element;
        Element element2;
        Category category = ShortcutUtils.getTopLevelCategoryByName(string4);
        if (category != null) {
            category.addItem(new Shortcut(string, string2, string3, true));
        }
        if ((element2 = ShortcutUtils.findCategoryElement(element = ShortcutUtils.getDocumentNode(), string4)) == null && string4.equals(NONE)) {
            element2 = element;
        } else if (element2 == null) {
            ShortcutUtils.addNewCategory(string4);
            ShortcutUtils.insertShortcutAtBottom(string, string2, string3, string4, string5);
            return;
        }
        Node node = ShortcutUtils.createNewNode(string, string3, string2, string5);
        ShortcutUtils.insertNodeAtBottom(element2, node);
    }

    private static void insertNodeAtBottom(Element element, Node node) {
        element.appendChild(node);
    }

    static void moveUp(Map<Shortcut, Category> map) {
        ShortcutUtils.move(map, true);
    }

    static void moveDown(Map<Shortcut, Category> map) {
        ShortcutUtils.move(map, false);
    }

    private static boolean isOKToMove(String string, String string2, String string3) {
        if (!string.equals(string3) && ShortcutUtils.existsInCategory(string3, string2) && !sIsTesting) {
            MJOptionPane.showMessageDialog(null, (Object)sRes.getString("alert.moveError"), (String)sRes.getString("alert.NewShortcutTitleSameName"), (int)0);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void move(Map<Shortcut, Category> map, boolean bl) {
        void var2_4;
        Object object;
        Iterator<Map.Entry<Shortcut, Category>> iterator = map.entrySet().iterator();
        if (!bl) {
            object = new LinkedList();
            while (iterator.hasNext()) {
                object.add(0, iterator.next());
            }
            Iterator iterator2 = object.iterator();
        }
        while (var2_4.hasNext()) {
            Node node;
            Element element;
            object = (Map.Entry)var2_4.next();
            String string = object.getValue() == null ? ShortcutUtils.getTopLevelNodeName() : ((Category)object.getValue()).getLabel();
            boolean bl2 = ((Shortcut)object.getKey()).isCategory();
            String string2 = ((Shortcut)object.getKey()).getLabel();
            Element element2 = ShortcutUtils.getDocumentNode();
            if (string == null || string.equals("")) {
                string = NONE;
            }
            Element element3 = ShortcutUtils.findCategoryElement(element2, string);
            Element element4 = ShortcutUtils.findElement(string, string2);
            if (bl2) {
                element4 = ShortcutUtils.findCategoryElement(element3, string2);
            }
            if (string.equals(NONE) && element4 == null) {
                element4 = ShortcutUtils.findCategoryElement(element2, string2);
                element3 = element2;
            }
            if (element3 == null || string.equals(NONE)) {
                element3 = element2;
            }
            String string3 = string;
            if (bl) {
                element = ShortcutUtils.getPreviousElement(element4);
                if (element != null) {
                    if (ShortcutUtils.isACategoryNode(element) && !ShortcutUtils.isACategoryNode(element4)) {
                        string3 = ShortcutUtils.getNodeValueByLabel(element, "name");
                        if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                        element.appendChild(element4);
                    } else {
                        if (!ShortcutUtils.isOKToMove(string, string2, string)) return;
                        element3.insertBefore(element4, element);
                    }
                } else {
                    node = ShortcutUtils.getPreviousElement(element3);
                    if (node != null) {
                        if (ShortcutUtils.isACategoryNode((Element)node)) {
                            string3 = ShortcutUtils.getNodeValueByLabel((Element)node, "name");
                            if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                            node.appendChild(element4);
                        } else {
                            string3 = NONE;
                            if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                            element2.insertBefore(element4, element3);
                        }
                    } else {
                        string3 = NONE;
                        if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                        element2.insertBefore(element4, element2.getFirstChild());
                    }
                }
            } else {
                element = ShortcutUtils.getNextElement(element4);
                if (element != null) {
                    if (ShortcutUtils.isACategoryNode(element) && !ShortcutUtils.isACategoryNode(element4)) {
                        string3 = ShortcutUtils.getNodeValueByLabel(element, "name");
                        if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                        node = element.getFirstChild();
                        if (node != null) {
                            element.insertBefore(element4, node);
                        } else {
                            element.appendChild(element4);
                        }
                    } else {
                        string3 = ShortcutUtils.getNodeValueByLabel(element3, "name");
                        if (string3 == null) {
                            string3 = NONE;
                        }
                        if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                        node = ShortcutUtils.getNextElement(element);
                        if (node != null) {
                            element3.insertBefore(element4, node);
                        } else {
                            element3.appendChild(element4);
                        }
                    }
                } else {
                    node = ShortcutUtils.getNextElement(element3);
                    if (node != null) {
                        if (ShortcutUtils.isACategoryNode((Element)node)) {
                            string3 = ShortcutUtils.getNodeValueByLabel((Element)node, "name");
                            if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                            node.insertBefore(element4, node.getFirstChild());
                        } else {
                            string3 = NONE;
                            if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                            element2.insertBefore(element4, node);
                        }
                    } else {
                        string3 = NONE;
                        if (!ShortcutUtils.isOKToMove(string, string2, string3)) return;
                        element2.appendChild(element4);
                    }
                }
            }
            sTopLevelItems = null;
            if (bl2) {
                ShortcutUtils.saveAndNotify(string2, string3, 9, null, string);
                continue;
            }
            ShortcutUtils.saveAndNotify(string2, string3, 7, null, string);
        }
    }

    private static Element getPreviousElement(Element element) {
        Node node;
        for (node = element.getPreviousSibling(); node != null && !ShortcutUtils.isAnElementNode(node); node = node.getPreviousSibling()) {
        }
        if (node != null && node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    private static Element getNextElement(Element element) {
        Node node;
        for (node = element.getNextSibling(); node != null && !ShortcutUtils.isAnElementNode(node); node = node.getNextSibling()) {
        }
        if (node != null && node instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    private static boolean isAnElementNode(Node node) {
        return node instanceof Element && (!(node instanceof Element) || ShortcutUtils.isAShortcutNode((Element)node) || ShortcutUtils.isACategoryNode((Element)node)) && (ShortcutUtils.getNodeValueByLabel((Element)node, "name") == null || !ShortcutUtils.getNodeValueByLabel((Element)node, "name").equals(NONE));
    }

    private static boolean isAShortcutNode(Element element) {
        return element != null && element.getTagName().equals("FAVORITE");
    }

    private static boolean isASimpleShortcutNode(SimpleElement simpleElement) {
        return simpleElement != null && simpleElement.getTagName().equals("FAVORITE");
    }

    private static boolean isACategoryNode(Element element) {
        return element != null && element.getTagName().equals("FAVORITECATEGORY");
    }

    private static boolean isASimpleCategoryNode(SimpleElement simpleElement) {
        return simpleElement != null && simpleElement.getTagName().equals("FAVORITECATEGORY");
    }

    public static Shortcut[] getTopLevelItems() {
        if (sTopLevelItems == null) {
            ShortcutUtils.parseForItems();
        }
        return sTopLevelItems;
    }

    private static void parseForItems() {
        block19: {
            File file = ShortcutUtils.getShortcutsFile();
            sTopLevelItems = null;
            if (!sFirstRead || !file.exists()) {
                try {
                    Element element = ShortcutUtils.getDocumentNode();
                    Element element2 = ShortcutUtils.getFirstElement(element);
                    if (element2 != null) {
                        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
                        while (element2 != null) {
                            Category category;
                            if (element2 != null && ShortcutUtils.isAShortcutNode(element2)) {
                                arrayList.add(ShortcutUtils.extractShortcutInfoFromElement(element2));
                            } else if (element2 != null && ShortcutUtils.isACategoryNode(element2) && (category = ShortcutUtils.getCategory(element2)) != null) {
                                arrayList.add(category);
                            }
                            element2 = ShortcutUtils.getNextElement(element2);
                        }
                        sTopLevelItems = arrayList.toArray(new Shortcut[0]);
                    }
                    break block19;
                }
                catch (Exception exception) {
                    if (sReEntrantProtection) {
                        ShortcutUtils.recoverFile();
                        ShortcutUtils.parseForItems();
                        sReEntrantProtection = false;
                    }
                    break block19;
                }
            }
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, sEncoding);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                sSimpleRoot = simpleDOMParser.parse((Reader)bufferedReader);
                String string = sSimpleRoot.getAttribute("version");
                if (string == null || string != null && !string.equals(CURRENT_VERSION)) {
                    int n = -1;
                    if (string != null) {
                        n = new Integer(string);
                    }
                    ShortcutUtils.fixOutdatedFile(n);
                    sFirstRead = false;
                    ShortcutUtils.parseForItems();
                    return;
                }
                SimpleNodeList simpleNodeList = sSimpleRoot.getChildElements();
                ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
                for (int i = 0; i < simpleNodeList.getLength(); ++i) {
                    Category category;
                    SimpleElement simpleElement = (SimpleElement)simpleNodeList.elementAt(i);
                    if (simpleElement == null) continue;
                    if (ShortcutUtils.isASimpleShortcutNode(simpleElement)) {
                        arrayList.add(ShortcutUtils.extractShortcutInfoFromSimpleElement(simpleElement));
                        continue;
                    }
                    if (!ShortcutUtils.isASimpleCategoryNode(simpleElement) || (category = ShortcutUtils.getSimpleCategory(simpleElement)) == null) continue;
                    arrayList.add(category);
                }
                sTopLevelItems = arrayList.toArray(new Shortcut[0]);
            }
            catch (Exception exception) {
                try {
                    inputStreamReader.close();
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!sReEntrantProtection) break block19;
                ShortcutUtils.recoverFile();
                ShortcutUtils.parseForItems();
                sReEntrantProtection = false;
            }
        }
        if (ShortcutUtils.usingToolstrip() && sFirstRead) {
            ShortcutUtils.updateForToolstrip();
        } else {
            sFirstRead = false;
        }
    }

    private static void updateForToolstrip() {
        ShortcutUtils.renameDuplicates();
        Vector vector = ShortcutUtils.getShortcutsByCategory(sToolbarCategory);
        if (vector == null) {
            vector = ShortcutUtils.getShortcutsByCategory(sToolbarCategoryToStore);
        }
        if (vector != null) {
            for (Shortcut shortcut : vector) {
                if (shortcut.getLabel().equals(sRes.getString("toolbar.Default")) || shortcut.getLabel().equals("How to Add") || shortcut.getLabel().equals(sRes.getString("toolbar.WhatsNew")) || shortcut.getLabel().equals("What's New")) continue;
                ShortcutUtils.insertShortcutAtBottom(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIconPath(), NONE, Boolean.toString(shortcut.isEditable()));
            }
            ShortcutUtils.removeShortcutCategory(sToolbarCategory);
            ShortcutUtils.removeShortcutCategory(sToolbarCategoryToStore);
            if (ShortcutUtils.getShortcutsByCategory(SIMBIOLOGY_CATEGORY) != null) {
                ShortcutUtils.removeShortcutCategory(SIMBIOLOGY_CATEGORY);
            }
        }
        ShortcutUtils.remove(ShortcutUtils.getTopLevelNodeName(), sRes.getString("invisible.Default"));
        sFirstRead = false;
        ShortcutUtils.parseForItems();
    }

    private static void renameDuplicates() {
        Object object;
        Enumeration enumeration;
        Object object2;
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        String[] stringArray = ShortcutUtils.getShortcutCategories();
        for (String string : stringArray) {
            object2 = ShortcutUtils.getShortcutsByCategory(string);
            if (object2 != null && !string.equals(NONE)) {
                enumeration = ((Vector)object2).elements();
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    object = (Shortcut)enumeration.nextElement();
                    arrayListMultimap.put((Object)((Shortcut)object).getLabel(), (Object)new ShortcutCat((Shortcut)object, string));
                }
                continue;
            }
            if (!string.equals(NONE)) continue;
            for (int i = 0; i < sTopLevelItems.length; ++i) {
                if (sTopLevelItems[i] instanceof Category) continue;
                arrayListMultimap.put((Object)sTopLevelItems[i].getLabel(), (Object)new ShortcutCat(sTopLevelItems[i], string));
            }
        }
        for (String string : arrayListMultimap.keySet()) {
            List list = arrayListMultimap.get((Object)string);
            for (int i = 0; i < list.size(); ++i) {
                NodeList nodeList;
                if (i <= 0) continue;
                object2 = (ShortcutCat)list.get(i);
                enumeration = ((ShortcutCat)object2).iShortcut.getLabel() + "(" + (i + 1) + ")";
                object = ShortcutUtils.findElement(((ShortcutCat)object2).iCategory, ((ShortcutCat)object2).iShortcut.getLabel());
                if (object == null || !(nodeList = object.getElementsByTagName("editable")).item(0).getFirstChild().getNodeValue().equals("true")) continue;
                ShortcutUtils.setNodeValueByLabel((Element)object, "label", (String)((Object)enumeration));
                Category category = ShortcutUtils.getTopLevelCategoryByName(((ShortcutCat)object2).iCategory);
                if (category != null) {
                    Shortcut shortcut = (Shortcut)category.getObject(((ShortcutCat)object2).iShortcut.getLabel());
                    shortcut.setLabel((String)((Object)enumeration));
                }
                ShortcutUtils.saveDocument(ShortcutUtils.getShortcutsFile());
            }
        }
    }

    private static void fixOutdatedFile(int n) {
        if (n == -1) {
            try {
                Element element = ShortcutUtils.getDocumentNode();
                element.setAttribute("version", CURRENT_VERSION);
                NodeList nodeList = element.getElementsByTagName("FAVORITECATEGORY");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    NodeList nodeList2 = element2.getElementsByTagName("name");
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        String string = nodeList2.item(j).getFirstChild().getNodeValue();
                        NodeList nodeList3 = element2.getElementsByTagName("FAVORITE");
                        if (!string.equals(NONE) || nodeList3.getLength() <= 0) continue;
                        for (int k = 0; k < nodeList3.getLength(); ++k) {
                            Element element3 = (Element)nodeList3.item(k);
                            element.appendChild(element3.cloneNode(true));
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ShortcutUtils.saveDocument(ShortcutUtils.getShortcutsFile());
    }

    private static Category getSimpleCategory(SimpleElement simpleElement) {
        Category category = ShortcutUtils.extractCategoryInfoFromSimpleElement(simpleElement);
        if (category.getLabel().equals(NONE)) {
            return null;
        }
        SimpleNodeList simpleNodeList = simpleElement.getChildElements();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.elementAt(i);
            if (simpleElement2 == null) continue;
            if (ShortcutUtils.isASimpleShortcutNode(simpleElement2)) {
                category.addItem(ShortcutUtils.extractShortcutInfoFromSimpleElement(simpleElement2));
                continue;
            }
            if (!ShortcutUtils.isASimpleCategoryNode(simpleElement2)) continue;
            category.addItem(ShortcutUtils.getSimpleCategory(simpleElement2));
        }
        return category;
    }

    private static Category getCategory(Element element) {
        Category category = ShortcutUtils.extractCategoryInfoFromElement(element);
        if (category.getLabel().equals(NONE)) {
            return null;
        }
        Element element2 = ShortcutUtils.getFirstElement(element);
        if (element2 != null) {
            Element element3 = element2;
            element3 = element2;
            while (element3 != null) {
                if (ShortcutUtils.isAShortcutNode(element3)) {
                    Shortcut shortcut = ShortcutUtils.extractShortcutInfoFromElement(element3);
                    category.addItem(shortcut);
                } else if (ShortcutUtils.isACategoryNode(element3)) {
                    category.addItem(ShortcutUtils.getCategory(element3));
                }
                element3 = ShortcutUtils.getNextElement(element3);
            }
        }
        return category;
    }

    private static Element getFirstElement(Element element) {
        Node node;
        for (node = element.getFirstChild(); !(node instanceof Element) && node != null; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    private static Document parseForDomDocument(File file) {
        Document document = null;
        try {
            Object object;
            if (sDocBuilder == null) {
                object = DocumentBuilderFactory.newInstance();
                sDocBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            try {
                object = new FileInputStream(file);
                document = sDocBuilder.parse((InputStream)object);
            }
            catch (SAXParseException sAXParseException) {
                System.out.println("Could not parse " + file.getName());
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            ShortcutUtils.fixPermanentCategoryNames(document, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    private static void removeNode(Node node, Element element) {
        if (element != null && node != null) {
            element.removeChild(node);
        }
    }

    public static void removeShortcut(String string, String string2) {
        if (!string.equals(NONE)) {
            Category category = ShortcutUtils.getTopLevelCategoryByName(string);
            Shortcut shortcut = (Shortcut)category.getObject(string2);
            category.removeItem(shortcut);
        }
        ShortcutUtils.remove(string, string2);
        sTopLevelItems = null;
        ShortcutUtils.saveAndNotify(string2, string, 1, null, null);
    }

    static void removeShortcutCategory(String string) {
        Element element = ShortcutUtils.findCategoryElement(ShortcutUtils.getDocumentNode(), string);
        if (element != null) {
            ShortcutUtils.getDocumentNode().removeChild(element);
            sTopLevelItems = null;
            ShortcutUtils.saveAndNotify(null, string, 5, null, null);
        }
    }

    private static void remove(String string, String string2) {
        Element element = ShortcutUtils.findCategoryElement(ShortcutUtils.getDocumentNode(), string);
        if (string.equals(NONE)) {
            element = ShortcutUtils.getDocumentNode();
        }
        if (string2 == null) {
            ShortcutUtils.removeShortcutCategory(string);
        } else {
            Element element2 = ShortcutUtils.findElement(string, string2);
            ShortcutUtils.removeNode(element2, element);
        }
    }

    static void restoreDefaults() {
        ShortcutUtils.createInitialFavorites(null);
        ShortcutUtils.notifyListeners(new ShortcutEvent(null, null, 3, null, null));
    }

    private static void saveAndNotify(String string, String string2, int n, String string3, String string4) {
        ShortcutUtils.saveDocument(ShortcutUtils.getShortcutsFile());
        ShortcutUtils.notifyListeners(new ShortcutEvent(string, string2, n, string3, string4));
    }

    private static void fixPermanentCategoryNames(Document document, boolean bl) {
        NodeList nodeList = document.getElementsByTagName("name");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (bl) {
                if (node.getTextContent().equals(sToolbarCategory) && !ShortcutUtils.usingToolstrip()) {
                    node.setTextContent(sToolbarCategoryToStore);
                }
                if (!node.getTextContent().equals(sHelpCategory)) continue;
                node.setTextContent(sHelpCategoryToStore);
                continue;
            }
            if (node.getTextContent().equals(sToolbarCategoryToStore) && !ShortcutUtils.usingToolstrip()) {
                node.setTextContent(sToolbarCategory);
            }
            if (!node.getTextContent().equals(sHelpCategoryToStore)) continue;
            node.setTextContent(sHelpCategory);
        }
    }

    private static void saveDocument(File file) {
        block5: {
            OutputStreamWriter outputStreamWriter = null;
            try {
                ShortcutUtils.fixPermanentCategoryNames(sDomDoc, true);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, sEncoding);
                XMLUtils.serializeXML((Object)sDomDoc, (Object)outputStreamWriter, (String)sEncoding);
                outputStreamWriter.close();
                ShortcutUtils.fixPermanentCategoryNames(sDomDoc, false);
            }
            catch (Exception exception) {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                File file2 = ShortcutUtils.getShortcutsFile();
                if (!file2.exists()) break block5;
                file2.delete();
            }
        }
    }

    private static void setNodeValueByLabel(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName(string);
        nodeList.item(0).getFirstChild().setNodeValue(string2);
    }

    public static void addFavoritesListener(ActionListener actionListener) {
        sListenerList.add(ActionListener.class, actionListener);
    }

    public static void removeFavoritesListener(ActionListener actionListener) {
        sListenerList.remove(ActionListener.class, actionListener);
    }

    private static void notifyListeners(ShortcutEvent shortcutEvent) {
        ShortcutUtils.fireFavoritesChangedPerformed(shortcutEvent);
    }

    private static void fireFavoritesChangedPerformed(ShortcutEvent shortcutEvent) {
        Object[] objectArray = sListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(shortcutEvent);
        }
    }

    private static boolean isDoneResetting() {
        return sIsDoneCreating;
    }

    private static void resetCreatingFavsFlag() {
        sIsDoneCreating = false;
    }

    private static void setTestingFlag() {
        sIsTesting = true;
        sDomDoc = null;
    }

    private static void setLocalFilenameForTesting(String string) {
        sLocalFilename = string + ".xml";
        ShortcutUtils.setTestingFlag();
    }

    static {
        sFirstRead = true;
        sReEntrantProtection = true;
        sSimpleRoot = null;
        sEncoding = "utf-8";
        sFavHandler = new ShortcutUtils();
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            if (ShortcutUtils.usingToolstrip()) {
                sXMLFileName = sJaXMLFileName + "_2";
                sLocalFilename_2 = sXMLFileName + ".xml";
                sLocalFilename = sJaXMLFileName + ".xml";
            } else {
                sXMLFileName = sJaXMLFileName;
                sLocalFilename = sXMLFileName + ".xml";
            }
        }
        sIsDoneCreating = true;
        sIsTesting = false;
    }

    public static class ShortcutEvent
    extends ActionEvent {
        public static final int APPENDED = 0;
        public static final int REMOVED = 1;
        public static final int NEWCATEGORY = 2;
        public static final int CHANGEALL = 3;
        public static final int EDITED = 4;
        public static final int REMOVEDCAT = 5;
        public static final int MOVEDUP = 6;
        public static final int MOVEDDOWN = 7;
        public static final int CATMOVEDUP = 8;
        public static final int CATMOVEDDOWN = 9;
        private int fType = 0;
        private String fName = null;
        private String fCategory = null;
        private String fOldName = null;
        private String fOldCat = null;

        public ShortcutEvent(String string, String string2, int n, String string3, String string4) {
            super(sFavHandler, 0, "FavoriteChanged");
            this.fName = string;
            this.fCategory = string2;
            this.fType = n;
            this.fOldName = string3;
            this.fOldCat = string4;
        }

        public int getType() {
            return this.fType;
        }

        public String getName() {
            return this.fName;
        }

        public String getCategory() {
            return this.fCategory;
        }

        public String getOldName() {
            return this.fOldName;
        }

        public String getOldCategory() {
            return this.fOldCat;
        }
    }

    private static class ShortcutCat {
        Shortcut iShortcut;
        String iCategory;

        private ShortcutCat(Shortcut shortcut, String string) {
            this.iShortcut = shortcut;
            this.iCategory = string;
        }
    }
}

