/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace.util;

import com.mathworks.common.icons.VariableIcon;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import javax.swing.ImageIcon;

public final class WorkspaceIcon {
    public static ImageIcon getNumericIcon() {
        return VariableIcon.MATRIX.getIcon();
    }

    public static ImageIcon getCharIcon() {
        return VariableIcon.STRING.getIcon();
    }

    public static ImageIcon getCellIcon() {
        return VariableIcon.CELL.getIcon();
    }

    public static ImageIcon getStructureIcon() {
        return VariableIcon.STRUCT.getIcon();
    }

    public static ImageIcon getSparseIcon() {
        return VariableIcon.SPARSE.getIcon();
    }

    public static ImageIcon getObjectIcon() {
        return VariableIcon.OBJECT.getIcon();
    }

    public static ImageIcon getLogicalIcon() {
        return VariableIcon.LOGIC.getIcon();
    }

    public static ImageIcon getTimeseriesIcon() {
        return VariableIcon.TIMESERIES.getIcon();
    }

    public static ImageIcon getDefaultIcon() {
        return WorkspaceIcon.getNumericIcon();
    }

    public static ImageIcon getNonexistentIcon() {
        return VariableIcon.NONEXISTENT.getIcon();
    }

    public static ImageIcon getDatasetIcon() {
        return VariableIcon.DATASET.getIcon();
    }

    public static ImageIcon getIcon(String string) {
        if (string == null) {
            return WorkspaceIcon.getNumericIcon();
        }
        if (string.endsWith("(sparse)")) {
            return WorkspaceIcon.getSparseIcon();
        }
        if (WorkspaceCommands.isBuiltinNumericType(string)) {
            return WorkspaceIcon.getNumericIcon();
        }
        if (WorkspaceCommands.isBuiltinCharType(string)) {
            return WorkspaceIcon.getCharIcon();
        }
        if (string.equals("logical") || string.startsWith("logical ")) {
            return WorkspaceIcon.getLogicalIcon();
        }
        if (string.equals("cell") || string.startsWith("cell ")) {
            return WorkspaceIcon.getCellIcon();
        }
        if (string.equals("struct") || string.startsWith("struct ")) {
            return WorkspaceIcon.getStructureIcon();
        }
        if (WorkspaceCommands.isTimeseriesType(string)) {
            return WorkspaceIcon.getTimeseriesIcon();
        }
        if (WorkspaceCommands.isDatasetType(string)) {
            return WorkspaceIcon.getDatasetIcon();
        }
        if (string.contains(" object")) {
            return WorkspaceIcon.getObjectIcon();
        }
        if (string.length() == 0) {
            return WorkspaceIcon.getNumericIcon();
        }
        if (!string.contains(" ")) {
            return WorkspaceIcon.getObjectIcon();
        }
        return WorkspaceIcon.getNumericIcon();
    }

    public static int getMaxIconHeight() {
        return 16;
    }

    private WorkspaceIcon() {
    }
}

