/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view;

import com.mathworks.mwswing.MJPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class ColumnLayoutConstraints {
    private final List<MJPanel> fPanels = new ArrayList<MJPanel>();
    private Integer fMinWidth;
    private Integer fMaxWidth;
    private Integer fPrefWidth;

    public MJPanel createPanel() {
        MJPanel mJPanel = new MJPanel(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.width = ColumnLayoutConstraints.this.getMaxWidth();
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = ColumnLayoutConstraints.this.getMinWidth();
                return dimension;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = ColumnLayoutConstraints.this.getPrefWidth();
                return dimension;
            }
        };
        this.fPanels.add(mJPanel);
        return mJPanel;
    }

    public void setMinWidth(int n) {
        this.fMinWidth = n;
    }

    public void setPrefWidth(int n) {
        this.fPrefWidth = n;
    }

    public void setMaxWidth(int n) {
        this.fMaxWidth = n;
    }

    private int getMinWidth() {
        if (this.fMinWidth != null) {
            return this.fMinWidth;
        }
        int n = 0;
        for (MJPanel mJPanel : this.fPanels) {
            n = Math.max(n, mJPanel.getLayout().minimumLayoutSize((Container)mJPanel).width);
        }
        return n;
    }

    private int getMaxWidth() {
        if (this.fMaxWidth != null) {
            return this.fMaxWidth;
        }
        int n = Short.MAX_VALUE;
        for (MJPanel mJPanel : this.fPanels) {
            n = Math.min(n, ((LayoutManager2)mJPanel.getLayout()).maximumLayoutSize((Container)mJPanel).width);
        }
        return n;
    }

    private int getPrefWidth() {
        if (this.fPrefWidth != null) {
            return this.fPrefWidth;
        }
        int n = 0;
        for (MJPanel mJPanel : this.fPanels) {
            n = Math.max(n, mJPanel.getLayout().preferredLayoutSize((Container)mJPanel).width);
        }
        return n;
    }
}

