/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.services.view.wizard;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.toolbox.distcomp.admincenter.guiutilities.ACHelpBrowser;
import com.mathworks.toolbox.distcomp.admincenter.services.model.StartMDCEWizardModel;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.CommunicationPage;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.ConfirmPage;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.HelpSupport;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.LocationPage;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.PlatformPage;
import com.mathworks.toolbox.distcomp.admincenter.services.view.wizard.SummaryPage;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerOrLocalShellSender;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCShellSender;
import com.mathworks.toolbox.distcomp.control.servicerequest.MdceShellCommand;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.FutureMonitor;
import com.mathworks.toolbox.distcomp.remote.NoCommonProtocolSetException;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteStreamException;
import com.mathworks.toolbox.distcomp.remote.SimpleShellFuture;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import com.mathworks.toolbox.distcomp.util.Version;
import com.mathworks.toolbox.distcomp.util.concurrent.ReentrantLock;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class StartMDCEWizardDialog
extends WizardDialog {
    private StartMDCEWizardModel fStartMdceWizardModel;
    private SummaryPage fSummaryPage;
    public static final String START_BUTTON_NAME = "start";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.admincenter.services.view.resources.RES_view");
    private static final int WIZARD_WIDTH = 610;
    private static final int WIZARD_HEIGHT = 410;
    public static final int FINISH = 0;
    public static final int CANCELLED = -1;
    public static final int CANCELLED_WHILE_STARTING = 0;
    private final Lock fLock = new ReentrantLock();
    private FutureMonitor fInstallMdceFutureMonitor;
    private FutureMonitor fVersionMdceFutureMonitor;
    private FutureMonitor fStartMdceFutureMonitor;
    private boolean fUserClickedCancel = false;

    public StartMDCEWizardDialog(StartMDCEWizardModel startMDCEWizardModel) {
        WizardStyle.setStyle((int)2);
        this.fStartMdceWizardModel = startMDCEWizardModel;
        this.setTitle(sRes.getString("services.dialog.startmdce"));
        PlatformPage platformPage = new PlatformPage(startMDCEWizardModel);
        CommunicationPage communicationPage = new CommunicationPage(startMDCEWizardModel);
        LocationPage locationPage = new LocationPage(startMDCEWizardModel);
        ConfirmPage confirmPage = new ConfirmPage(startMDCEWizardModel);
        this.fSummaryPage = new SummaryPage();
        PageList pageList = new PageList();
        pageList.append((AbstractDialogPage)platformPage);
        pageList.append((AbstractDialogPage)communicationPage);
        pageList.append((AbstractDialogPage)locationPage);
        pageList.append((AbstractDialogPage)confirmPage);
        pageList.append((AbstractDialogPage)this.fSummaryPage);
        this.setPageList(pageList);
        this.setStepsPaneNavigable(false);
        this.setSize(610, 410);
        this.setResizable(true);
        this.setName("StartMDCEWizardDialog");
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = super.createButtonPanel();
        this.setCancelAction((AbstractAction)new MJAbstractAction(sRes.getString("services.dialog.startmdce.cancel.button")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                StartMDCEWizardDialog.this.fLock.lock();
                try {
                    StartMDCEWizardDialog.this.fUserClickedCancel = true;
                    if (StartMDCEWizardDialog.this.fVersionMdceFutureMonitor != null) {
                        StartMDCEWizardDialog.this.fVersionMdceFutureMonitor.cancel();
                    }
                    if (StartMDCEWizardDialog.this.fInstallMdceFutureMonitor != null) {
                        StartMDCEWizardDialog.this.fInstallMdceFutureMonitor.cancel();
                    }
                    if (StartMDCEWizardDialog.this.fStartMdceFutureMonitor != null) {
                        StartMDCEWizardDialog.this.fStartMdceFutureMonitor.cancel();
                    }
                    if (StartMDCEWizardDialog.this.fVersionMdceFutureMonitor != null || StartMDCEWizardDialog.this.fInstallMdceFutureMonitor != null || StartMDCEWizardDialog.this.fStartMdceFutureMonitor != null) {
                        StartMDCEWizardDialog.this.setDialogResult(0);
                    } else {
                        StartMDCEWizardDialog.this.setDialogResult(-1);
                    }
                }
                finally {
                    StartMDCEWizardDialog.this.fLock.unlock();
                }
                StartMDCEWizardDialog.this.setVisible(false);
                StartMDCEWizardDialog.this.dispose();
            }
        });
        this.setBackAction((AbstractAction)new MJAbstractAction(sRes.getString("services.dialog.startmdce.back.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = StartMDCEWizardDialog.this.getVisitedPages().size() - 1;
                StartMDCEWizardDialog.this.setCurrentPage((AbstractDialogPage)StartMDCEWizardDialog.this.getVisitedPages().get(n), true);
                if (ACHelpBrowser.isBrowserOpen()) {
                    StartMDCEWizardDialog.this.showCurrentHelp();
                }
            }
        });
        this.setNextAction((AbstractAction)new MJAbstractAction(sRes.getString("services.dialog.startmdce.next.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                StartMDCEWizardDialog.this.setCurrentPage(null, false);
                if (ACHelpBrowser.isBrowserOpen()) {
                    StartMDCEWizardDialog.this.showCurrentHelp();
                }
            }
        });
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(sRes.getString("services.dialog.startmdce.start.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                StartMDCEWizardDialog.this.fSummaryPage.updateUIForStart();
                StartMDCEWizardDialog.this.setCurrentPage(SummaryPage.PAGE_NAME);
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        StartMDCEWizardDialog.this.checkMdceVersion();
                    }
                });
                thread.start();
                if (ACHelpBrowser.isBrowserOpen()) {
                    StartMDCEWizardDialog.this.showCurrentHelp();
                }
            }
        });
        mJButton.setName(START_BUTTON_NAME);
        buttonPanel.addButton((AbstractButton)mJButton, (Object)"ALTERNATIVE");
        MJButton mJButton2 = new MJButton((Action)new MJAbstractAction(sRes.getString("services.dialog.startmdce.help.button")){

            public void actionPerformed(ActionEvent actionEvent) {
                StartMDCEWizardDialog.this.showCurrentHelp();
            }
        });
        mJButton2.setName("HELP");
        buttonPanel.addButton((AbstractButton)mJButton2, (Object)"HELP");
        return buttonPanel;
    }

    private void showCurrentHelp() {
        ACHelpBrowser.browseToShortcut((Component)((Object)this), ((HelpSupport)this.getCurrentPage()).getHelpPageShortCut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMdceVersion() {
        PathUtils.Platform platform = this.getPlatform();
        String string = this.fStartMdceWizardModel.getMatlabRoot();
        MdceShellCommand mdceShellCommand = MdceShellCommand.createVersionMdceShellCommand(string, platform);
        this.fLock.lock();
        try {
            if (!this.fUserClickedCancel) {
                this.fVersionMdceFutureMonitor = this.createFutureMonitorForMdcsCommand(mdceShellCommand, new VersionMdceFutureMonitorCallback());
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    private PathUtils.Platform getPlatform() {
        PathUtils.Platform platform = this.fStartMdceWizardModel.getPlatformType().isWindows() ? new PathUtils.Platform(this.fStartMdceWizardModel.getPlatformType(), PathUtils.Separator.BACKSLASH) : new PathUtils.Platform(this.fStartMdceWizardModel.getPlatformType(), PathUtils.Separator.SLASH);
        return platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installStartMdceServices() {
        PathUtils.Platform platform = this.getPlatform();
        String string = this.fStartMdceWizardModel.getMatlabRoot();
        String string2 = this.fStartMdceWizardModel.getMdceDefFile();
        MdceShellCommand mdceShellCommand = MdceShellCommand.createInstallMdceShellCommand(string, string2, platform);
        this.fLock.lock();
        try {
            if (!this.fUserClickedCancel) {
                this.fInstallMdceFutureMonitor = this.createFutureMonitorForMdcsCommand(mdceShellCommand, new InstallMdceFutureMonitorCallback());
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMdceServices() {
        PathUtils.Platform platform = this.getPlatform();
        String string = this.fStartMdceWizardModel.getMatlabRoot();
        String string2 = this.fStartMdceWizardModel.getMdceDefFile();
        MdceShellCommand mdceShellCommand = MdceShellCommand.createStartMdceShellCommand(string, string2, platform);
        this.fLock.lock();
        try {
            if (!this.fUserClickedCancel) {
                this.fStartMdceFutureMonitor = this.createFutureMonitorForMdcsCommand(mdceShellCommand, new StartMdceFutureMonitorCallback());
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    private FutureMonitor createFutureMonitorForMdcsCommand(MdceShellCommand mdceShellCommand, FutureMonitor.FutureMonitorCallback futureMonitorCallback) {
        FutureMonitor futureMonitor;
        block7: {
            HashSet<String> hashSet = new HashSet<String>(this.fStartMdceWizardModel.getHostNames());
            PathUtils.PlatformType platformType = this.fStartMdceWizardModel.getPlatformType();
            ParameterMap parameterMap = this.fStartMdceWizardModel.getParameterMap();
            if (StartMDCEWizardModel.getParameterSet(platformType).equals(PeerOrLocalShellSender.PEER_OR_LOCAL_PARAMETER_SET)) {
                parameterMap.put(PathUtils.MatlabRootParameter.MATLAB_ROOT, this.fStartMdceWizardModel.getMatlabRoot());
                parameterMap.put(PeerSCShellSender.PeerSCParameter.PORT, PortConfig.getRemoteExecutionPort(this.fStartMdceWizardModel.getBasePort()));
            }
            futureMonitor = null;
            try {
                futureMonitor = new FutureMonitor((Command)mdceShellCommand, hashSet, parameterMap, platformType, futureMonitorCallback);
            }
            catch (NoCommonProtocolSetException noCommonProtocolSetException) {
                assert (false) : noCommonProtocolSetException.getMessage();
            }
            catch (NoMatchingProtocolException noMatchingProtocolException) {
                assert (false) : noMatchingProtocolException.getMessage();
            }
            catch (InterruptedException interruptedException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)interruptedException.getMessage());
            }
        }
        return futureMonitor;
    }

    private static void runOnEDTThread(final Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    private static String getPotentialErrorMessage(SimpleShellFuture simpleShellFuture) {
        String string = null;
        try {
            if (simpleShellFuture.getExitStatus() != 0) {
                string = simpleShellFuture.getErrorString() + "\n" + simpleShellFuture.getOutputString();
            }
        }
        catch (InterruptedException interruptedException) {
            string = interruptedException.getMessage();
        }
        catch (FulfillmentException fulfillmentException) {
            string = fulfillmentException.getMessage();
        }
        return string;
    }

    private static abstract class AbstractMdceFutureMonitorCallback
    implements FutureMonitor.FutureMonitorCallback {
        protected Map<String, SimpleShellFuture> iMapHostNamesSimpleShellFutures;
        protected Map<String, RemoteExecutionException> iMapHostNamesRemoteExceptions = new HashMap<String, RemoteExecutionException>();

        private AbstractMdceFutureMonitorCallback() {
        }

        @Override
        public void commandStarted(String string, Future future) {
        }

        @Override
        public void commandsStarted(Map<String, Future> map) {
            block2: {
                try {
                    this.iMapHostNamesSimpleShellFutures = SimpleShellFuture.createSimpleShellFutures(map);
                }
                catch (RemoteStreamException remoteStreamException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)remoteStreamException.getMessage());
                }
            }
        }

        @Override
        public void exceptionCaught(String string, RemoteExecutionException remoteExecutionException) {
            this.iMapHostNamesRemoteExceptions.put(string, remoteExecutionException);
        }

        @Override
        public void commandEnded(String string, Future future) {
        }
    }

    private class VersionMdceFutureMonitorCallback
    extends AbstractMdceFutureMonitorCallback {
        private VersionMdceFutureMonitorCallback() {
        }

        @Override
        public void commandsEnded(Map<String, Future> map, Map<String, RemoteExecutionException> map2) {
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2;
                block10: {
                    String string3 = StartMDCEWizardDialog.getPotentialErrorMessage((SimpleShellFuture)this.iMapHostNamesSimpleShellFutures.get(string));
                    if (string3 != null) {
                        hashMap.put(string, string3);
                        continue;
                    }
                    string2 = null;
                    try {
                        string2 = ((SimpleShellFuture)this.iMapHostNamesSimpleShellFutures.get(string)).getOutputString();
                    }
                    catch (FulfillmentException fulfillmentException) {
                        assert (false) : "This should not occur here. We are already got the exit code.";
                    }
                    catch (InterruptedException interruptedException) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)"This should not occur here. We are already got the exit code.");
                    }
                }
                if ((string2 = string2.trim()).equals(Version.VERSION_STRING)) continue;
                hashMap.put(string, MessageFormat.format(sRes.getString("services.dialog.startmdce.error.versionmismatch"), StartMDCEWizardDialog.this.fStartMdceWizardModel.getMatlabRoot(), string, string2, Version.VERSION_STRING));
            }
            for (String string : this.iMapHostNamesRemoteExceptions.keySet()) {
                hashMap.put(string, ((RemoteExecutionException)this.iMapHostNamesRemoteExceptions.get(string)).getMessage());
            }
            if (hashMap.isEmpty()) {
                if (StartMDCEWizardDialog.this.fStartMdceWizardModel.getPlatformType().isWindows()) {
                    StartMDCEWizardDialog.this.installStartMdceServices();
                } else {
                    StartMDCEWizardDialog.this.startMdceServices();
                }
                return;
            }
            StartMDCEWizardDialog.runOnEDTThread(new Runnable(){

                @Override
                public void run() {
                    StartMDCEWizardDialog.this.fSummaryPage.updateUIForError(hashMap, StartMDCEWizardDialog.this.fStartMdceWizardModel.getHostNames());
                }
            });
        }
    }

    private class InstallMdceFutureMonitorCallback
    extends AbstractMdceFutureMonitorCallback {
        private InstallMdceFutureMonitorCallback() {
        }

        @Override
        public void commandsEnded(Map<String, Future> map, Map<String, RemoteExecutionException> map2) {
            StartMDCEWizardDialog.this.startMdceServices();
        }
    }

    private class StartMdceFutureMonitorCallback
    extends AbstractMdceFutureMonitorCallback {
        private StartMdceFutureMonitorCallback() {
        }

        @Override
        public void commandsEnded(Map<String, Future> map, Map<String, RemoteExecutionException> map2) {
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2 = StartMDCEWizardDialog.getPotentialErrorMessage((SimpleShellFuture)this.iMapHostNamesSimpleShellFutures.get(string));
                if (string2 == null) continue;
                hashMap.put(string, string2);
            }
            for (String string : this.iMapHostNamesRemoteExceptions.keySet()) {
                hashMap.put(string, ((RemoteExecutionException)this.iMapHostNamesRemoteExceptions.get(string)).getMessage());
            }
            if (hashMap.isEmpty()) {
                StartMDCEWizardDialog.runOnEDTThread(new Runnable(){

                    @Override
                    public void run() {
                        StartMDCEWizardDialog.this.fSummaryPage.updateUIForSuccess();
                    }
                });
            } else {
                StartMDCEWizardDialog.runOnEDTThread(new Runnable(){

                    @Override
                    public void run() {
                        StartMDCEWizardDialog.this.fSummaryPage.updateUIForError(hashMap, StartMDCEWizardDialog.this.fStartMdceWizardModel.getHostNames());
                    }
                });
            }
        }
    }
}

