/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.admincenter.testing.infra.test;

import com.mathworks.toolbox.distcomp.admincenter.testing.infra.Node;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.Result;
import com.mathworks.toolbox.distcomp.admincenter.testing.infra.test.TestStatus;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.ReturnStatus;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestCategory;
import com.mathworks.toolbox.distcomp.admincenter.testing.shared.TestResult;
import java.util.Date;

public class TestInfo
implements TestResult {
    private String fDescription = "no description yet";
    private Node fExecutingNode = null;
    private Node fReceivingNode = null;
    private Result fResult = null;
    private Date fStartTime = null;
    private Date fStopTime = null;
    private TestCategory fTestCategory = null;
    private TestStatus fTestStatus = null;

    public TestInfo(Node node, Node node2, TestCategory testCategory) {
        this.fExecutingNode = node;
        this.fReceivingNode = node2;
        this.fTestCategory = testCategory;
    }

    @Override
    public TestCategory getTestCategory() {
        return this.fTestCategory;
    }

    @Override
    public Node getExecutingNode() {
        return this.fExecutingNode;
    }

    @Override
    public Node getReceivingNode() {
        return this.fReceivingNode;
    }

    @Override
    public ReturnStatus getReturnStatus() {
        return this.fResult == null ? null : this.fResult.getReturnStatus();
    }

    @Override
    public Date getStartTime() {
        return (Date)this.fStartTime.clone();
    }

    @Override
    public Date getStopTime() {
        return (Date)this.fStopTime.clone();
    }

    @Override
    public String getMessage() {
        return this.fResult.toString();
    }

    @Override
    public String getName() {
        return this.getDescription();
    }

    boolean isPending() {
        return this.fTestStatus == TestStatus.PENDING;
    }

    boolean isRunning() {
        return this.fTestStatus == TestStatus.RUNNING;
    }

    boolean isFinished() {
        return this.fTestStatus == TestStatus.FINISHED;
    }

    void setPending() {
        this.fTestStatus = TestStatus.PENDING;
    }

    void setRunning() {
        this.fTestStatus = TestStatus.RUNNING;
    }

    void setFinished() {
        this.fTestStatus = TestStatus.FINISHED;
    }

    String getDescription() {
        return this.fDescription;
    }

    void setDescription(String string) {
        this.fDescription = string;
    }

    Result getResult() {
        return this.fResult;
    }

    void setResult(Result result) {
        this.fResult = result;
    }

    void setStartTime(Date date) {
        this.fStartTime = date;
    }

    void setStopTime(Date date) {
        this.fStopTime = date;
    }

    public String toString() {
        String string = this.getExecutingNode().isLocal() ? "client" : this.getExecutingNode().getHostname();
        String string2 = this.getReceivingNode().isLocal() ? "client" : this.getReceivingNode().getHostname();
        String string3 = this.getDescription() + " (" + (Object)((Object)this.getTestCategory()) + ")" + " (" + string + " -> " + string2 + ")";
        if (this.getReturnStatus() != null) {
            string3 = string3 + ": " + (Object)((Object)this.getReturnStatus());
        }
        return string3;
    }
}

