/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcessInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.CheckpointDirInfo;
import com.mathworks.toolbox.distcomp.util.RemoteSystemProperty;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;

public final class ControlWorker
extends ControlStartStopProcess {
    private static final long serialVersionUID = 1L;
    private RemoteSystemProperty fJobmanager;
    private RemoteSystemProperty fLookupHosts;
    private ControlWorkerInfo fInfo;
    private boolean fCreateNewDefaultName = false;
    private static final String sMsgNoLookupSpecifiedFallbackOnMulticast = "Using multicast to locate the job manager because neither the command\nline arguments nor the mdce_def file specifies the job manager hostname or\nhow to locate the job manager. This warning will not appear if you use\neither the -jobmanagerhost or -multicast flag.\nFor more information, run the startworker command with the -help flag.";

    protected ControlWorker() {
    }

    @Override
    protected String getDefaultServiceName() {
        String string = System.getProperty("com.mathworks.toolbox.distcomp.default_worker_name", "");
        int n = 2;
        int n2 = this.fCreateNewDefaultName ? CheckpointDirInfo.getLastAssignedNumber(string) + 1 : CheckpointDirInfo.getLastAssignedNumber(string);
        if (n2 == 0) {
            return string;
        }
        return string + String.format("%0" + n + "d", n2);
    }

    @Override
    protected void preRunSetup(WarningAndNoteInfo warningAndNoteInfo) {
        super.preRunSetup(warningAndNoteInfo);
        String string = System.getProperty("com.mathworks.toolbox.distcomp.default_jobmanager_name", "");
        this.fJobmanager.setDefaultValue(string);
        this.fJobmanager.exportValueIfNeeded();
        if (this.isStarting()) {
            this.prepareLookupHostsForExport(warningAndNoteInfo);
            this.fLookupHosts.exportValueIfNeeded();
        }
        this.fInfo.setJobmanager(this.fJobmanager.getValue());
    }

    @Override
    protected void postRunTeardown() {
        this.fJobmanager.restoreValueIfNeeded();
        if (this.isStarting()) {
            this.fLookupHosts.restoreValueIfNeeded();
        }
        super.postRunTeardown();
    }

    public ControlWorker(ConfigRunner configRunner, boolean bl, String string, String string2, String string3) {
        super(configRunner, bl, string, string2);
        this.fJobmanager = new RemoteSystemProperty("com.mathworks.toolbox.distcomp.jobmanagername", string3);
        this.fLookupHosts = new RemoteSystemProperty("com.mathworks.toolbox.distcomp.lookup_hosts", "WORKER_LOOKUP_NOT_SPECIFIED");
        this.fInfo = new ControlWorkerInfo();
    }

    public ControlWorker(ConfigRunner configRunner, boolean bl, String string, String string2, String string3, boolean bl2) {
        this(configRunner, bl, string, string2, string3);
        this.fCreateNewDefaultName = bl2;
    }

    public void setLookupHosts(String string) {
        if (string != null && string.length() > 0) {
            this.fLookupHosts.setValue(string);
        }
    }

    @Override
    public ControlStartStopProcessInfo getInfo() {
        return this.fInfo;
    }

    private void prepareLookupHostsForExport(WarningAndNoteInfo warningAndNoteInfo) {
        boolean bl;
        boolean bl2 = bl = !"WORKER_LOOKUP_NOT_SPECIFIED".equals(this.fLookupHosts.getValue());
        if (bl) {
            return;
        }
        String string = System.getProperty("com.mathworks.toolbox.distcomp.lookup_hosts", "");
        boolean bl3 = "MDCE_LOOKUP_NOT_SPECIFIED".equals(string);
        if (bl3) {
            warningAndNoteInfo.addWarning(sMsgNoLookupSpecifiedFallbackOnMulticast);
            this.fLookupHosts.setValue("USE_MULTICAST");
        } else {
            this.fLookupHosts.setValue(null);
        }
    }

    private class ControlWorkerInfo
    extends ControlStartStopProcessInfo {
        private static final long serialVersionUID = 1L;
        private String fJobmanager;

        private ControlWorkerInfo() {
        }

        public void setJobmanager(String string) {
            this.fJobmanager = string;
        }

        public String getJobmanager() {
            return this.fJobmanager;
        }

        @Override
        public String getStartSuccessDescription() {
            return "Started the MATLAB worker " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".  " + "This worker is configured to register with the job manager\n" + this.getJobmanager() + ".";
        }

        @Override
        public String getStopSuccessDescription() {
            return "Stopped the MATLAB worker " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".";
        }

        @Override
        public String getPreStartDescription() {
            return "Contacting the mdce service on the host " + this.getRemoteHostname() + "\n" + "to start a MATLAB worker.";
        }

        @Override
        public String getPreStopDescription() {
            return "Contacting the mdce service on the host " + this.getRemoteHostname() + "\n" + "to stop a MATLAB worker.";
        }

        @Override
        public String getStartNotNeededDescription() {
            return "Did not have to start the worker " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".";
        }

        @Override
        public String getStopNotNeededDescription() {
            return "Did not have to stop the worker " + this.getServiceName() + " on the host\n" + this.getRemoteHostname() + ".";
        }
    }
}

