/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

public class PortConfig {
    public static final int MAX_PORT = 65535;
    public static final int DEFAULT_BASE_PORT = 27350;
    private static final int NUM_RESERVED_PORTS = 5;
    private static final int LOOKUP_UNICAST_PORT_OFFSET = 0;
    private static final int LOOKUP_EXPORT_PORT_OFFSET = 1;
    private static final int REMOTE_COMMAND_PORT_OFFSET = 2;
    private static final int PHOENIX_PORT_OFFSET = 3;
    private static final int REMOTE_EXECUTION_PORT_OFFSET = 4;
    private static final int CLIENT_SESSION_PORT_OFFSET = 20;
    private static final int PMODE_PORT_OFFSET = 21;

    public static int getLookupUnicastPort(String string) {
        return PortConfig.getBasePort(string) + 0;
    }

    public static int getLookupExportPort(String string) {
        return PortConfig.getBasePort(string) + 1;
    }

    public static int getRemoteCommandPort(String string) {
        return PortConfig.getBasePort(string) + 2;
    }

    public static int getDefaultRemoteCommandPort() {
        return 27352;
    }

    public static int getPhoenixPort(String string) {
        return PortConfig.getBasePort(string) + 3;
    }

    public static int getMinDistcompServiceExportPort(String string) {
        return PortConfig.getBasePort(string) + 5;
    }

    public static int getMinClientSessionExportPort(String string) {
        return PortConfig.getBasePort(string) + 20;
    }

    public static int getPmodePort(String string) {
        return PortConfig.getBasePort(string) + 21;
    }

    public static int getBasePortFromRemoteCommandPort(int n) {
        return n - 2;
    }

    public static int getRemoteExecutionPort(int n) {
        return n + 4;
    }

    private static int getBasePort(String string) {
        int n = 27350;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("baseport must be an integer. Check the command flags and the mdce_def file: " + string);
        }
        if (n < 1 || n > 65530) {
            throw new IllegalArgumentException("baseport must be between 1 and 65530. Check the command flags and the mdce_def file: " + string);
        }
        return n;
    }
}

