/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.control.CommandConfigParser;
import com.mathworks.toolbox.distcomp.control.CommandSender;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.StatusCommand;
import com.mathworks.toolbox.distcomp.control.StatusResults;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.WarningAndNoteInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.cert.CertificateException;
import net.jini.config.ConfigurationException;

public class RunCommandSender {
    public static void main(String[] stringArray) {
        Object object;
        MDCSCommand mDCSCommand = null;
        String string = null;
        ErrorPrinterImpl errorPrinterImpl = new ErrorPrinterImpl();
        int n = 0;
        boolean bl = false;
        try {
            object = new ConfigFileWrapper(stringArray);
            mDCSCommand = CommandConfigParser.createMDCSCommand((ConfigFileWrapper)object);
            string = CommandConfigParser.getRemoteHostname((ConfigFileWrapper)object);
            n = CommandConfigParser.getRemotePort((ConfigFileWrapper)object);
            bl = CommandConfigParser.isVerbose((ConfigFileWrapper)object);
        }
        catch (ConfigurationException configurationException) {
            boolean bl2 = false;
            errorPrinterImpl.printThrowable(configurationException, bl2);
            System.exit(1);
        }
        RunCommandSender.installCertificateIfSystemPropertySet(errorPrinterImpl, bl);
        if (bl) {
            System.out.println(mDCSCommand.getPreRunDescription() + "\n");
        }
        object = null;
        try {
            object = CommandSender.sendAndRunCommand(mDCSCommand, string, n);
        }
        catch (Exception exception) {
            errorPrinterImpl.printError(exception);
            System.exit(1);
        }
        if (object instanceof DisplayableResults) {
            WarningAndNoteInfo warningAndNoteInfo;
            DisplayableResults displayableResults = (DisplayableResults)object;
            String string2 = displayableResults.getOutputForDisplay();
            if (string2.length() > 0) {
                System.out.println(string2);
            }
            if ((warningAndNoteInfo = displayableResults.getWarnings()) != null) {
                warningAndNoteInfo.printAllWarningsAndNotesToSystemOut();
            }
            if (bl) {
                System.out.println(displayableResults.getPostRunDescription() + "\n");
            }
        }
        System.exit(0);
    }

    private static void installCertificateIfSystemPropertySet(ErrorPrinter errorPrinter, boolean bl) {
        String string = "com.mathworks.toolbox.distcomp.control.certificate_file";
        String string2 = System.getProperty(string);
        if (string2 != null && !string2.isEmpty()) {
            try {
                if (bl) {
                    System.out.println("Using certificate from " + string2 + "\n");
                }
                File file = new File(string2);
                String string3 = RunCommandSender.class.getSimpleName();
                ClientCertificateStore.getInstance().setCertificateEntry(string3, file);
            }
            catch (CertificateException certificateException) {
                errorPrinter.printError("Certificate '" + string2 + "' is not valid.", certificateException.getLocalizedMessage());
                System.exit(1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                errorPrinter.printError("Certificate '" + string2 + "' can not be found.", fileNotFoundException.getLocalizedMessage());
                System.exit(1);
            }
        }
    }

    public static StatusResults getStatusResults(String string, int n) {
        MDCSCommandResults mDCSCommandResults;
        StatusCommand statusCommand = new StatusCommand(0);
        try {
            int n2 = PortConfig.getRemoteCommandPort(Integer.toString(n));
            mDCSCommandResults = CommandSender.sendAndRunCommand(statusCommand, string, n2);
        }
        catch (Exception exception) {
            return null;
        }
        if (!(mDCSCommandResults instanceof StatusResults)) {
            return null;
        }
        return (StatusResults)mDCSCommandResults;
    }
}

